#include "available-stubs.h"

#include <sys/types.h>
#include <sys/statvfs.h>
#include "checker_api.h"

#ifdef HAVE_chkr_func
void
stubs_chkr_set_right_struct_statvfs (struct statvfs *buf, int right)
{
  stubs_chkr_set_right (&buf->f_bsize, sizeof (buf->f_bsize), right);
  stubs_chkr_set_right (&buf->f_frsize, sizeof (buf->f_frsize), right);

  stubs_chkr_set_right (&buf->f_blocks, sizeof (buf->f_blocks), right);

  stubs_chkr_set_right (&buf->f_bfree, sizeof (buf->f_bfree), right);
  stubs_chkr_set_right (&buf->f_bavail, sizeof (buf->f_bavail), right);
  stubs_chkr_set_right (&buf->f_files, sizeof (buf->f_files), right);
  stubs_chkr_set_right (&buf->f_ffree, sizeof (buf->f_ffree), right);
  stubs_chkr_set_right (&buf->f_favail, sizeof (buf->f_bavail), right);
  stubs_chkr_set_right (&buf->f_fsid, sizeof (buf->f_fsid), right);

  stubs_chkr_set_right (&buf->f_basetype, strncharlen (buf->f_basetype, FSTYPSZ),
			right);
  stubs_chkr_set_right (&buf->f_flag, sizeof (buf->f_flag), right);
  stubs_chkr_set_right (&buf->f_namemax, sizeof (buf->f_namemax), right);
  stubs_chkr_set_right (&buf->f_fstr, strncharlen (buf->f_fstr, 32),
			right);
}
#endif

#ifdef HAVE_statvfs
/* From `/usr/include/sys/statvfs.h:49'.  */
int chkr_stub_statvfs (const char *path, struct statvfs *buf)
     __asm__ (CHKR_PREFIX ("statvfs"));
int
chkr_stub_statvfs (const char *path, struct statvfs *buf)
{
  int res;

  stubs_chkr_check_str (path, CHKR_RO, "path");
  stubs_chkr_check_addr (buf, sizeof (struct statvfs), CHKR_MW, "buf");

  res = statvfs (path, buf);
  if (res >= 0)
    stubs_chkr_set_right_struct_statvfs (buf, CHKR_RW);
  return res;
}
#endif /* HAVE_statvfs */

#ifdef HAVE_fstatvfs
/* From `/usr/include/sys/statvfs.h:50'.  */
int chkr_stub_fstatvfs (int fd, struct statvfs *buf)
     __asm__ (CHKR_PREFIX ("fstatvfs"));
int
chkr_stub_fstatvfs (int fd, struct statvfs *buf)
{
  int res;

  fd_used_by_prog (fd);
  stubs_chkr_check_addr (buf, sizeof (struct statvfs), CHKR_MW, "buf");

  res = fstatvfs (fd, buf);
  if (res >= 0)
    stubs_chkr_set_right_struct_statvfs (buf, CHKR_RW);
  return res;
}
#endif /* HAVE_fstatvfs */

