#include "available-stubs.h"

#include <sys/types.h>
#include <sys/vfs.h>
#include "checker_api.h"

#ifdef HAVE_chkr_func
void
stubs_chkr_set_right_struct_statfs (struct statfs *buf, int right)
{
  stubs_chkr_set_right (&buf->f_type, sizeof (buf->f_type), right);
  stubs_chkr_set_right (&buf->f_bsize, sizeof (buf->f_bsize), right);
  stubs_chkr_set_right (&buf->f_blocks, sizeof (buf->f_blocks), right);
  stubs_chkr_set_right (&buf->f_bfree, sizeof (buf->f_bfree), right);
  stubs_chkr_set_right (&buf->f_bavail, sizeof (buf->f_bavail), right);
  stubs_chkr_set_right (&buf->f_files, sizeof (buf->f_files), right);
  stubs_chkr_set_right (&buf->f_ffree, sizeof (buf->f_ffree), right);
  stubs_chkr_set_right (&buf->f_fsid, sizeof (buf->f_fsid), right);
  stubs_chkr_set_right (&buf->f_namelen, sizeof (buf->f_namelen), right);
}
#endif

/* compiled from: . */
#ifdef HAVE___statfs
/* From `/usr/include/sys/vfs.h:9'.  */
int chkr_stub___statfs (const char * arg0, struct statfs * arg1) __asm__ (CHKR_PREFIX ("__statfs"));
int
chkr_stub___statfs (const char * arg0, struct statfs * arg1)
{
  /* This function requires a stub */
  stubs_chkr_check_addr (arg0, sizeof (char), CHKR_RO, "arg0");
  stubs_chkr_check_addr (arg1, sizeof (struct statfs), CHKR_XX, "arg1");
#if USE_BI_JUMP
  __builtin_jump (__statfs);
#else
  return __statfs (arg0, arg1);
  {
    int res;
    res = __statfs (arg0, arg1);
    return res;
  }
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE___statfs */

#ifdef HAVE_statfs
/* From `/usr/include/sys/vfs.h:10'.  */
int chkr_stub_statfs (const char *path, struct statfs *buf) __asm__ (CHKR_PREFIX ("statfs"));
int
chkr_stub_statfs (const char *path, struct statfs *buf)
{
  int res;

  stubs_chkr_check_str (path, CHKR_RO, "path");
  stubs_chkr_check_addr (buf, sizeof (struct statfs), CHKR_MW, "buf");

  res = statfs (path, buf);
  return res;
}
#endif /* HAVE_statfs */

#ifdef HAVE___fstatfs
/* From `/usr/include/sys/vfs.h:12'.  */
int chkr_stub___fstatfs (int arg0, struct statfs * arg1) __asm__ (CHKR_PREFIX ("__fstatfs"));
int
chkr_stub___fstatfs (int arg0, struct statfs * arg1)
{
  /* This function requires a stub */
  stubs_chkr_check_addr (arg1, sizeof (struct statfs), CHKR_XX, "arg1");
#if USE_BI_JUMP
  __builtin_jump (__fstatfs);
#else
  return __fstatfs (arg0, arg1);
  {
    int res;
    res = __fstatfs (arg0, arg1);
    return res;
  }
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE___fstatfs */

#ifdef HAVE_fstatfs
/* From `/usr/include/sys/vfs.h:13'.  */
int chkr_stub_fstatfs (int arg0, struct statfs * arg1) __asm__ (CHKR_PREFIX ("fstatfs"));
int
chkr_stub_fstatfs (int arg0, struct statfs * arg1)
{
  /* This function requires a stub */
  stubs_chkr_check_addr (arg1, sizeof (struct statfs), CHKR_XX, "arg1");
#if USE_BI_JUMP
  __builtin_jump (fstatfs);
#else
  return fstatfs (arg0, arg1);
  {
    int res;
    res = fstatfs (arg0, arg1);
    return res;
  }
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_fstatfs */

