#include "available-stubs.h"

#include <syslog.h>
#include <stdarg.h>
#include "checker_api.h"
#include "check-printf.h"

/* compiled from: . */
#ifdef HAVE_closelog
/* From `/usr/include/sys/syslog.h:176'.  */
void chkr_stub_closelog (void ) __asm__ (CHKR_PREFIX ("closelog"));
void
chkr_stub_closelog (void )
{
#if USE_BI_JUMP
  __builtin_jump (closelog);
#else
  closelog ();
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_closelog */

#ifdef HAVE_openlog
/* From `/usr/include/sys/syslog.h:180'.  */
void chkr_stub_openlog (const char * arg0, int arg1, int arg2) __asm__ (CHKR_PREFIX ("openlog"));
void
chkr_stub_openlog (const char * arg0, int arg1, int arg2)
{
  /* This function requires a stub */
  stubs_chkr_check_str (arg0, CHKR_RO, "ident");
#if USE_BI_JUMP
  __builtin_jump (openlog);
#else
  openlog (arg0, arg1, arg2);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_openlog */

#ifdef HAVE_setlogmask
/* From `/usr/include/sys/syslog.h:183'.  */
int chkr_stub_setlogmask (int arg0) __asm__ (CHKR_PREFIX ("setlogmask"));
int
chkr_stub_setlogmask (int arg0)
{
#if USE_BI_JUMP
  __builtin_jump (setlogmask);
#else
  return setlogmask (arg0);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_setlogmask */

#ifdef HAVE_syslog
/* From `/usr/include/sys/syslog.h:186'.  */
void chkr_stub_syslog (int arg0, const char * arg1, ... ) __asm__ (CHKR_PREFIX ("syslog"));
void
chkr_stub_syslog (int arg0, const char * arg1, ... )
{
  va_list args;

  va_start (args, arg1);
  check_printf_format ("syslog", arg1, args, TYPE_PRINTF, 0);
  return vsyslog (arg0, arg1, args);
}
#endif /* HAVE_syslog */

#ifdef HAVE_vsyslog
/* From `/usr/include/sys/syslog.h:191'.  */
void chkr_stub_vsyslog (int arg0, const char * arg1, __gnuc_va_list arg2) __asm__ (CHKR_PREFIX ("vsyslog"));
void
chkr_stub_vsyslog (int arg0, const char * arg1, va_list args)
{
  check_printf_format ("syslog", arg1, args, TYPE_PRINTF, 0);
  return vsyslog (arg0, arg1, args);
}
#endif /* HAVE_vsyslog */

