------------------------------------------------------------------------------
--                                                                          --
--                            GCH COMPONENTS                                --
--                                                                          --
--                         G C H . O P T I O N S                            --
--                                                                          --
--                              S p e c                                     --
--                                                                          --
--                                                                          --
--              Copyright (c) 1999, Vitali Sh.Kaufman.                      --
--                                                                          --
--  Gch is distributed as free software; that is with full sources          --
--  and in the hope that it will be useful, but WITHOUT ANY WARRANTY;       --
--  without even the implied warranty of MERCHANTABILITY or FITNESS         --
--  FOR A PARTICULAR PURPOSE. You can freely copy, modify and redistribute  --
--  this software, provided that full sources are available for the version --
--  being distribute (original and modified), and for a modified version,   --
--  any changes that you have made are clearly indicated.                   --
--                                                                          --
--  Gch was developed by Vitali Sh. Kaufman using a prototype               --
--  and consultations by Sergey I. Rybin.                                   --
------------------------------------------------------------------------------

--  This package defines flags and objects for representing Gch options

package Gch.Options is
   ---------------------
   -- Gch options --
   ---------------------

   Verbose_Mode : Boolean := True;
   --  If Verbose_Mode is set ON, Gch produces its version information and
   --  in case of processing more then one source (as a result of a wild card
   --  given in its command line) it outputs names of the units being checked

   Gnat_Mode : Boolean := True;
   --  If Gnat_Mode is set ON, Gch produces diagnostics using the Gnat style
   --  file: line: column: violation
   --  adding a single line of violating source exactly in case of Verbose_Mode

   Check_GNAT_Style : Boolean := False;
   --  If this flag is set ON, GNAT is called with '-gnatg' flag when called
   --  to create a tree. (That is, if a GNAT style error is detected, no tree
   --  is created and no Gch is run for a given source

   Create_Object : Boolean := True;
   --  This flag says if in case if no rule violation has been detected, the
   --  source should be recompiled  to create an object file

   Delete_Tree_Mode : Boolean := True;
   --  This flag indicates if Gch should delete tree and ali files.

   Hide_Rejected_Files : Boolean := True;
   --  This flag indicates if Gch should hide diagnostics telling that a file
   --  is rejected to check (e.g. since unacceptable naming).

   Show_Global_Statistics : Boolean := True;
   --  This flag indicates if Gch should show global statistics concerning
   --  all processed files.

   type Warning_Mode_Type is (Ignore, Warning, Error);

   Warning_Mode : Warning_Mode_Type := Warning;
   --  depending on Warning_Mode, warning output is either suppressed (Ignore),
   --  produced as warning about a possible rule violation (Warning) or as
   --  an actual rule violation (Error)

   Check_Predefined : Boolean := False;
   --  flag indicating if prefefined compilation units should be checked
   --  (note, that Standard is never checked)

   Check_RTL : Boolean := False;
   --  flag indicating if implementation-specific Compilation Units
   --  (RTL components) should be checked

   Output_Elements : Boolean := True;
   --  flag indicating if Element image should be outputted as a part of
   --  an error/warning message

   Infrequently_Used_Subprograms : Positive := 5;
      --  Meaning of "infrequently used"
      --  Can be changed by setting from Gch.ini

   Many_Formal_Parameters : Positive := 3;
      --  Meaning of "many formal parameters"
      --  Can be changed by setting from Gch.ini

   Lines_Between_Infrequently_Used_Calls : Positive := 25;
      --  not used yet
      --  A different meaning of "infrequently used"
      --  Can be changed by setting from Gch.ini

end Gch.Options;