------------------------------------------------------------------------------
--                                                                          --
--                            GCH COMPONENTS                                --
--                                                                          --
--                          G C H . R U L E S                               --
--                                                                          --
--                             QS_4_3_1_10                                  --
--                                                                          --
--              Copyright (c) 1999, Vitali Sh.Kaufman.                      --
--                                                                          --
--  Gch is distributed as free software; that is with full sources          --
--  and in the hope that it will be useful, but WITHOUT ANY WARRANTY;       --
--  without even the implied warranty of MERCHANTABILITY or FITNESS         --
--  FOR A PARTICULAR PURPOSE. You can freely copy, modify and redistribute  --
--  this software, provided that full sources are available for the version --
--  being distribute (original and modified), and for a modified version,   --
--  any changes that you have made are clearly indicated.                   --
--                                                                          --
--  Gch was developed by Vitali Sh. Kaufman using a prototype               --
--  and consultations by Sergey I. Rybin.                                   --
------------------------------------------------------------------------------
------------------
-- QS_4_3_1_10  --
------------------

--  As a rule to check we use the following:
--  "Do not explicitly raise predefined or implementation-defined exceptions".

with Ada.Strings.Wide_Unbounded;      use Ada.Strings.Wide_Unbounded;
with Asis.Extensions.Flat_Kinds;      use Asis.Extensions.Flat_Kinds;

separate (Gch.Rules)
function QS_4_3_1_10 (E :  Asis.Element) return Boolean is
   Arg_Kind : Flat_Element_Kinds := Flat_Element_Kind (E);
    --  Kind of the Element being visited.

   TempEl : Asis.Element;  -- a temp for elements
   TempUnit : Asis.Compilation_Unit;  -- a temp for units

   -- local function to simplify analysis
   function Analysis (Raised : Asis.Element) return Boolean;
   function Analysis (Raised : Asis.Element) return Boolean is
   -- this function is recursive to handle renaming and selectors
   begin
         case Expression_Kind (Raised) is
            when An_Identifier =>
               TempEl := Corresponding_Name_Declaration (Raised);

               --  exception renaming?
               if Declaration_Kind (TempEl) = An_Exception_Renaming_Declaration then

                  -- a recursion to get an original exception
                  return Analysis (Renamed_Entity (TempEl));
               end if;
               TempUnit := Enclosing_Compilation_Unit (TempEl);

                -- predefined language and implementation_defined exception?
                -- Unit_Full_Name begins by "Ada" or "System" or "Interfaces"
               return not (Unit_Origin (TempUnit) = A_Predefined_Unit);

            -- a selected component?
            when A_Selected_Component =>
               return Analysis (Selector (Raised));

            -- raising of user-defined exception
            when others => return True;
         end case;  -- of raise statement
   end Analysis;

begin

   case Arg_Kind is

      -- a raise statement
      when A_Raise_Statement =>
               return Analysis (Raised_Exception (E));

      -- nothing concerning exception raising
      when others => return True;
   end case;

exception  -- think more concerning list of exceptions
   when ASIS_Inappropriate_Context          |
        ASIS_Inappropriate_Container        |
        ASIS_Inappropriate_Compilation_Unit |
        ASIS_Inappropriate_Element          |
        ASIS_Inappropriate_Line             |
        ASIS_Inappropriate_Line_Number      |
        ASIS_Failed
         =>
         Report_ASIS_Failure ("QS_4_3_1_10");
         return True;
end QS_4_3_1_10;