/*
 * Definitions section
 */

%{

#include <stdio.h>
#include <string.h>
#include "genparse.h"

clarg_t *ptr;

extern int yylineno;
extern char *yyfilename;

%}

%union 
{
  char 	 c;	/* single character */
  char   *str;  /* string */
  int    i;
}

%token SLASH BEGIN_RANGE END_RANGE RANGE_SPEC1 RANGE_SPEC2 FUNC_SPEC
%token OPEN_BRACE CLOSE_BRACE POUND INCLUDE LT GT MANDATORY

%token <str> QUOTED C_VAR ALNUM FILENAME
%token <c>   FIRST_CHAR
%token <i>   FLAG INT FLOAT CHAR STRING 

%type <str>  desc long_param callback default
%type <c>    short_param
%type <i>    type 
%%

/*
 * Rules section
 */

all: globals entries
        | entries
        ;

globals: globals global
        | global
        ;

global: include 
        | mandatory 
        | global_callback
        ;

include: POUND INCLUDE LT FILENAME GT { new_include($4); }
        ;

mandatory: POUND MANDATORY C_VAR { set_mandatory($3); }
        ;

global_callback: callback { set_global_callback($1); }
	;

entries: entries entry
	| entry
	;

entry: { new_param(); } new_entry;

new_entry: param
	| param type { set_type($2); }
	| param type { set_type($2); } options
	;

options: options option
	| option
	;

option: default { set_default_val($1); } 
	| range 
	| callback { set_callback($1); }
	| desc { set_desc($1); }
	;

param: short_param { set_short_param($1); }
	| short_param SLASH long_param { set_short_param($1); set_long_param($3); }
	;

short_param: FIRST_CHAR 
	;

long_param: C_VAR 
	;

type: INT { $$ = INT_T; }
	| FLOAT { $$ = FLOAT_T; }
        | STRING { $$ = STRING_T; }
  	| CHAR { $$ = CHAR_T; }
	| FLAG { $$ = FLAG_T; }
	;

default: ALNUM 
	| OPEN_BRACE QUOTED CLOSE_BRACE { $$ = $2; }
	;

range: BEGIN_RANGE contiguous_range END_RANGE 
	/* | BEGIN_RANGE noncontiguous_range END_RANGE */
	;

contiguous_range: ALNUM range_spec more_range { set_low_range($1); }
	| range_spec ALNUM { set_high_range($2); }
        ;

more_range: ALNUM { set_high_range($1); }
	|
	;

range_spec: RANGE_SPEC1 
	| RANGE_SPEC2
	;

/*
noncontiguous_range: noncontiguous_range ALNUM
        | ALNUM 
	;
*/

callback: C_VAR FUNC_SPEC { $$=$1; }
	;

desc: QUOTED 
	;

%%

int yyerror(char *s)
{
  ftlerr("%s in %s:%d",s,yyfilename,yylineno);
  return 1;
}

