/**************************************************************************** 
** File: mytime.c
**
** Author: Mike Borella
**
** Comments: All timing routines are here
**
*****************************************************************************/

#include <stdio.h>
#include <sys/time.h>
#include <unistd.h>
#include <time.h>
#include <malloc.h>
#include <string.h>
#include "mytime.h"
#include "error.h"

#define TIMESTR_LEN 32

/*
 * Keep this global to save memory maintain object-like state
 */

struct mytime *t = NULL;
char timestr[TIMESTR_LEN];


/*----------------------------------------------------------------------------
**
** Function: mytime_gettime()
**
** Comments: returns time split into components
**
**--------------------------------------------------------------------------*/

void mytime_gettime(void)
{
  struct timeval tv;
  
  /*
   * Allocate memory if necessary
   */

  if (!t)
    t = (struct mytime *) malloc (sizeof(struct mytime));

  /*
   * Get the actual time here
   */

  gettimeofday(&tv, (struct timezone *) 0);

  /*
   * Convert them assign to our structures
   */

  t->tp = localtime(&tv.tv_sec);
  t->usec = tv.tv_usec;
}

/*----------------------------------------------------------------------------
**
** Function: mytime_time()
**
** Comments: 
**
**--------------------------------------------------------------------------*/

char *mytime_time(void)
{
  if (t)
    {
      strftime(timestr, TIMESTR_LEN, "%T", t->tp);
      return timestr;
    }
  else
    ftlerr("must get the time before displaying it");
  return timestr;
}

/*----------------------------------------------------------------------------
**
** Function: mytime_day()
**
** Comments: 
**
**--------------------------------------------------------------------------*/

char *mytime_day(void)
{
  if (t)
    {
      strftime(timestr, TIMESTR_LEN, "%A", t->tp);
      return timestr;  
    }
  else
    ftlerr("must get the time before displaying it");
  return timestr;
}

/*----------------------------------------------------------------------------
**
** Function: mytime_month()
**
** Comments: 
**
**--------------------------------------------------------------------------*/

char *mytime_month(void)
{
  if (t)
    {
      strftime(timestr, TIMESTR_LEN, "%B", t->tp);
      return timestr;  
    }
  else
    ftlerr("must get the time before displaying it");
  return timestr;
}

/*----------------------------------------------------------------------------
**
** Function: mytime_usec()
**
** Comments: 
**
**--------------------------------------------------------------------------*/

int mytime_usec(void)
{
  if (t)
    return t->usec;  
  else
    ftlerr("must get the time before displaying it");
  return 0;
}

/*----------------------------------------------------------------------------
**
** Function: mytime_ctime()
**
** Comments: UNIX ctime() styled output
**
**--------------------------------------------------------------------------*/

char *mytime_ctime(void)
{
  time_t tmp;

  if (t)
    {
      tmp = mktime(t->tp);
      strncpy(timestr, ctime(&tmp), TIMESTR_LEN);
      return timestr;  
    }
  else
    ftlerr("must get the time before displaying it");
  return timestr;
}


