/* $Header: /cvs/gnome/gIDE/src/gI_prefs.c,v 1.7 1999/12/05 19:10:48 jpr Exp $ */
/* gIDE
 * Copyright (C) 1998-2000 Steffen Kern
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <config.h>
#include <gnome.h>
#include <stdlib.h>
#include <string.h>
#include <stdio.h>

#include "structs.h"
#include "gI_window.h"
#include "gI_project.h"
#include "gI_file.h"
#include "gI_cfp.h"
#include "gI_common.h"
#include "gI_prefs.h"
#include "gI_document.h"
#include "gI_toolbar.h"

#ifdef HAVE_LIBGUILE
#include <guile/gh.h>
#endif

#ifdef HAVE_GTKTEXT_PATCH
#include <gtksctext.h>
#include "gI_hilite.h"
#endif

/* prototype */
void set_cfg_defaults(void);


/* globals */
static GtkWidget *prefs_window = NULL;
static gI_comp_dialog *cpd;
static GtkWidget *e_make;
static GtkWidget *e_tmpdir;
static GtkWidget *cb_toolbar;
static GtkWidget *cb_toolbar_custom;
static GtkWidget *fr_toolbar_custom;
static GtkWidget *cb_wordwrap;
static GtkWidget *cb_autosave;
static GtkWidget *e_savefreq;
static GtkWidget *c_tbtype;
static GtkWidget *dest_list = NULL;
static GtkWidget *c_bgcol;
static GtkWidget *c_fgcol;
static GtkWidget *e_redit;
static GtkWidget *cb_redit;
static GtkWidget *l_freq;
static GtkWidget *e_ign;
static GtkWidget *cb_hli;
static GtkWidget *cb_prjftree;
static GtkWidget *cb_changelog;
static GtkWidget *cb_remdone;
static GtkWidget *e_tab;
static GtkWidget *e_font;
#ifdef HAVE_GTKTEXT_PATCH
static GtkWidget *e_hli;
static GtkWidget *e_pattern;
#endif
static GtkWidget *fontsel;
static GtkWidget *e_bash;
static GtkWidget *e_xterm;
#ifdef HAVE_GTKTEXT_PATCH
static GtkWidget *cb_edtab;
#endif
/*static GtkWidget *e_ld;*/
static GtkWidget *e_db;
static GtkWidget *e_man;
static GtkWidget *e_email;
static GtkWidget *e_smtp;
static GtkWidget *cb_sor;

static glong kz_toolbar = 0;
static glong kz_toolbar_custom = 0;
static glong kz_autosave = 0;
static glong selected_row = -1;
static glong kz_redit = 0;


/* externs */
extern gI_window *main_window;
extern gchar gide_path[];
extern gI_config *cfg;


/* local prototypes */
static void compile_set_changed( GtkWidget *widget, gI_comp_dialog *cpd );
static void add_compile_sets( gI_comp_dialog *cpd );
static glong compile_set_exist( gchar *cset );
static glong save_compile_sets( gchar *cset_file );
static void add_compile_set( gI_comp_dialog *cpd );
static void update_compile_set( gchar *name, gI_comp_dialog *cpd );


static void prefs_window_destroy( GtkWidget *widget, gpointer data )
{
	gtk_widget_destroy( prefs_window );
	prefs_window = NULL;

	if( fontsel )
		gtk_widget_destroy( fontsel );
	fontsel = NULL;
}


static void cb_toolbar_clicked( GtkWidget *widget, gpointer data )
{
	if( kz_toolbar )
	{
		kz_toolbar = FALSE;
		gtk_widget_set_sensitive( cb_toolbar_custom, FALSE );
		gtk_widget_set_sensitive( fr_toolbar_custom, FALSE );
	}
	else
	{
		kz_toolbar = TRUE;
		gtk_widget_set_sensitive( cb_toolbar_custom, TRUE );
		if( kz_toolbar_custom )
			gtk_widget_set_sensitive( fr_toolbar_custom, TRUE );
	}
}


static void cb_toolbar_custom_clicked( GtkWidget *widget, gpointer data )
{
	if( kz_toolbar_custom )
	{
		kz_toolbar_custom = FALSE;
		gtk_widget_set_sensitive( fr_toolbar_custom, FALSE );
	}
	else
	{
		kz_toolbar_custom = TRUE;
		gtk_widget_set_sensitive( fr_toolbar_custom, TRUE );
	}
}


static void cb_autosave_clicked( GtkWidget *widget, gpointer data )
{
	if( kz_autosave )
	{
		kz_autosave = FALSE;
		gtk_widget_set_sensitive( e_savefreq, FALSE );
		gtk_widget_set_sensitive( l_freq, FALSE );
	}
	else
	{
		kz_autosave = TRUE;
		gtk_widget_set_sensitive( e_savefreq, TRUE );
		gtk_widget_set_sensitive( l_freq, TRUE );
	}
}


static void _update_documents( gI_document *document, gpointer data )
{
	if( !document )
		return;

	gI_text_set_word_wrap( document->text, cfg->wordwrap );

#ifdef HAVE_GTKTEXT_PATCH
	if( cfg->highlight )
	{
		gtk_editor_hilite_when_idle( GTK_EDITOR( document->text ), TRUE );
	}
	else
	{
		gtk_editor_hilite_when_idle( GTK_EDITOR( document->text ), FALSE );
	}
	if( !cfg->edtab )
	{
		GTK_EDITOR( document->text )->one_line_ind = NULL;
	}
#endif

	gI_text_default_tab_width( document->text ) = cfg->tab_width;
	gI_text_tab_stops( document->text ) = NULL;
	gI_text_tab_stops( document->text ) = g_list_prepend( gI_text_tab_stops( document->text ), (void*)cfg->tab_width );
	gI_text_tab_stops( document->text ) = g_list_prepend( gI_text_tab_stops( document->text ), (void*)cfg->tab_width );
}


static void update_documents( gI_window *window )
{
	g_list_foreach( window->documents, (GFunc) _update_documents, NULL );
}


static void update_autosave( gI_window *window )
{
	if( cfg->autosave )
	{
		if( window->timeout_id != 0 )
		{
			gtk_timeout_remove( window->timeout_id );
			window->timeout_id = 0;
		}
		window->timeout_id = gtk_timeout_add( cfg->autosave_freq * 1000, (GtkFunction) file_autosave, (gpointer) window );
	}
	else
	{
		if( window->timeout_id != 0 )
		{
			gtk_timeout_remove( window->timeout_id );
			window->timeout_id = 0;
		}
	}
}


static void update_window( gI_window *window )
{
	/* generate tree for current project */
	if( cfg->prjftree )
	{
		gI_project *project;

		if( window->tree_box )
		{
			/* destroy it, seems the only way to get it away */
			gtk_widget_destroy( window->tree_box );
			window->tree_box = NULL;
			window->tree_frame = NULL;
		}

		project = gI_project_get_current();
		if( project != NULL )
		{
			window->tree_box = gtk_hbox_new( TRUE, 0 );
			gtk_paned_add1( GTK_PANED( window->hpane ), window->tree_box );

			gtk_widget_show( window->tree_box );

			create_prjftree( window );
			project_files_tree( window->tree_viewport, project );
		}
	}

	if( !cfg->disable_font_stuff )
	{
		GdkFont* new_font;
		/* do we really have a style object? */
		if ( !cfg->style )
			cfg->style = gtk_style_new();

		new_font = gdk_font_load( cfg->fontname );
		if( new_font )
		{
			if ( cfg->style->font )
				gdk_font_unref( cfg->style->font );
			cfg->style->font = new_font;
		}
		update_documents_style( main_window );
	}

	gI_create_toolbar( window->window, window->toolbar_box );
	update_documents( window );
	update_autosave( window );
}



#ifdef HAVE_LIBGUILE
static glong save_prefs()
{
	FILE *config, *backup;
	gchar *backupname = g_strconcat ( cfg->cfgfile, "~", NULL);
	gchar *tmp;
	gint i;

	rename ( cfg->cfgfile, backupname );

	/* First we write the prefs to the new config file... */
	config = fopen ( cfg->cfgfile, "w" );
	if (! config ) {
		gI_error_dialog( _("Could not open the config file!") );
		return 0;
	}

	fprintf (config, ";;; gIDE %s Configuration File\n;;;\n", VERSION);
	fprintf (config, ";;; Everything from the beginning of this file and on to\n");
	fprintf (config, ";;; \";;;AUTOMATIC-END\" should not be hand edited, since gIDE\n");
	fprintf (config, ";;; will change this when saving the preferences.\n;;;\n");
	fprintf (config, ";;; Add your hooks after \";;;AUTOMATIC-END\".\n\n");

	fprintf (config, ";; gIDE dir\n");
	fprintf (config, "(define gide-dir (string-append (getenv \"HOME\") "
	         "\"/.gide/\"))\n\n");
	/*   fprintf (config, ";; Compile\n");
	   if (cfg->cc) 
	     fprintf (config, "(define cc \"%s\")\n", cfg->cc);
	   if (cfg->ccopt)
	     fprintf (config, "(define ccopt \"%s\")\n", cfg->ccopt);
	   if (cfg->incpath)
	     fprintf (config, "(define incpath \"%s\")\n", cfg->incpath);
	   fprintf (config, "\n");
	   if (cfg->ld)
	     fprintf (config, "(define ld \"%s\")\n", cfg->ld);
	   if (cfg->ldopt)
	     fprintf (config, "(define ldopt \"%s\")\n", cfg->ldopt);
	   if (cfg->libpath)
	     fprintf (config, "(define libpath \"%s\")\n", cfg->libpath);
	   fprintf (config, "\n");
	 */  
	fprintf (config, ";; Debug\n");
	if( cfg->db )
		fprintf( config, "(define db \"%s\")\n", cfg->db );

	fprintf (config, "\n;; Directories\n");
	if (cfg->tmpdir)
		fprintf (config, "(define tmpdir \"%s\")\n", cfg->tmpdir);

	fprintf (config, "\n;; Editor\n");
	if (cfg->fontname)
		fprintf (config, "(define fontname \"%s\")\n", cfg->fontname);
	/*fprintf (config, "(define disable_font %s)\n",
	  cfg->disable_font_stuff ? "#t" : "#f");*/
	fprintf (config, "(define wordwrap %s)\n",
	         cfg->wordwrap ? "#t" : "#f");
	fprintf (config, "(define autosave %s)\n",
	         cfg->autosave ? "#t" : "#f");
	fprintf (config, "(define autosave-freq %d)\n", cfg->autosave_freq);
	fprintf (config, "(define use-redit %s)\n",
	         cfg->use_redit ? "#t" : "#f");
	if (cfg->redit)
		fprintf (config, "(define redit \"%s\")\n", cfg->redit);
	fprintf (config, "(define highlight %s)\n",
	         cfg->highlight ? "#t" : "#f");
	if (cfg->ign_file)
		fprintf (config, "(define ign-file \"%s\")\n", cfg->ign_file);
	fprintf (config, "(define tab-width %d)\n", cfg->tab_width);
#ifdef HAVE_GTKTEXT_PATCH
	fprintf (config, "(define edtab %s)\n",
	         cfg->edtab ? "#t" : "#f");
#endif

	fprintf (config, "\n;; Misc.\n");
	fprintf (config, "(define toolbar %s)\n",
	         cfg->toolbar ? "#t" : "#f");
	fprintf (config, "(define toolbar-custom %s)\n",
	         cfg->toolbar_custom ? "#t" : "#f");
	fprintf (config, "(define toolbar-custom-list\n\t'(");
	for (i = 0; i < cfg->toolbar_custom_items_no; i++) {
		fprintf (config, "\"%s\" ", cfg->toolbar_custom_items[i]);
	}
	fprintf (config, "))\n");

	if (cfg->bash)
		fprintf (config, "(define bash \"%s\")\n", cfg->bash);
	if (cfg->make)
		fprintf (config, "(define make \"%s\")\n", cfg->make);
	if( cfg->man )
		fprintf( config, "(define man \"%s\")\n", cfg->man );
	if (cfg->xterm)
		fprintf (config, "(define xterm \"%s\")\n", cfg->xterm);
	if( cfg->email )
		fprintf (config, "(define email \"%s\")\n", cfg->email);
	if( cfg->smtp )
		fprintf (config, "(define smtp \"%s\")\n", cfg->smtp);
	if( cfg->sor )
		fprintf( config, "(define sor %s)\n", cfg->sor ? "#t" : "#f" );

	fprintf (config, "\n;; Projects\n");
	fprintf (config, "(define project-file-tree %s)\n",
	         cfg->prjftree ? "#t" : "#f");
	fprintf (config, "(define changelog %s)\n",
	         cfg->changelog ? "#t" : "#f");
	fprintf (config, "(define remove-done %s)\n",
	         cfg->remdone ? "#t" : "#f");

#ifdef HAVE_GTKTEXT_PATCH
	fprintf (config, "\n;; Highlight\n");
	if (cfg->patternfile)
		fprintf (config, "(define pattern-file \"%s\")\n", cfg->patternfile);
	if (cfg->globassocfile)
		fprintf (config, "(define globassoc-file \"%s\")\n", cfg->globassocfile);
	if (cfg->hli_file)
		fprintf (config, "(define highlight-file \"%s\");FIXME\n",
		         cfg->hli_file);

	if (cfg->patternfile) {
		fprintf (config, "\n;; Load Patterns\n");
		fprintf (config, "(load (string-append gide-dir pattern-file))\n");

		tmp = g_strconcat (gide_path, "/", cfg->patternfile, NULL);
		gI_hilite_save_patterns( tmp );
		g_free (tmp);
	}

	if (cfg->globassocfile) {
		fprintf (config, "\n;; Load Globassoc\n");
		fprintf (config, "(load (string-append gide-dir globassoc-file))\n");

		tmp = g_strconcat (gide_path, "/", cfg->patternfile, NULL);
		gI_hilite_save_patterns( tmp );
		g_free (tmp);
	}

	fprintf (config, "\n;;;AUTOMATIC-END\n");
#endif


	/* then we copy the users hooks */
	if ( (backup = fopen (backupname, "r")) ) {
		tmp = g_malloc (MAXLEN);

		while ( fgets (tmp, MAXLEN, backup) ) {
			if (strncmp (tmp, ";;;AUTOMATIC-END", 16) == 0)
				break;			/* end of automatic generated */
		}
		while ( fgets (tmp, MAXLEN, backup) ) {
			fputs (tmp, config);
		}

		g_free (tmp);
		fclose (backup);
	}

	g_free (backupname);
	fclose (config);

	return 1;
}
#else  /* HAVE_LIBGUILE */
static glong save_prefs()
{
	FILE *config;
	glong i;
#ifdef HAVE_GTKTEXT_PATCH
	gchar *tmp;
#endif

	config = fopen( cfg->cfgfile, "w" );
	if( !config )
	{
		gI_error_dialog( _("Unable to Create Config File!") );
		return( 0 );
	}

	fprintf( config, "; gIDE %s - Configuration File\n\n", VERSION );

	/*    fprintf( config, "; Compile\n" );
	fprintf( config, "CC: %s\n", cfg->cc );
	fprintf( config, "INCPATH: !%s!\n", cfg->incpath );
	fprintf( config, "CCOPT: !%s!\n", cfg->ccopt );
	fprintf( config, "LIBPATH: !%s!\n", cfg->libpath );
	fprintf( config, "LDOPT: !%s!\n\n", cfg->ldopt );
	*/
	fprintf( config, "; Debug\n" );
	fprintf( config, "DB: !%s!\n\n", cfg->db );

	fprintf( config, "; Directories\n" );
	fprintf( config, "TMPDIR: %s\n\n", cfg->tmpdir );

	fprintf( config, "; Editor\n" );
	fprintf( config, "FONT: !%s!\n", cfg->fontname );
	fprintf( config, "WORDWRAP: %d\n", cfg->wordwrap );
	fprintf( config, "TAB_WIDTH: %d\n", cfg->tab_width );
#ifdef HAVE_GTKTEXT_PATCH
	fprintf( config, "EDTAB: %d\n", cfg->edtab );
#endif
	fprintf( config, "AUTOSAVE: %d\n", cfg->autosave );
	fprintf( config, "AUTOSAVE_FREQ: %d\n", cfg->autosave_freq );
	fprintf( config, "USE_REDIT: %d !%s!\n", cfg->use_redit, cfg->redit );
	fprintf( config, "HIGHLIGHT: %d\n\n", cfg->highlight );
#ifdef HAVE_GTKTEXT_PATCH
	fprintf( config, "; Highlighting\n" );
	fprintf( config, "PATTERNFILE: !%s!\n", cfg->patternfile );
	fprintf( config, "GLOBASSOCFILE: !%s!\n\n", cfg->globassocfile );
	fprintf( config, "HLI_FILE: !%s!\n\n", cfg->hli_file );
#endif

	fprintf( config, "; Projects\n" );
	fprintf( config, "PRJFTREE: %d\n", cfg->prjftree );
	fprintf( config, "CHANGELOG: %d\n", cfg->changelog );
	fprintf( config, "REMDONE: %d\n\n", cfg->remdone );

	fprintf( config, "; Misc\n" );
	fprintf( config, "TOOLBAR: %d\n", cfg->toolbar );
	fprintf( config, "TOOLBAR_CUSTOM: %d\n", cfg->toolbar_custom );
	fprintf( config, "$TOOLBAR_CUSTOM_ITEMS: %d\n", cfg->toolbar_custom_items_no );
	for(i=0;i<cfg->toolbar_custom_items_no;i++)
		fprintf( config, "%s\n",cfg->toolbar_custom_items[i] );
	fprintf( config, "$END\n" );
	fprintf( config, "IGN_FILE: !%s!\n", cfg->ign_file );
	fprintf( config, "BASH: !%s!\n", cfg->bash );
	fprintf( config, "MAKE: %s\n", cfg->make );
	fprintf( config, "MAN: !%s!\n", cfg->man );
	fprintf( config, "XTERM: !%s!\n", cfg->xterm );
	fprintf( config, "EMAIL: !%s!\n", cfg->email );
	fprintf( config, "SMTP: !%s!\n", cfg->smtp );
	fprintf( config, "SOR: %d\n\n", cfg->sor );

	fclose( config );

#ifdef HAVE_GTKTEXT_PATCH
	tmp = g_strconcat (gide_path, "/", cfg->patternfile, NULL);
	gI_hilite_save_patterns( tmp );
	g_free (tmp);
#endif

	return( 1 );
}
#endif /* HAVE_LIBGUILE */


static void prefs_ok_select( GtkWidget *widget, gpointer data )
{
	gchar *ptr;
	gchar *selected_item[1];
	glong i;

	if( !compile_set_exist( gtk_entry_get_text( GTK_ENTRY( GTK_COMBO( cpd->combo )->entry ) ) ) )
	{
		g_print( "new compile set\n" );
	}

	ptr = gtk_entry_get_text( GTK_ENTRY( cpd->e_compiler ) );
	if( ptr )
	{
		cfg->cc = (gchar *) realloc( cfg->cc, (strlen( ptr ) + 1) * sizeof( gchar ) );
		strcpy( cfg->cc, ptr );
	}

	ptr = gtk_entry_get_text( GTK_ENTRY( e_make ) );
	if( ptr )
	{
		cfg->make = (gchar *) realloc( cfg->make, (strlen( ptr ) + 1) * sizeof( gchar ) );
		strcpy( cfg->make, ptr );
	}

	ptr = gtk_entry_get_text( GTK_ENTRY( e_tmpdir ) );
	if( ptr )
	{
		cfg->tmpdir = (gchar *) realloc( cfg->tmpdir, (strlen( ptr ) + 1) * sizeof( gchar ) );
		strcpy( cfg->tmpdir, ptr );
	}

	if( GTK_TOGGLE_BUTTON( cb_toolbar )->active )
		cfg->toolbar = TRUE;
	else
		cfg->toolbar = FALSE;

	if( GTK_TOGGLE_BUTTON( cb_toolbar_custom )->active )
		cfg->toolbar_custom = TRUE;
	else
		cfg->toolbar_custom = FALSE;

	if( GTK_TOGGLE_BUTTON( cb_wordwrap )->active )
		cfg->wordwrap = TRUE;
	else
		cfg->wordwrap = FALSE;

	if( GTK_TOGGLE_BUTTON( cb_autosave )->active )
		cfg->autosave = TRUE;
	else
		cfg->autosave = FALSE;

	if( GTK_TOGGLE_BUTTON( cb_redit )->active )
		cfg->use_redit = TRUE;
	else
		cfg->use_redit = FALSE;

	ptr = gtk_entry_get_text( GTK_ENTRY( e_redit ) );
	if( ptr )
	{
		cfg->redit = (gchar *) realloc( cfg->redit, (strlen( ptr ) + 1 ) * sizeof( gchar ) );
		strcpy( cfg->redit, ptr );
	}

	ptr = gtk_entry_get_text( GTK_ENTRY( e_savefreq ) );
	if( ptr )
	{
		cfg->autosave_freq = atoi( ptr );
	}

	for(i=0;i<(GTK_CLIST( dest_list )->rows);i++)
	{
		if( i < MAX_TOOLBAR_ITEMS )
		{
			gtk_clist_get_text( GTK_CLIST( dest_list ), i, 0, selected_item );
			cfg->toolbar_custom_items[i] = (gchar *) realloc( cfg->toolbar_custom_items[i], ( strlen( selected_item[0] ) + 1 ) * sizeof( gchar ) );
			strcpy( cfg->toolbar_custom_items[i], selected_item[0] );
		}
		else
			break;
	}

	cfg->toolbar_custom_items_no = i;

	ptr = gtk_entry_get_text( GTK_ENTRY( e_ign ) );
	if( ptr )
	{
		cfg->ign_file = (gchar *) realloc( cfg->ign_file, (strlen( ptr ) + 1) * sizeof( gchar ) );
		strcpy( cfg->ign_file, ptr );
	}

#ifdef HAVE_GTKTEXT_PATCH
	ptr = gtk_entry_get_text( GTK_ENTRY( e_hli ) );
	if( ptr )
	{
		cfg->hli_file = (gchar *) realloc( cfg->hli_file, (strlen( ptr ) + 1) * sizeof( gchar ) );
		strcpy( cfg->hli_file, ptr );
	}
#endif

	if( GTK_TOGGLE_BUTTON( cb_hli )->active )
		cfg->highlight = TRUE;
	else
		cfg->highlight = FALSE;

	if( GTK_TOGGLE_BUTTON( cb_prjftree )->active )
		cfg->prjftree = TRUE;
	else
		cfg->prjftree = FALSE;

	if( GTK_TOGGLE_BUTTON( cb_changelog )->active )
		cfg->changelog = TRUE;
	else
		cfg->changelog = FALSE;

	if( GTK_TOGGLE_BUTTON( cb_remdone )->active )
		cfg->remdone = TRUE;
	else
		cfg->remdone = FALSE;

#ifdef HAVE_GTKTEXT_PATCH
	ptr = gtk_entry_get_text( GTK_ENTRY( e_pattern ) );
	if( ptr )
	{
		cfg->patternfile = (gchar *) realloc( cfg->patternfile, (strlen( ptr ) + 1) * sizeof( gchar ) );
		strcpy( cfg->patternfile, file_strip_name( ptr ) );
	}
#endif

	ptr = gtk_entry_get_text( GTK_ENTRY( e_tab ) );
	if( ptr )
	{
		if( atoi( ptr ) <= 0 )
			cfg->tab_width = 4;
		else
			cfg->tab_width = atoi( ptr );
	}
	ptr = gtk_entry_get_text( GTK_ENTRY( e_font ) );
	if( ptr )
	{
		cfg->fontname = (gchar *) realloc( cfg->fontname, (strlen( ptr ) + 1) * sizeof( gchar ) );
		strcpy( cfg->fontname, ptr );
	}

	ptr = gtk_entry_get_text( GTK_ENTRY( cpd->e_incpath ) );
	if( ptr )
	{
		cfg->incpath = (gchar *) realloc( cfg->incpath, (strlen( ptr ) + 1) * sizeof( gchar ) );
		strcpy( cfg->incpath, ptr );
	}

	ptr = gtk_entry_get_text( GTK_ENTRY( cpd->e_ccopt ) );
	if( ptr )
	{
		cfg->ccopt = (gchar *) realloc( cfg->ccopt, (strlen( ptr ) + 1) * sizeof( gchar ) );
		strcpy( cfg->ccopt, ptr );
	}

	ptr = gtk_entry_get_text( GTK_ENTRY( cpd->e_libpath ) );
	if( ptr )
	{
		cfg->libpath = (gchar *) realloc( cfg->libpath, (strlen( ptr ) + 1) * sizeof( gchar ) );
		strcpy( cfg->libpath, ptr );
	}

	ptr = gtk_entry_get_text( GTK_ENTRY( cpd->e_ldopt ) );
	if( ptr )
	{
		cfg->ldopt = (gchar *) realloc( cfg->ldopt, (strlen( ptr ) + 1) * sizeof( gchar ) );
		strcpy( cfg->ldopt, ptr );
	}

	ptr = gtk_entry_get_text( GTK_ENTRY( e_make ) );
	if( ptr )
	{
		cfg->make = (gchar *) realloc( cfg->make, (strlen( ptr ) + 1) * sizeof( gchar ) );
		strcpy( cfg->make, ptr );
	}

	ptr = gtk_entry_get_text( GTK_ENTRY( e_bash ) );
	if( ptr )
	{
		cfg->bash = (gchar *) realloc( cfg->bash, (strlen( ptr ) + 1) * sizeof( gchar ) );
		strcpy( cfg->bash, ptr );
	}

	ptr = gtk_entry_get_text( GTK_ENTRY( e_xterm ) );
	if( ptr )
	{
		cfg->xterm = (gchar *) realloc( cfg->xterm, (strlen( ptr ) + 1) * sizeof( gchar ) );
		strcpy( cfg->xterm, ptr );
	}

#ifdef HAVE_GTKTEXT_PATCH
	if( GTK_TOGGLE_BUTTON( cb_edtab )->active )
		cfg->edtab = TRUE;
	else
		cfg->edtab = FALSE;
#endif

	ptr = gtk_entry_get_text( GTK_ENTRY( e_db ) );
	if( ptr )
	{
		cfg->db = (gchar *) realloc( cfg->db, (strlen( ptr ) + 1) * sizeof( gchar ) );
		strcpy( cfg->db, ptr );
	}

	ptr = gtk_entry_get_text( GTK_ENTRY( e_man ) );
	if( ptr )
	{
		cfg->man = (gchar *) realloc( cfg->man, (strlen( ptr ) + 1) * sizeof( gchar ) );
		strcpy( cfg->man, ptr );
	}

	ptr = gtk_entry_get_text( GTK_ENTRY( e_email ) );
	if( ptr )
	{
		cfg->email = (gchar *) realloc( cfg->email, (strlen( ptr ) + 1) * sizeof( gchar ) );
		strcpy( cfg->email, ptr );
	}

	ptr = gtk_entry_get_text( GTK_ENTRY( e_smtp ) );
	if( ptr )
	{
		cfg->smtp = (gchar *) realloc( cfg->smtp, (strlen( ptr ) + 1) * sizeof( gchar ) );
		strcpy( cfg->smtp, ptr );
	}

	if( GTK_TOGGLE_BUTTON( cb_sor )->active )
		cfg->sor = TRUE;
	else
		cfg->sor = FALSE;

	ptr = gtk_entry_get_text( GTK_ENTRY( GTK_COMBO( cpd->combo )->entry ) );
	if( !isempty( ptr ) && !compile_set_exist( ptr ) )
	{
		add_compile_set( cpd );
	}
	else
	{
		if( compile_set_exist( ptr ) )
		{
			update_compile_set( ptr, cpd );
		}
	}

	save_compile_sets( CSET_FILE );

	save_prefs();

	prefs_window_destroy( NULL, NULL );

	update_window( main_window );
}


static void dest_list_select( GtkWidget *widget, gint row, gint column, GdkEventButton *bevent )
{
	if( selected_row == -1 )
		selected_row = row;
	else
		selected_row = -1;
}


static void dest_list_clear()
{
	gtk_clist_clear( GTK_CLIST( dest_list ) );
}


static void dest_list_remove()
{
	if( selected_row == -1 )
		return;

	gtk_clist_remove( GTK_CLIST( dest_list ), selected_row );
}


static void dest_list_add()
{
	gchar *ptr;
	gchar *insrow[1];

	ptr = gtk_entry_get_text( GTK_ENTRY( GTK_COMBO( c_tbtype )->entry ) );
	insrow[0] = ptr;

	if( selected_row == -1 )
		gtk_clist_append( GTK_CLIST( dest_list ), insrow );
	else
		gtk_clist_insert( GTK_CLIST( dest_list ), selected_row, insrow );
}


static void cb_redit_clicked( GtkWidget *widget, gpointer data )
{
	if( kz_redit )
	{
		kz_redit = FALSE;
		gtk_widget_set_sensitive( e_redit, FALSE );
	}
	else
	{
		kz_redit = TRUE;
		gtk_widget_set_sensitive( e_redit, TRUE );
	}
}

static void fontsel_ok_select( GtkWidget *widget, gpointer data )
{
	gchar *fontname;

	fontname = gtk_font_selection_dialog_get_font_name( GTK_FONT_SELECTION_DIALOG( fontsel ) );
	gtk_entry_set_text( GTK_ENTRY( e_font ), fontname );
	g_free( fontname );

	gtk_widget_destroy( fontsel );
	fontsel = NULL;
}


static void fontsel_cancel_select( GtkWidget *widget, gpointer data )
{
	gtk_widget_destroy( fontsel );
	fontsel = NULL;
}


static void fontsel_select( GtkWidget *widget, gpointer data )
{
	fontsel = gtk_font_selection_dialog_new( _("Select Font...") );
	gtk_signal_connect( GTK_OBJECT( GTK_FONT_SELECTION_DIALOG( fontsel )->ok_button ), "clicked",
	                    GTK_SIGNAL_FUNC( fontsel_ok_select ), NULL );
	gtk_signal_connect( GTK_OBJECT( GTK_FONT_SELECTION_DIALOG( fontsel )->cancel_button ), "clicked",
	                    GTK_SIGNAL_FUNC( fontsel_cancel_select ), NULL );
	gtk_font_selection_dialog_set_font_name( GTK_FONT_SELECTION_DIALOG( fontsel ), cfg->fontname );
	gtk_widget_show( fontsel );
}


/*
 ---------------------------------------------------------------------
     Function: show_preferences()
     Desc: Callback-Function /Preferences/Preferences...
 ---------------------------------------------------------------------
*/

void show_preferences( GtkWidget *widget, gpointer data )
{
	GtkWidget *notebook;
	GtkWidget *vbox;
	GtkWidget *_vbox;
	GtkWidget *hbox;
	GtkWidget *hsep;
	GtkWidget *button;
	GtkWidget *label;
	GtkWidget *book_vbox;
	GtkWidget *frame;
	GList *list = NULL;
	glong i;
	gchar str[16];
	gchar *insrow[1];
	static gchar *list_items[] = {
	    "New", "Open", "Reload", "Close", "Save", "Print", "Exit", "Undo", "Cut", "Copy",
	    "Paste", "Search", "Preferences", "Help", "Space" };
	static glong nlist_items = sizeof( list_items ) / sizeof( list_items[0] );
#ifdef HAVE_GTKTEXT_PATCH
	gI_pat_dialog *pd;
	GtkWidget *bbox;
#endif
	gI_comp_set *cset;

	if( prefs_window )
		return;

	prefs_window = gtk_window_new( GTK_WINDOW_TOPLEVEL );
	gtk_widget_set_usize( prefs_window, 475, 540 );
	gtk_window_set_title( GTK_WINDOW( prefs_window ), _("Preferences") );
	gtk_signal_connect( GTK_OBJECT( prefs_window ), "destroy",
	                    GTK_SIGNAL_FUNC( prefs_window_destroy ), NULL );

	vbox = gtk_vbox_new( FALSE, 0 );
	gtk_container_add( GTK_CONTAINER( prefs_window ), vbox );
	gtk_widget_show( vbox );

	notebook = gtk_notebook_new();
	gtk_notebook_set_scrollable( GTK_NOTEBOOK( notebook ), TRUE );
	gtk_notebook_set_show_tabs( GTK_NOTEBOOK( notebook ), TRUE );
	gtk_notebook_set_show_border( GTK_NOTEBOOK( notebook ), TRUE );



	/** Real Preferences **/

	/* Compile */

	label = gtk_label_new( _("Compile") );
	book_vbox = gtk_vbox_new( FALSE, 0 );
	gtk_notebook_append_page( GTK_NOTEBOOK( notebook ), book_vbox, label );
	gtk_widget_show( book_vbox );
	gtk_widget_show( label );

	cpd = gI_comp_dialog_new();
	gtk_container_add( GTK_CONTAINER( book_vbox ), cpd->vbox );
	add_compile_sets( cpd );
	gtk_signal_connect( GTK_OBJECT( GTK_COMBO( cpd->combo )->entry ), "changed",
	                    GTK_SIGNAL_FUNC( compile_set_changed ), (gpointer) cpd );

	/* Debug */

	label = gtk_label_new( _("Debug") );
	book_vbox = gtk_vbox_new( FALSE, 0 );
	gtk_notebook_append_page( GTK_NOTEBOOK( notebook ), book_vbox, label );
	gtk_widget_show( book_vbox );
	gtk_widget_show( label );

	frame = gtk_frame_new( _("Programs") );
	gtk_box_pack_start( GTK_BOX( book_vbox ), frame, FALSE, TRUE, 10 );
	gtk_widget_show( frame );

	_vbox = gtk_vbox_new( FALSE, 0 );
	gtk_container_add( GTK_CONTAINER( frame ), _vbox );
	gtk_widget_show( _vbox );

	hbox = gtk_hbox_new( FALSE, 0 );
	gtk_box_pack_start( GTK_BOX( _vbox ), hbox, FALSE, TRUE, 10 );
	gtk_widget_show( hbox );

	label = gtk_label_new( _("GNU DB") );
	gtk_box_pack_start( GTK_BOX( hbox ), label, FALSE, TRUE, 5 );
	gtk_widget_show( label );

	e_db = gtk_entry_new_with_max_length( 255 );
	gtk_box_pack_start( GTK_BOX( hbox ), e_db, TRUE, TRUE, 5 );
	gtk_widget_show( e_db );

	/**
	   label = gtk_label_new( "Not Yet Implemented." );
	   gtk_container_add( GTK_CONTAINER( book_vbox ), label );
	   gtk_widget_show( label );
	**/


	/* Editor */

	label = gtk_label_new( _("Editor") );
	book_vbox = gtk_vbox_new( FALSE, 0 );
	gtk_notebook_append_page( GTK_NOTEBOOK( notebook ), book_vbox, label );
	gtk_widget_show( book_vbox );
	gtk_widget_show( label );

	frame = gtk_frame_new( _("Colors") );
	gtk_box_pack_start( GTK_BOX( book_vbox ), frame, FALSE, TRUE, 10 );
	gtk_widget_show( frame );

	_vbox = gtk_vbox_new( FALSE, 0 );
	gtk_container_add( GTK_CONTAINER( frame ), _vbox );
	gtk_widget_show( _vbox );

	hbox = gtk_hbox_new( FALSE, 0 );
	gtk_box_pack_start( GTK_BOX( _vbox ), hbox, FALSE, TRUE, 10 );
	gtk_widget_show( hbox );

	label = gtk_label_new( _("Background") );
	gtk_box_pack_start( GTK_BOX( hbox ), label, FALSE, TRUE, 5 );
	gtk_widget_show( label );
	gtk_widget_set_sensitive( label, FALSE );


	/* combo */
	c_bgcol = gtk_combo_new();
	gtk_box_pack_start( GTK_BOX( hbox ), c_bgcol, FALSE, TRUE, 5 );
	gtk_widget_set_usize( c_bgcol, 125, 25 );
	gtk_widget_set_usize( GTK_COMBO( c_bgcol )->entry, 125, 25 );

	list = NULL;

	list = g_list_append( list, "Black" );
	list = g_list_append( list, "Blue" );
	list = g_list_append( list, "Green" );
	list = g_list_append( list, "Grey" );
	list = g_list_append( list, "White" );

	gtk_combo_set_popdown_strings( GTK_COMBO( c_bgcol ), list );
	gtk_editable_select_region( GTK_EDITABLE( GTK_COMBO( c_bgcol )->entry ), 0, -1 );
	gtk_entry_set_editable( GTK_ENTRY( GTK_COMBO( c_bgcol )->entry ), FALSE );
	gtk_widget_show( c_bgcol );
	gtk_widget_set_sensitive( c_bgcol, FALSE );

	cb_hli = gtk_check_button_new_with_label( _("Highlight") );
	gtk_box_pack_start( GTK_BOX( hbox ), cb_hli, FALSE, TRUE, 20 );
	gtk_widget_show( cb_hli );

	hbox = gtk_hbox_new( FALSE, 0 );
	gtk_box_pack_start( GTK_BOX( _vbox ), hbox, FALSE, TRUE, 10 );
	gtk_widget_show( hbox );
	gtk_widget_set_sensitive( hbox, FALSE );

	label = gtk_label_new( _("Foreground") );
	gtk_box_pack_start( GTK_BOX( hbox ), label, FALSE, TRUE, 5 );
	gtk_widget_show( label );

	c_fgcol = gtk_combo_new();
	gtk_box_pack_start( GTK_BOX( hbox ), c_fgcol, FALSE, TRUE, 5 );
	gtk_widget_set_usize( c_fgcol, 125, 25 );
	gtk_widget_set_usize( GTK_COMBO( c_fgcol )->entry, 125, 25 );

	gtk_combo_set_popdown_strings( GTK_COMBO( c_fgcol ), list );
	gtk_editable_select_region( GTK_EDITABLE( GTK_COMBO( c_fgcol )->entry ), 0, -1 );
	gtk_entry_set_editable( GTK_ENTRY( GTK_COMBO( c_fgcol )->entry ), FALSE );
	gtk_widget_show( c_fgcol );

	if( !cfg->disable_font_stuff )
	{
		frame = gtk_frame_new( _("Font") );
		gtk_box_pack_start( GTK_BOX( book_vbox ), frame, FALSE, TRUE, 10 );
		gtk_widget_show( frame );

		_vbox = gtk_vbox_new( FALSE, 0 );
		gtk_container_add( GTK_CONTAINER( frame ), _vbox );
		gtk_widget_show( _vbox );

		hbox = gtk_hbox_new( FALSE, 0 );
		gtk_box_pack_start( GTK_BOX( _vbox ), hbox, FALSE, TRUE, 10 );
		gtk_widget_show( hbox );

		e_font = gtk_entry_new_with_max_length( 255 );
		gtk_box_pack_start( GTK_BOX( hbox ), e_font, TRUE, TRUE, 3 );
		gtk_widget_show( e_font );
		gtk_entry_set_editable( GTK_ENTRY( e_font ), FALSE );

		button = gtk_button_new_with_label( _("Font Selection Dialog") );
		gtk_box_pack_start( GTK_BOX( hbox ), button, FALSE, TRUE, 3 );
		gtk_signal_connect( GTK_OBJECT( button ), "clicked",
		                    GTK_SIGNAL_FUNC( fontsel_select ), NULL );
		gtk_widget_show( button );
		gtk_widget_set_sensitive( frame, TRUE );
	}


	frame = gtk_frame_new( _("Options") );
	gtk_box_pack_start( GTK_BOX( book_vbox ), frame, FALSE, TRUE, 10 );
	gtk_widget_show( frame );

	_vbox = gtk_vbox_new( FALSE, 0 );
	gtk_container_add( GTK_CONTAINER( frame ), _vbox );
	gtk_widget_show( _vbox );

	hbox = gtk_hbox_new( FALSE, 0 );
	gtk_box_pack_start( GTK_BOX( _vbox ), hbox, FALSE, TRUE, 5 );
	gtk_widget_show( hbox );

	cb_wordwrap = gtk_check_button_new_with_label( _("Word Wrap") );
	gtk_box_pack_start( GTK_BOX( hbox ), cb_wordwrap, FALSE, TRUE, 5 );
	gtk_widget_show( cb_wordwrap );

	label = gtk_label_new( _("Tab Width") );
	gtk_box_pack_start( GTK_BOX( hbox ), label, FALSE, TRUE, 5 );
	gtk_widget_show( label );

	e_tab = gtk_entry_new_with_max_length( 3 );
	gtk_widget_set_usize( e_tab, 30, -1 );
	gtk_box_pack_start( GTK_BOX( hbox ), e_tab, FALSE, TRUE, 5 );
	gtk_widget_show( e_tab );

#ifdef HAVE_GTKTEXT_PATCH
	cb_edtab = gtk_check_button_new_with_label( _("One-Line Indenter") );
	gtk_box_pack_start( GTK_BOX( hbox ), cb_edtab, FALSE, TRUE, 10 );
	gtk_widget_show( cb_edtab );
#endif

	hbox = gtk_hbox_new( FALSE, 0 );
	gtk_box_pack_start( GTK_BOX( _vbox ), hbox, FALSE, TRUE, 5 );
	gtk_widget_show( hbox );

	cb_autosave = gtk_check_button_new_with_label( _("Auto-Save") );
	gtk_box_pack_start( GTK_BOX( hbox ), cb_autosave, FALSE, TRUE, 5 );
	gtk_signal_connect( GTK_OBJECT( cb_autosave ), "clicked",
	                    GTK_SIGNAL_FUNC( cb_autosave_clicked ), NULL );
	gtk_widget_show( cb_autosave );

	l_freq = gtk_label_new( _("Freq.") );
	gtk_box_pack_start( GTK_BOX( hbox ), l_freq, FALSE, TRUE, 5 );
	gtk_widget_show( l_freq );
	gtk_widget_set_sensitive( l_freq, FALSE );

	e_savefreq = gtk_entry_new_with_max_length( 5 );
	gtk_box_pack_start( GTK_BOX( hbox ), e_savefreq, FALSE, TRUE, 10 );
	gtk_widget_show( e_savefreq );
	gtk_widget_set_sensitive( e_savefreq, FALSE );

	frame = gtk_frame_new( _("Replacement-Editor") );
	gtk_box_pack_start( GTK_BOX( book_vbox ), frame, FALSE, TRUE, 10 );
	gtk_widget_show( frame );

	_vbox = gtk_vbox_new( FALSE, 0 );
	gtk_container_add( GTK_CONTAINER( frame ), _vbox );
	gtk_widget_show( _vbox );

	hbox = gtk_hbox_new( FALSE, 0 );
	gtk_box_pack_start( GTK_BOX( _vbox ), hbox, FALSE, TRUE, 5 );
	gtk_widget_show( hbox );

	cb_redit = gtk_check_button_new_with_label( _("Use") );
	gtk_box_pack_start( GTK_BOX( hbox ), cb_redit, FALSE, TRUE, 5 );
	gtk_signal_connect( GTK_OBJECT( cb_redit ), "clicked",
	                    GTK_SIGNAL_FUNC( cb_redit_clicked ), NULL );
	gtk_widget_show( cb_redit );

	hbox = gtk_hbox_new( FALSE, 0 );
	gtk_box_pack_start( GTK_BOX( _vbox ), hbox, FALSE, TRUE, 5 );
	gtk_widget_show( hbox );

	e_redit = gtk_entry_new_with_max_length( 255 );
	gtk_box_pack_start( GTK_BOX( hbox ), e_redit, TRUE, TRUE, 5 );
	gtk_widget_show( e_redit );
	gtk_widget_set_sensitive( e_redit, FALSE );


#ifdef HAVE_GTKTEXT_PATCH
	/* GtkEditor Hilite */
	book_vbox = gtk_vbox_new ( FALSE, 0);
	label = gtk_label_new ( _("Highlight") );
	gtk_notebook_append_page ( GTK_NOTEBOOK ( notebook ), book_vbox, label );

	frame = gtk_frame_new ( _("Highlight Patterns") );
	gtk_box_pack_start ( GTK_BOX (book_vbox ), frame, FALSE, TRUE, 10);
	gtk_widget_show (frame);
	pd = g_new (gI_pat_dialog, 1);
	_vbox = gI_hilite_get_pattern_widget (pd);
	gtk_widget_show ( _vbox );
	gtk_container_add( GTK_CONTAINER( frame ), _vbox );

	bbox = gtk_hbutton_box_new ();
	gtk_button_box_set_layout (GTK_BUTTON_BOX (bbox), GTK_BUTTONBOX_END);

	gtk_box_pack_start( GTK_BOX( _vbox ), bbox, FALSE, TRUE, 5 );
	gtk_widget_show( hbox );

	button = gtk_button_new_with_label( _("Add") );
	gtk_box_pack_start( GTK_BOX( bbox ), button, TRUE, TRUE, 10 );
	gtk_signal_connect( GTK_OBJECT( button ), "clicked",
	                    GTK_SIGNAL_FUNC( gI_hilite_add_pattern_dia_cb ), pd );
	gtk_widget_show ( button );

	button = gtk_button_new_with_label( _("Remove") );
	gtk_box_pack_start( GTK_BOX( bbox ), button, TRUE, TRUE, 10 );
	gtk_signal_connect( GTK_OBJECT( button ), "clicked",
	                    GTK_SIGNAL_FUNC( gI_hilite_remove_pattern_dia_cb ), pd );
	gtk_widget_show ( button );

	frame = gtk_frame_new( _("Files") );
	gtk_box_pack_start( GTK_BOX( book_vbox ), frame, FALSE, TRUE, 10 );
	gtk_widget_show( frame );

	_vbox = gtk_vbox_new( FALSE, 0 );
	gtk_container_add( GTK_CONTAINER( frame ), _vbox );
	gtk_widget_show( _vbox );

	hbox = gtk_hbox_new( FALSE, 0 );
	gtk_box_pack_start( GTK_BOX( _vbox ), hbox, FALSE, TRUE, 10 );
	gtk_widget_show( hbox );

	label = gtk_label_new( _("Highlight-Function List") );
	gtk_box_pack_start( GTK_BOX( hbox ), label, FALSE, TRUE, 5 );
	gtk_widget_show( label );

	e_hli = gtk_entry_new_with_max_length( 255 );
	gtk_box_pack_start( GTK_BOX( hbox ), e_hli, TRUE, TRUE, 5 );
	gtk_widget_show( e_hli );

	hbox = gtk_hbox_new( FALSE, 0 );
	gtk_box_pack_start( GTK_BOX( _vbox ), hbox, FALSE, TRUE, 10 );
	gtk_widget_show( hbox );

	label = gtk_label_new( _("Highlight Patterns") );
	gtk_box_pack_start( GTK_BOX( hbox ), label, FALSE, TRUE, 5 );
	gtk_widget_show( label );

	e_pattern = gtk_entry_new_with_max_length( 255 );
	gtk_box_pack_start( GTK_BOX( hbox ), e_pattern, TRUE, TRUE, 5 );
	gtk_widget_show( e_pattern );

	gtk_widget_show ( bbox );
	gtk_widget_show ( book_vbox );
	gtk_widget_show ( label );
#endif


	/* Projects */
	book_vbox = gtk_vbox_new( FALSE, 0 );
	label = gtk_label_new( _("Projects") );
	gtk_notebook_append_page( GTK_NOTEBOOK( notebook ), book_vbox, label );
	gtk_widget_show( book_vbox );
	gtk_widget_show( label );

	frame = gtk_frame_new( _("Projects") );
	gtk_box_pack_start( GTK_BOX( book_vbox ), frame, FALSE, TRUE, 10 );
	gtk_widget_show( frame );

	_vbox = gtk_vbox_new( FALSE, 0 );
	gtk_container_add( GTK_CONTAINER( frame ), _vbox );
	gtk_widget_show( _vbox );

	hbox = gtk_hbox_new( FALSE, 0 );
	gtk_box_pack_start( GTK_BOX( _vbox ), hbox, FALSE, TRUE, 5 );
	gtk_widget_show( hbox );

	cb_prjftree = gtk_check_button_new_with_label( _("Show Project-File-Tree") );
	gtk_box_pack_start( GTK_BOX( hbox ), cb_prjftree, FALSE, TRUE, 5 );
	gtk_widget_show( cb_prjftree );

	hbox = gtk_hbox_new( FALSE, 0 );
	gtk_box_pack_start( GTK_BOX( _vbox ), hbox, FALSE, TRUE, 5 );
	gtk_widget_show( hbox );

	cb_changelog = gtk_check_button_new_with_label( _("Update ChangeLog automatically") );
	gtk_box_pack_start( GTK_BOX( hbox ), cb_changelog, FALSE, TRUE, 5 );
	gtk_widget_show( cb_changelog );

	hbox = gtk_hbox_new( FALSE, 0 );
	gtk_box_pack_start( GTK_BOX( _vbox ), hbox, FALSE, TRUE, 5 );
	gtk_widget_show( hbox );

	cb_remdone = gtk_check_button_new_with_label( _("Remove \"Done\"-Items automatically") );
	gtk_box_pack_start( GTK_BOX( hbox ), cb_remdone, FALSE, TRUE, 5 );
	gtk_widget_show( cb_remdone );


	/* Misc I */
	book_vbox = gtk_vbox_new( FALSE, 0 );
	label = gtk_label_new( _("Misc I") );
	gtk_notebook_append_page( GTK_NOTEBOOK( notebook ), book_vbox, label );
	gtk_widget_show( book_vbox );
	gtk_widget_show( label );

	frame = gtk_frame_new( _("Toolbar") );
	gtk_box_pack_start( GTK_BOX( book_vbox ), frame, FALSE, TRUE, 10 );
	gtk_widget_show( frame );

	_vbox = gtk_vbox_new( FALSE, 0 );
	gtk_container_add( GTK_CONTAINER( frame ), _vbox );
	gtk_widget_show( _vbox );

	hbox = gtk_hbox_new( FALSE, 0 );
	gtk_box_pack_start( GTK_BOX( _vbox ), hbox, FALSE, TRUE, 5 );
	gtk_widget_show( hbox );

	cb_toolbar = gtk_check_button_new_with_label( _("Show Toolbar") );
	gtk_box_pack_start( GTK_BOX( hbox ), cb_toolbar, FALSE, TRUE, 5 );
	gtk_signal_connect( GTK_OBJECT( cb_toolbar ), "clicked",
	                    GTK_SIGNAL_FUNC( cb_toolbar_clicked ), NULL );
	gtk_widget_show( cb_toolbar );

	hbox = gtk_hbox_new( FALSE, 0 );
	gtk_box_pack_start( GTK_BOX( _vbox ), hbox, FALSE, TRUE, 5 );
	gtk_widget_show( hbox );

	cb_toolbar_custom = gtk_check_button_new_with_label( _("Custom Toolbar") );
	gtk_box_pack_start( GTK_BOX( hbox ), cb_toolbar_custom, FALSE, TRUE, 5 );
	gtk_signal_connect( GTK_OBJECT( cb_toolbar_custom ), "clicked",
	                    GTK_SIGNAL_FUNC( cb_toolbar_custom_clicked ), NULL );
	gtk_widget_show( cb_toolbar_custom );
	gtk_widget_set_sensitive( cb_toolbar_custom, FALSE );

	fr_toolbar_custom = gtk_frame_new( _("Custom Toolbar") );
	gtk_box_pack_start( GTK_BOX( book_vbox ), fr_toolbar_custom, FALSE, TRUE, 10 );
	gtk_widget_show( fr_toolbar_custom );
	gtk_widget_set_sensitive( fr_toolbar_custom, FALSE );

	_vbox = gtk_vbox_new( FALSE, 0 );
	gtk_container_add( GTK_CONTAINER( fr_toolbar_custom ), _vbox );
	gtk_widget_show( _vbox );

	hbox = gtk_hbox_new( FALSE, 0 );
	gtk_box_pack_start( GTK_BOX( _vbox ), hbox, FALSE, TRUE, 10 );
	gtk_widget_show( hbox );


	label = gtk_label_new( _("Your Toolbar: ") );
	gtk_box_pack_start( GTK_BOX( hbox ), label, FALSE, TRUE, 5 );
	gtk_widget_show( label );

	dest_list = gtk_clist_new( 1 );
	gtk_box_pack_start( GTK_BOX( hbox ), dest_list, FALSE, TRUE, 5 );
	gtk_signal_connect( GTK_OBJECT( dest_list ), "select_row",
	                    GTK_SIGNAL_FUNC( dest_list_select ), NULL );
	gtk_signal_connect( GTK_OBJECT( dest_list ), "unselect_row",
	                    GTK_SIGNAL_FUNC( dest_list_select ), NULL );
	gtk_widget_set_usize( dest_list, 125, 75 );
	gtk_widget_show( dest_list );

	c_tbtype = gtk_combo_new();
	gtk_widget_set_usize( c_tbtype, 125, 25 );
	gtk_widget_set_usize( GTK_COMBO( c_tbtype )->entry, 125, 25 );
	gtk_box_pack_start( GTK_BOX( hbox ), c_tbtype, FALSE, TRUE, 5 );

	list = NULL;

	for (i=0;i<nlist_items;i++)
	{
		list = g_list_append( list, list_items[i] );
	}

	gtk_combo_set_popdown_strings( GTK_COMBO( c_tbtype ), list );
	gtk_editable_select_region( GTK_EDITABLE( GTK_COMBO( c_tbtype )->entry ), 0, -1 );
	gtk_entry_set_editable( GTK_ENTRY( GTK_COMBO( c_tbtype )->entry ), FALSE );

	gtk_widget_show( c_tbtype );

	hbox = gtk_hbox_new( FALSE, 0 );
	gtk_box_pack_start( GTK_BOX( _vbox ), hbox, FALSE, TRUE, 10 );
	gtk_widget_show( hbox );

	button = gtk_button_new_with_label( _("  Init  ") );
	gtk_box_pack_start( GTK_BOX( hbox ), button, FALSE, TRUE, 10 );
	gtk_signal_connect( GTK_OBJECT( button ), "clicked",
	                    GTK_SIGNAL_FUNC( dest_list_clear ), NULL );
	gtk_widget_show( button );

	button = gtk_button_new_with_label( _("   Add  ") );
	gtk_box_pack_start( GTK_BOX( hbox ), button, FALSE, TRUE, 10 );
	gtk_signal_connect( GTK_OBJECT( button ), "clicked",
	                    GTK_SIGNAL_FUNC( dest_list_add ), NULL );
	gtk_widget_show( button );

	button = gtk_button_new_with_label( _(" Remove ") );
	gtk_box_pack_start( GTK_BOX( hbox ), button, FALSE, TRUE, 10 );
	gtk_signal_connect( GTK_OBJECT( button ), "clicked",
	                    GTK_SIGNAL_FUNC( dest_list_remove ), NULL );
	gtk_widget_show( button );


	frame = gtk_frame_new( _("Files") );
	gtk_box_pack_start( GTK_BOX( book_vbox ), frame, FALSE, TRUE, 10 );
	gtk_widget_show( frame );

	_vbox = gtk_vbox_new( FALSE, 0 );
	gtk_container_add( GTK_CONTAINER( frame ), _vbox );
	gtk_widget_show( _vbox );

	hbox = gtk_hbox_new( FALSE, 0 );
	gtk_box_pack_start( GTK_BOX( _vbox ), hbox, FALSE, TRUE, 10 );
	gtk_widget_show( hbox );

	label = gtk_label_new( _("Function-Ignore List") );
	gtk_box_pack_start( GTK_BOX( hbox ), label, FALSE, TRUE, 5 );
	gtk_widget_show( label );

	e_ign = gtk_entry_new_with_max_length( 255 );
	gtk_box_pack_start( GTK_BOX( hbox ), e_ign, TRUE, TRUE, 5 );
	gtk_widget_show( e_ign );

	frame = gtk_frame_new( _("Run") );
	gtk_box_pack_start( GTK_BOX( book_vbox ), frame, FALSE, TRUE, 10 );
	gtk_widget_show( frame );

	_vbox = gtk_vbox_new( FALSE, 0 );
	gtk_container_add( GTK_CONTAINER( frame ), _vbox );
	gtk_widget_show( _vbox );

	hbox = gtk_hbox_new( FALSE, 0 );
	gtk_box_pack_start( GTK_BOX( _vbox ), hbox, FALSE, TRUE, 5 );
	gtk_widget_show( hbox );

	cb_sor = gtk_check_button_new_with_label( _("Save/Compile on Run") );
	gtk_box_pack_start( GTK_BOX( hbox ), cb_sor, FALSE, TRUE, 5 );
	gtk_widget_show( cb_sor );

	/* Misc II */
	label = gtk_label_new( _("Misc II") );
	book_vbox = gtk_vbox_new( FALSE, 0 );
	gtk_notebook_append_page( GTK_NOTEBOOK( notebook ), book_vbox, label );
	gtk_widget_show( book_vbox );
	gtk_widget_show( label );

	frame = gtk_frame_new( _("Directories") );
	gtk_box_pack_start( GTK_BOX( book_vbox ), frame, FALSE, TRUE, 10 );
	gtk_widget_show( frame );

	_vbox = gtk_vbox_new( FALSE, 0 );
	gtk_container_add( GTK_CONTAINER( frame ), _vbox );
	gtk_widget_show( _vbox );

	hbox = gtk_hbox_new( FALSE, 0 );
	gtk_box_pack_start( GTK_BOX( _vbox ), hbox, FALSE, TRUE, 10 );
	gtk_widget_show( hbox );

	label = gtk_label_new( _("Temp-Directory") );
	gtk_box_pack_start( GTK_BOX( hbox ), label, FALSE, TRUE, 5 );
	gtk_widget_show( label );

	e_tmpdir = gtk_entry_new_with_max_length( 50 );
	gtk_box_pack_start( GTK_BOX( hbox ), e_tmpdir, TRUE, TRUE, 5 );
	gtk_widget_show( e_tmpdir );

	frame = gtk_frame_new( _("Utilities") );
	gtk_box_pack_start( GTK_BOX( book_vbox ), frame, FALSE, TRUE, 10 );
	gtk_widget_show( frame );

	_vbox = gtk_vbox_new( FALSE, 0 );
	gtk_container_add( GTK_CONTAINER( frame ), _vbox );
	gtk_widget_show( _vbox );

	hbox = gtk_hbox_new( FALSE, 0 );
	gtk_box_pack_start( GTK_BOX( _vbox ), hbox, FALSE, TRUE, 10 );
	gtk_widget_show( hbox );

	/* bash, xterm */
	label = gtk_label_new( "BASH " );
	gtk_box_pack_start( GTK_BOX( hbox ), label, FALSE, TRUE, 5 );
	gtk_widget_show( label );

	e_bash = gtk_entry_new_with_max_length( 255 );
	gtk_box_pack_start( GTK_BOX( hbox ), e_bash, TRUE, TRUE, 5 );
	gtk_widget_show( e_bash );

	hbox = gtk_hbox_new( FALSE, 0 );
	gtk_box_pack_start( GTK_BOX( _vbox ), hbox, FALSE, TRUE, 10 );
	gtk_widget_show( hbox );

	label = gtk_label_new( "Make " );
	gtk_box_pack_start( GTK_BOX( hbox ), label, FALSE, TRUE, 5 );
	gtk_widget_show( label );

	e_make = gtk_entry_new_with_max_length( 255 );
	gtk_box_pack_start( GTK_BOX( hbox ), e_make, TRUE, TRUE, 5 );
	gtk_widget_show( e_make );

	hbox = gtk_hbox_new( FALSE, 0 );
	gtk_box_pack_start( GTK_BOX( _vbox ), hbox, FALSE, TRUE, 10 );
	gtk_widget_show( hbox );

	label = gtk_label_new( "Man  " );
	gtk_box_pack_start( GTK_BOX( hbox ), label, FALSE, TRUE, 5 );
	gtk_widget_show( label );

	e_man = gtk_entry_new_with_max_length( 255 );
	gtk_box_pack_start( GTK_BOX( hbox ), e_man, TRUE, TRUE, 5 );
	gtk_widget_show( e_man );

	hbox = gtk_hbox_new( FALSE, 0 );
	gtk_box_pack_start( GTK_BOX( _vbox ), hbox, FALSE, TRUE, 10 );
	gtk_widget_show( hbox );

	label = gtk_label_new( "XTerm" );
	gtk_box_pack_start( GTK_BOX( hbox ), label, FALSE, TRUE, 5 );
	gtk_widget_show( label );

	e_xterm = gtk_entry_new_with_max_length( 255 );
	gtk_box_pack_start( GTK_BOX( hbox ), e_xterm, TRUE, TRUE, 5 );
	gtk_widget_show( e_xterm );

	frame = gtk_frame_new( _("User/Host Info") );
	gtk_box_pack_start( GTK_BOX( book_vbox ), frame, FALSE, TRUE, 10 );
	gtk_widget_show( frame );

	_vbox = gtk_vbox_new( FALSE, 0 );
	gtk_container_add( GTK_CONTAINER( frame ), _vbox );
	gtk_widget_show( _vbox );

	hbox = gtk_hbox_new( FALSE, 0 );
	gtk_box_pack_start( GTK_BOX( _vbox ), hbox, FALSE, TRUE, 10 );
	gtk_widget_show( hbox );

	/* email address */
	label = gtk_label_new( _("eMail Address") );
	gtk_box_pack_start( GTK_BOX( hbox ), label, FALSE, TRUE, 5 );
	gtk_widget_show( label );

	e_email = gtk_entry_new_with_max_length( 255 );
	gtk_box_pack_start( GTK_BOX( hbox ), e_email, TRUE, TRUE, 5 );
	gtk_widget_show( e_email );

	hbox = gtk_hbox_new( FALSE, 0 );
	gtk_box_pack_start( GTK_BOX( _vbox ), hbox, FALSE, TRUE, 10 );
	gtk_widget_show( hbox );

	/* smtp server */
	label = gtk_label_new( _("SMTP Server (IP)") );
	gtk_box_pack_start( GTK_BOX( hbox ), label, FALSE, TRUE, 5 );
	gtk_widget_show( label );

	e_smtp = gtk_entry_new_with_max_length( 255 );
	gtk_box_pack_start( GTK_BOX( hbox ), e_smtp, TRUE, TRUE, 5 );
	gtk_widget_show( e_smtp );


	gtk_box_pack_start( GTK_BOX( vbox ), notebook, TRUE, TRUE, 5 );
	gtk_widget_show( notebook );


	hsep = gtk_hseparator_new();
	gtk_box_pack_start( GTK_BOX( vbox ), hsep, FALSE, TRUE, 5 );
	gtk_widget_show( hsep );

	hbox = gtk_hbox_new( FALSE, 0 );
	gtk_box_pack_start( GTK_BOX( vbox ), hbox, FALSE, TRUE, 5 );
	gtk_widget_show( hbox );

	button = gnome_stock_button (GNOME_STOCK_BUTTON_OK);
	gtk_box_pack_start( GTK_BOX( hbox ), button, TRUE, TRUE, 15 );
	gtk_signal_connect( GTK_OBJECT( button ), "clicked",
	                    GTK_SIGNAL_FUNC( prefs_ok_select ), NULL );
	gtk_widget_show( button );

	button = gnome_stock_button (GNOME_STOCK_BUTTON_CANCEL);
	gtk_box_pack_end( GTK_BOX( hbox ), button, TRUE, TRUE, 15 );
	gtk_signal_connect( GTK_OBJECT( button ), "clicked",
	                    GTK_SIGNAL_FUNC( prefs_window_destroy ), NULL );
	gtk_widget_show( button );

	/* get compile set */
	cset = gI_comp_set_get( gtk_entry_get_text( GTK_ENTRY( GTK_COMBO( cpd->combo )->entry ) ) );

	/* insert values */
	gtk_entry_set_text( GTK_ENTRY( cpd->e_compiler ), cfg->cc );
	gtk_entry_set_text( GTK_ENTRY( e_make ), cfg->make );
	gtk_entry_set_text( GTK_ENTRY( e_tmpdir ), cfg->tmpdir );
	if( cfg->wordwrap )
	{
		gtk_widget_activate( cb_wordwrap );
	}
	if( cfg->toolbar )
	{
		gtk_widget_activate( cb_toolbar );
		gtk_widget_set_sensitive( cb_toolbar_custom, TRUE );
	}
	if( cfg->toolbar_custom )
	{
		gtk_widget_activate( cb_toolbar_custom );
		gtk_widget_set_sensitive( fr_toolbar_custom, TRUE );
	}
	for(i=0;i<cfg->toolbar_custom_items_no;i++)
	{
		insrow[0] = cfg->toolbar_custom_items[i];
		gtk_clist_append( GTK_CLIST( dest_list ), insrow );
	}
	if( cfg->autosave )
	{
		gtk_widget_activate( cb_autosave );
		gtk_widget_set_sensitive( e_savefreq, TRUE );
		gtk_widget_set_sensitive( l_freq, TRUE );
	}
	if( cfg->autosave_freq )
	{
		g_snprintf( str, 10, "%d", cfg->autosave_freq );
		gtk_entry_set_text( GTK_ENTRY( e_savefreq ), str );
	}
	if( cfg->use_redit )
	{
		gtk_widget_activate( cb_redit );
	}
	gtk_entry_set_text( GTK_ENTRY( e_redit ), cfg->redit );
	gtk_entry_set_text( GTK_ENTRY( e_ign ), cfg->ign_file );
#ifdef HAVE_GTKTEXT_PATCH
	gtk_entry_set_text( GTK_ENTRY( e_hli ), cfg->hli_file );
#endif
#ifdef HAVE_GTKTEXT_PATCH
	if( cfg->highlight )
		gtk_widget_activate( cb_hli );
#else
	gtk_widget_set_sensitive( cb_hli, FALSE );
#endif
	if( cfg->prjftree )
		gtk_widget_activate( cb_prjftree );
	if( cfg->changelog )
		gtk_widget_activate( cb_changelog );
	if( cfg->remdone )
		gtk_widget_activate( cb_remdone );
#ifdef HAVE_GTKTEXT_PATCH
	gtk_entry_set_text( GTK_ENTRY( e_pattern ), cfg->patternfile );
#endif
	g_snprintf( str, 10, "%d", cfg->tab_width );
	gtk_entry_set_text( GTK_ENTRY( e_tab ), str );
	gtk_entry_set_text( GTK_ENTRY( e_font ), cfg->fontname );
	gtk_entry_set_text( GTK_ENTRY( cpd->e_incpath ), cfg->incpath );
	gtk_entry_set_text( GTK_ENTRY( cpd->e_ccopt ), cfg->ccopt );
	gtk_entry_set_text( GTK_ENTRY( cpd->e_libpath ), cfg->libpath );
	gtk_entry_set_text( GTK_ENTRY( cpd->e_ldopt ), cfg->ldopt );
	gtk_entry_set_text( GTK_ENTRY( e_bash ), cfg->bash );
	gtk_entry_set_text( GTK_ENTRY( e_xterm ), cfg->xterm );
#ifdef HAVE_GTKTEXT_PATCH
	if( cfg->edtab )
		gtk_widget_activate( cb_edtab );
#endif
	/*gtk_entry_set_text( GTK_ENTRY( e_ld ), cfg->ld );*/
	gtk_entry_set_text( GTK_ENTRY( e_db ), cfg->db );
	gtk_entry_set_text( GTK_ENTRY( e_man ), cfg->man );
	gtk_entry_set_text( GTK_ENTRY( e_smtp ), cfg->smtp );
	gtk_entry_set_text( GTK_ENTRY( e_email ), cfg->email );

	if( cfg->sor )
		gtk_widget_activate( cb_sor );

	if( cset )
	{
		gtk_entry_set_text( GTK_ENTRY( cpd->e_fpat ), cset->fpat );
		gtk_entry_set_text( GTK_ENTRY( cpd->e_compiler ), cset->compiler );
		gtk_entry_set_text( GTK_ENTRY( cpd->e_linker ), cset->linker );
		gtk_entry_set_text( GTK_ENTRY( cpd->e_ccopt ), cset->ccopt );
		gtk_entry_set_text( GTK_ENTRY( cpd->e_ldopt ), cset->ldopt );
		gtk_entry_set_text( GTK_ENTRY( cpd->e_incpath ), cset->incpath );
		gtk_entry_set_text( GTK_ENTRY( cpd->e_libpath ), cset->libpath );
		gtk_entry_set_text( GTK_ENTRY( cpd->e_ccmdline_exec ), cset->c_cmdline_exec );
		gtk_entry_set_text( GTK_ENTRY( cpd->e_ccmdline_obj ), cset->c_cmdline_obj );
		gtk_entry_set_text( GTK_ENTRY( cpd->e_lcmdline ), cset->l_cmdline );
	}

	gtk_widget_show( prefs_window );
}


/*
 ---------------------------------------------------------------------
     Function: set_to_defaults()
     Desc: Callback-Function /Preferences/Set to Defaults
 ---------------------------------------------------------------------
*/

void set_to_defaults( GtkWidget *widget, gpointer data )
{
	set_cfg_defaults();
	update_window( main_window );
}


/*
 ---------------------------------------------------------------------
     Function: reload_config()
     Desc: Callback-Function /Preferences/Reload Config
 ---------------------------------------------------------------------
*/

void reload_config( GtkWidget *widget, gpointer data )
{
#ifdef HAVE_LIBGUILE
	gh_eval_file_with_standard_handler ( cfg->cfgfile );
#else
	gI_cf_parse( cfg->cfgfile );
#endif
	update_window( main_window );
}


gI_comp_dialog *gI_comp_dialog_new()
{
	gI_comp_dialog *cpd;
	GtkWidget *label;
	GtkWidget *frame;
	GtkWidget *_vbox, *hbox;

	cpd = (gI_comp_dialog *) g_malloc0( sizeof( gI_comp_dialog ) );

	cpd->vbox = gtk_vbox_new( FALSE, 0 );
	gtk_widget_show( cpd->vbox );

	hbox = gtk_hbox_new( FALSE, 0 );
	gtk_box_pack_start( GTK_BOX( cpd->vbox ), hbox, FALSE, TRUE, 7 );
	gtk_widget_show( hbox );

	label = gtk_label_new( _("Compile-Set") );
	gtk_box_pack_start( GTK_BOX( hbox ), label, FALSE, TRUE, 10 );
	gtk_widget_show( label );

	cpd->combo = gtk_combo_new();
	gtk_box_pack_start( GTK_BOX( hbox ), cpd->combo, FALSE, TRUE, 7 );
	gtk_widget_show( cpd->combo );

	hbox = gtk_hbox_new( FALSE, 0 );
	gtk_box_pack_start( GTK_BOX( cpd->vbox ), hbox, FALSE, TRUE, 5 );
	gtk_widget_show( hbox );

	label = gtk_label_new( _("File Pattern") );
	gtk_box_pack_start( GTK_BOX( hbox ), label, FALSE, TRUE, 10 );
	gtk_widget_show( label );

	cpd->e_fpat = gtk_entry_new_with_max_length( 255 );
	gtk_box_pack_start( GTK_BOX( hbox ), cpd->e_fpat, FALSE, TRUE, 5 );
	gtk_widget_show( cpd->e_fpat );


	frame = gtk_frame_new( _("Programs") );
	gtk_box_pack_start( GTK_BOX( cpd->vbox ), frame, FALSE, TRUE, 5 );
	gtk_widget_show( frame );

	_vbox = gtk_vbox_new( FALSE, 0 );
	gtk_container_add( GTK_CONTAINER( frame ), _vbox );
	gtk_widget_show( _vbox );

	hbox = gtk_hbox_new( FALSE, 0 );
	gtk_box_pack_start( GTK_BOX( _vbox ), hbox, FALSE, TRUE, 5 );
	gtk_widget_show( hbox );

	label = gtk_label_new( _("Compiler") );
	gtk_box_pack_start( GTK_BOX( hbox ), label, FALSE, TRUE, 5 );
	gtk_widget_show( label );

	cpd->e_compiler = gtk_entry_new_with_max_length( 255 );
	gtk_box_pack_start( GTK_BOX( hbox ), cpd->e_compiler, TRUE, TRUE, 5 );
	gtk_widget_show( cpd->e_compiler );

	hbox = gtk_hbox_new( FALSE, 0 );
	gtk_box_pack_start( GTK_BOX( _vbox ), hbox, FALSE, TRUE, 5 );
	gtk_widget_show( hbox );

	label = gtk_label_new( _("Linker ") );
	gtk_box_pack_start( GTK_BOX( hbox ), label, FALSE, TRUE, 5 );
	gtk_widget_show( label );

	cpd->e_linker = gtk_entry_new_with_max_length( 255 );
	gtk_box_pack_start( GTK_BOX( hbox ), cpd->e_linker, TRUE, TRUE, 5 );
	gtk_widget_show( cpd->e_linker );

	/***
	    hbox = gtk_hbox_new( FALSE, 0 );
	    gtk_box_pack_start( GTK_BOX( _vbox ), hbox, FALSE, TRUE, 5 );
	    gtk_widget_show( hbox );

	    label = gtk_label_new( "Make  " );
	    gtk_box_pack_start( GTK_BOX( hbox ), label, FALSE, TRUE, 5 );
	    gtk_widget_show( label );

	    cpd->e_make = gtk_entry_new_with_max_length( 255 );
	    gtk_box_pack_start( GTK_BOX( hbox ), cpd->e_make, TRUE, TRUE, 5 );
	    gtk_widget_show( cpd->e_make );
	***/

	frame = gtk_frame_new( _("Compile - Parameters") );
	gtk_box_pack_start( GTK_BOX( cpd->vbox ), frame, FALSE, TRUE, 5 );
	gtk_widget_show( frame );

	_vbox = gtk_vbox_new( FALSE, 0 );
	gtk_container_add( GTK_CONTAINER( frame ), _vbox );
	gtk_widget_show( _vbox );

	hbox = gtk_hbox_new( FALSE, 0 );
	gtk_box_pack_start( GTK_BOX( _vbox ), hbox, FALSE, TRUE, 5 );
	gtk_widget_show( hbox );

	label = gtk_label_new( _("Include-Paths") );
	gtk_box_pack_start( GTK_BOX( hbox ), label, FALSE, TRUE, 5 );
	gtk_widget_show( label );

	cpd->e_incpath = gtk_entry_new_with_max_length( 255 );
	gtk_box_pack_start( GTK_BOX( hbox ), cpd->e_incpath, TRUE, TRUE, 5 );
	gtk_widget_show( cpd->e_incpath );

	hbox = gtk_hbox_new( FALSE, 0 );
	gtk_box_pack_start( GTK_BOX( _vbox ), hbox, FALSE, TRUE, 5 );
	gtk_widget_show( hbox );

	label = gtk_label_new( _("Options         ") );
	gtk_box_pack_start( GTK_BOX( hbox ), label, FALSE, TRUE, 5 );
	gtk_widget_show( label );

	cpd->e_ccopt = gtk_entry_new_with_max_length( 255 );
	gtk_box_pack_start( GTK_BOX( hbox ), cpd->e_ccopt, TRUE, TRUE, 5 );
	gtk_widget_show( cpd->e_ccopt );

	frame = gtk_frame_new( _("Link - Parameters") );
	gtk_box_pack_start( GTK_BOX( cpd->vbox ), frame, FALSE, TRUE, 5 );
	gtk_widget_show( frame );

	_vbox = gtk_vbox_new( FALSE, 0 );
	gtk_container_add( GTK_CONTAINER( frame ), _vbox );
	gtk_widget_show( _vbox );

	hbox = gtk_hbox_new( FALSE, 0 );
	gtk_box_pack_start( GTK_BOX( _vbox ), hbox, FALSE, TRUE, 5 );
	gtk_widget_show( hbox );

	label = gtk_label_new( _("Library-Paths ") );
	gtk_box_pack_start( GTK_BOX( hbox ), label, FALSE, TRUE, 5 );
	gtk_widget_show( label );

	cpd->e_libpath = gtk_entry_new_with_max_length( 255 );
	gtk_box_pack_start( GTK_BOX( hbox ), cpd->e_libpath, TRUE, TRUE, 5 );
	gtk_widget_show( cpd->e_libpath );

	hbox = gtk_hbox_new( FALSE, 0 );
	gtk_box_pack_start( GTK_BOX( _vbox ), hbox, FALSE, TRUE, 5 );
	gtk_widget_show( hbox );

	label = gtk_label_new( _("Options          ") );
	gtk_box_pack_start( GTK_BOX( hbox ), label, FALSE, TRUE, 5 );
	gtk_widget_show( label );

	cpd->e_ldopt = gtk_entry_new_with_max_length( 255 );
	gtk_box_pack_start( GTK_BOX( hbox ), cpd->e_ldopt, TRUE, TRUE, 5 );
	gtk_widget_show( cpd->e_ldopt );

	frame = gtk_frame_new( _("Command - Lines") );
	gtk_box_pack_start( GTK_BOX( cpd->vbox ), frame, FALSE, TRUE, 5 );
	gtk_widget_show( frame );

	_vbox = gtk_vbox_new( FALSE, 0 );
	gtk_container_add( GTK_CONTAINER( frame ), _vbox );
	gtk_widget_show( _vbox );

	hbox = gtk_hbox_new( FALSE, 0 );
	gtk_box_pack_start( GTK_BOX( _vbox ), hbox, FALSE, TRUE, 5 );
	gtk_widget_show( hbox );

	label = gtk_label_new( _("Compile (EXEC)") );
	gtk_box_pack_start( GTK_BOX( hbox ), label, FALSE, TRUE, 5 );
	gtk_widget_show( label );

	cpd->e_ccmdline_exec = gtk_entry_new_with_max_length( 255 );
	gtk_box_pack_start( GTK_BOX( hbox ), cpd->e_ccmdline_exec, TRUE, TRUE, 5 );
	gtk_widget_show( cpd->e_ccmdline_exec );

	hbox = gtk_hbox_new( FALSE, 0 );
	gtk_box_pack_start( GTK_BOX( _vbox ), hbox, FALSE, TRUE, 5 );
	gtk_widget_show( hbox );

	label = gtk_label_new( _("Compile (OBJ)") );
	gtk_box_pack_start( GTK_BOX( hbox ), label, FALSE, TRUE, 5 );
	gtk_widget_show( label );

	cpd->e_ccmdline_obj = gtk_entry_new_with_max_length( 255 );
	gtk_box_pack_start( GTK_BOX( hbox ), cpd->e_ccmdline_obj, TRUE, TRUE, 5 );
	gtk_widget_show( cpd->e_ccmdline_obj );

	hbox = gtk_hbox_new( FALSE, 0 );
	gtk_box_pack_start( GTK_BOX( _vbox ), hbox, FALSE, TRUE, 5 );
	gtk_widget_show( hbox );

	label = gtk_label_new( _("Link") );
	gtk_box_pack_start( GTK_BOX( hbox ), label, FALSE, TRUE, 5 );
	gtk_widget_show( label );

	cpd->e_lcmdline = gtk_entry_new_with_max_length( 255 );
	gtk_box_pack_start( GTK_BOX( hbox ), cpd->e_lcmdline, TRUE, TRUE, 5 );
	gtk_widget_show( cpd->e_lcmdline );



	return( cpd );
}


static void compile_set_changed( GtkWidget *widget, gI_comp_dialog *cpd )
{
	gchar *cset;
	gI_comp_set *comp_set;

	cset = gtk_entry_get_text( GTK_ENTRY( GTK_COMBO( cpd->combo )->entry ) );
	if( isempty( cset ) )
	{
		/* clear fields */
		gtk_entry_set_text( GTK_ENTRY( cpd->e_fpat ), "" );
		gtk_entry_set_text( GTK_ENTRY( cpd->e_compiler ), "" );
		gtk_entry_set_text( GTK_ENTRY( cpd->e_linker ), "" );
		gtk_entry_set_text( GTK_ENTRY( cpd->e_incpath ), "" );
		gtk_entry_set_text( GTK_ENTRY( cpd->e_libpath ), "" );
		gtk_entry_set_text( GTK_ENTRY( cpd->e_ccopt ), "" );
		gtk_entry_set_text( GTK_ENTRY( cpd->e_ldopt ), "" );
		gtk_entry_set_text( GTK_ENTRY( cpd->e_ccmdline_exec ), "" );
		gtk_entry_set_text( GTK_ENTRY( cpd->e_ccmdline_obj ), "" );
		gtk_entry_set_text( GTK_ENTRY( cpd->e_lcmdline ), "" );
		return;
	}

	comp_set = gI_comp_set_get( cset );
	if( !comp_set )
	{
		/* clear fields */
		gtk_entry_set_text( GTK_ENTRY( cpd->e_fpat ), "" );
		gtk_entry_set_text( GTK_ENTRY( cpd->e_compiler ), "" );
		gtk_entry_set_text( GTK_ENTRY( cpd->e_linker ), "" );
		gtk_entry_set_text( GTK_ENTRY( cpd->e_incpath ), "" );
		gtk_entry_set_text( GTK_ENTRY( cpd->e_libpath ), "" );
		gtk_entry_set_text( GTK_ENTRY( cpd->e_ccopt ), "" );
		gtk_entry_set_text( GTK_ENTRY( cpd->e_ldopt ), "" );
		gtk_entry_set_text( GTK_ENTRY( cpd->e_ccmdline_exec ), "" );
		gtk_entry_set_text( GTK_ENTRY( cpd->e_ccmdline_obj ), "" );
		gtk_entry_set_text( GTK_ENTRY( cpd->e_lcmdline ), "" );

		return;
	}
	else
	{
		/* fill fields */
		gtk_entry_set_text( GTK_ENTRY( cpd->e_fpat ), comp_set->fpat );
		gtk_entry_set_text( GTK_ENTRY( cpd->e_compiler ), comp_set->compiler );
		gtk_entry_set_text( GTK_ENTRY( cpd->e_linker ), comp_set->linker );
		gtk_entry_set_text( GTK_ENTRY( cpd->e_incpath ), comp_set->incpath );
		gtk_entry_set_text( GTK_ENTRY( cpd->e_libpath ), comp_set->libpath );
		gtk_entry_set_text( GTK_ENTRY( cpd->e_ccopt ), comp_set->ccopt );
		gtk_entry_set_text( GTK_ENTRY( cpd->e_ldopt ), comp_set->ldopt );
		gtk_entry_set_text( GTK_ENTRY( cpd->e_ccmdline_exec ), comp_set->c_cmdline_exec );
		gtk_entry_set_text( GTK_ENTRY( cpd->e_ccmdline_obj ), comp_set->c_cmdline_obj );
		gtk_entry_set_text( GTK_ENTRY( cpd->e_lcmdline ), comp_set->l_cmdline );

		return;
	}
}


static void add_compile_sets( gI_comp_dialog *cpd )
{
	GList *tmp = NULL, *tmp2 = NULL;
	gI_comp_set *cset;

	if( cpd && cfg->csets )
	{
		tmp = cfg->csets;
		tmp = g_list_first( tmp );

		while( tmp != NULL )
		{
			cset = (gI_comp_set *) tmp->data;
			if( cset != NULL )
			{
				if( cset->cset != NULL )
				{
					tmp2 = g_list_append( tmp2, cset->cset );
				}
			}
			tmp = tmp->next;
		}

		if( tmp2 != NULL )
		{
			tmp2 = g_list_append( tmp2, "" );
			tmp2 = g_list_first( tmp2 );
			gtk_combo_set_popdown_strings( GTK_COMBO( cpd->combo ), tmp2 );
			g_list_free( tmp2 );
		}
	}
}


static glong compile_set_exist( gchar *cset )
{
	GList *tmp;
	gI_comp_set *comp_set;

	tmp = cfg->csets;

	while( tmp != NULL )
	{
		comp_set = (gI_comp_set *) tmp->data;
		if( comp_set )
		{
			if( !strcmp( comp_set->cset, cset ) )
			{
				return( 1 );
			}
		}
		tmp = tmp->next;
	}

	return( 0 );
}


gI_comp_set *gI_comp_set_get( gchar *cset )
{
	GList *tmp;
	gI_comp_set *comp_set;

	tmp = cfg->csets;

	while( tmp != NULL )
	{
		comp_set = (gI_comp_set *) tmp->data;
		if( comp_set )
		{
			if( !strcmp( comp_set->cset, cset ) )
			{
				return( comp_set );
			}
		}
		tmp = tmp->next;
	}

	return( NULL );
}


static glong save_compile_sets( gchar *cset_file )
{
	GList *tmp;
	FILE *f_cset;
	gI_comp_set *comp_set;
	gchar buf[STRLEN];
	gchar *fnwp;

	fnwp = g_strconcat( gide_path, "/", cset_file, NULL );
	f_cset = fopen( fnwp, "w" );
	if( !f_cset )
	{
		g_free( fnwp );
		return( 0 );
	}
	g_free( fnwp );

	fprintf( f_cset, "# gIDE %s - Compile Sets Configuration File - DON'T CHANGE THIS FILE\n#\n", VERSION );

	tmp = cfg->csets;

	while( tmp != NULL )
	{
		comp_set = (gI_comp_set *) tmp->data;
		if( comp_set )
		{
			sprintf( buf, "0%s\n", comp_set->cset );
			fputs( buf, f_cset );
			sprintf( buf, "1%s\n", comp_set->fpat );
			fputs( buf, f_cset );
			sprintf( buf, "2%s\n", comp_set->compiler );
			fputs( buf, f_cset );
			sprintf( buf, "3%s\n", comp_set->linker );
			fputs( buf, f_cset );
			/***
						sprintf( buf, "4%s\n", comp_set->make );
						fputs( buf, f_cset );
			***/
			sprintf( buf, "5%s\n", comp_set->incpath );
			fputs( buf, f_cset );
			sprintf( buf, "6%s\n", comp_set->ccopt );
			fputs( buf, f_cset );
			sprintf( buf, "7%s\n", comp_set->libpath );
			fputs( buf, f_cset );
			sprintf( buf, "8%s\n", comp_set->ldopt );
			fputs( buf, f_cset );
			sprintf( buf, "9%s\n", comp_set->c_cmdline_exec );
			fputs( buf, f_cset );
			sprintf( buf, "A%s\n", comp_set->c_cmdline_obj );
			fputs( buf, f_cset );
			sprintf( buf, "B%s\n", comp_set->l_cmdline );
			fputs( buf, f_cset );
		}

		tmp = tmp->next;
	}

	fclose( f_cset );

	return( 1 );
}


static void add_compile_set( gI_comp_dialog *cpd )
{
	gchar *ptr, *sptr;
	gI_comp_set *cset;

	cset = (gI_comp_set *) g_malloc0( sizeof( gI_comp_set ) );

	ptr = gtk_entry_get_text( GTK_ENTRY( GTK_COMBO( cpd->combo )->entry ) );
	sptr = strchr( ptr, '\n' );
	if( sptr )
		*sptr = '\0';
	cset->cset = g_strdup( ptr );

	ptr = gtk_entry_get_text( GTK_ENTRY( cpd->e_fpat ) );
	sptr = strchr( ptr, '\n' );
	if( sptr )
		*sptr = '\0';
	cset->fpat = g_strdup( ptr );

	ptr = gtk_entry_get_text( GTK_ENTRY( cpd->e_compiler ) );
	sptr = strchr( ptr, '\n' );
	if( sptr )
		*sptr = '\0';
	cset->compiler = g_strdup( ptr );

	ptr = gtk_entry_get_text( GTK_ENTRY( cpd->e_linker ) );
	sptr = strchr( ptr, '\n' );
	if( sptr )
		*sptr = '\0';
	cset->linker = g_strdup( ptr );

	/***
		ptr = gtk_entry_get_text( GTK_ENTRY( cpd->e_make ) ); 
		sptr = strchr( ptr, '\n' );
		if( sptr )
			*sptr = '\0';
		cset->make = g_strdup( ptr );	
	***/

	ptr = gtk_entry_get_text( GTK_ENTRY( cpd->e_incpath ) );
	sptr = strchr( ptr, '\n' );
	if( sptr )
		*sptr = '\0';
	cset->incpath = g_strdup( ptr );

	ptr = gtk_entry_get_text( GTK_ENTRY( cpd->e_ccopt ) );
	sptr = strchr( ptr, '\n' );
	if( sptr )
		*sptr = '\0';
	cset->ccopt = g_strdup( ptr );

	ptr = gtk_entry_get_text( GTK_ENTRY( cpd->e_libpath ) );
	sptr = strchr( ptr, '\n' );
	if( sptr )
		*sptr = '\0';
	cset->libpath = g_strdup( ptr );

	ptr = gtk_entry_get_text( GTK_ENTRY( cpd->e_ldopt ) );
	sptr = strchr( ptr, '\n' );
	if( sptr )
		*sptr = '\0';
	cset->ldopt = g_strdup( ptr );

	ptr = gtk_entry_get_text( GTK_ENTRY( cpd->e_ccmdline_exec ) );
	sptr = strchr( ptr, '\n' );
	if( sptr )
		*sptr = '\0';
	cset->c_cmdline_exec = g_strdup( ptr );

	ptr = gtk_entry_get_text( GTK_ENTRY( cpd->e_ccmdline_obj ) );
	sptr = strchr( ptr, '\n' );
	if( sptr )
		*sptr = '\0';
	cset->c_cmdline_obj = g_strdup( ptr );

	ptr = gtk_entry_get_text( GTK_ENTRY( cpd->e_lcmdline ) );
	sptr = strchr( ptr, '\n' );
	if( sptr )
		*sptr = '\0';
	cset->l_cmdline = g_strdup( ptr );

	if( !cfg->csets )
		cfg->csets = g_list_alloc();

	g_list_append( cfg->csets, (gpointer) cset );
}


static void update_compile_set( gchar *name, gI_comp_dialog *cpd )
{
	gI_comp_set *cset;
	gchar *ptr, *sptr;

	if( !name || isempty( name ) )
		return;

	if( !cpd )
		return;

	cset = gI_comp_set_get( name );
	if( !cset )
		return;

	/* free memory */
	if( cset->fpat )
		g_free( cset->fpat );
	if( cset->compiler )
		g_free( cset->compiler );
	if( cset->linker )
		g_free( cset->linker );
	/***
		if( cset->make )
			g_free( cset->make );
	***/
	if( cset->ccopt )
		g_free( cset->ccopt );
	if( cset->incpath )
		g_free( cset->incpath );
	if( cset->ldopt )
		g_free( cset->ldopt );
	if( cset->libpath )
		g_free( cset->libpath );
	if( cset->c_cmdline_exec )
		g_free( cset->c_cmdline_exec );
	if( cset->c_cmdline_obj )
		g_free( cset->c_cmdline_obj );
	if( cset->l_cmdline )
		g_free( cset->l_cmdline );


	ptr = gtk_entry_get_text( GTK_ENTRY( cpd->e_fpat ) );
	sptr = strchr( ptr, '\n' );
	if( sptr )
		*sptr = '\0';
	cset->fpat = g_strdup( ptr );

	ptr = gtk_entry_get_text( GTK_ENTRY( cpd->e_compiler ) );
	sptr = strchr( ptr, '\n' );
	if( sptr )
		*sptr = '\0';
	cset->compiler = g_strdup( ptr );

	ptr = gtk_entry_get_text( GTK_ENTRY( cpd->e_linker ) );
	sptr = strchr( ptr, '\n' );
	if( sptr )
		*sptr = '\0';
	cset->linker = g_strdup( ptr );

	/***
		ptr = gtk_entry_get_text( GTK_ENTRY( cpd->e_make ) ); 
		sptr = strchr( ptr, '\n' );
		if( sptr )
			*sptr = '\0';
		cset->make = g_strdup( ptr );	
	***/

	ptr = gtk_entry_get_text( GTK_ENTRY( cpd->e_incpath ) );
	sptr = strchr( ptr, '\n' );
	if( sptr )
		*sptr = '\0';
	cset->incpath = g_strdup( ptr );

	ptr = gtk_entry_get_text( GTK_ENTRY( cpd->e_ccopt ) );
	sptr = strchr( ptr, '\n' );
	if( sptr )
		*sptr = '\0';
	cset->ccopt = g_strdup( ptr );

	ptr = gtk_entry_get_text( GTK_ENTRY( cpd->e_libpath ) );
	sptr = strchr( ptr, '\n' );
	if( sptr )
		*sptr = '\0';
	cset->libpath = g_strdup( ptr );

	ptr = gtk_entry_get_text( GTK_ENTRY( cpd->e_ldopt ) );
	sptr = strchr( ptr, '\n' );
	if( sptr )
		*sptr = '\0';
	cset->ldopt = g_strdup( ptr );

	ptr = gtk_entry_get_text( GTK_ENTRY( cpd->e_ccmdline_exec ) );
	sptr = strchr( ptr, '\n' );
	if( sptr )
		*sptr = '\0';
	cset->c_cmdline_exec = g_strdup( ptr );

	ptr = gtk_entry_get_text( GTK_ENTRY( cpd->e_ccmdline_obj ) );
	sptr = strchr( ptr, '\n' );
	if( sptr )
		*sptr = '\0';
	cset->c_cmdline_obj = g_strdup( ptr );

	ptr = gtk_entry_get_text( GTK_ENTRY( cpd->e_lcmdline ) );
	sptr = strchr( ptr, '\n' );
	if( sptr )
		*sptr = '\0';
	cset->l_cmdline = g_strdup( ptr );

	if( !cfg->csets )
		cfg->csets = g_list_alloc();
}


