/* $Header: /cvs/gnome/gIDE/src/gI_project.h,v 1.2 1999/11/06 17:45:39 jpr Exp $ */
/* gIDE
 * Copyright (C) 1998-2000 Steffen Kern
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef GI_PROJECT_H
#define GI_PROJECT_H

#include <gtk/gtk.h>

#ifndef OLD_TODO_LIST
typedef struct _gI_project gI_project;
typedef struct _gI_target gI_target;

typedef struct _gI_TodoItem gI_TodoItem;
typedef struct _gI_TodoList gI_TodoList;
typedef struct _gI_TodoPane gI_TodoPane;

/* Forward declarations...  These are with their respective functions */
struct _gI_TodoItem;
struct _gI_TodoList;
struct _gI_TodoPane;

struct _gI_project
{
    gchar *filename;

    gchar *name;
    gchar *version;
    gchar *changelog;
    gchar *mtarget;
	gchar *prjroot;
	gchar *prjfdir;

    gint targets_no;
    gI_target *targets[MAX_PROJECT_TARGETS];

    gint libs_no;
    gchar *libs[MAX_PROJECT_FILES];

    gchar *cpar;
    gchar *cinc;

    gchar *lpar;
    gchar *llib;

    gI_TodoList *todoList;
    gI_TodoPane *todoPane;
};

struct _gI_target
{
    gchar *name;

    gint sources_no;
    gchar *sources[MAX_PROJECT_FILES];
        gint build[MAX_PROJECT_FILES];
};

#endif

/*
 * Prototypes for 'gI_project.c'
 */
gI_project *gI_project_get_current();
void project_new( GtkWidget *widget, gpointer data );
void project_open( GtkWidget *widget, gpointer data );
void project_delete( GtkWidget *widget, gpointer data );
void project_close( GtkWidget *widget, gpointer data );
void project_edit( GtkWidget *widget, gpointer data );
void _close_all_files( gI_window *window );
void close_all_files( GtkWidget *widget, gpointer data );
void close_project_files( gI_project *project );
void project_open_file( GtkWidget *widget, gpointer data );
void create_makefile( GtkWidget *widget, gpointer data );
void project_files_tree( GtkWidget *container, gI_project *project );
long cw_vis( gI_document *doc );
void build_project( GtkWidget *widget, gpointer data );
gchar *move_to_tmp( gchar *filename );
long append_file( gchar *filea, gchar *fileb );

#define NOT_YET_SUPPORTED "Not Yet Supported!"

#define SOURCE "Source"
#define TARGET "Target"
    
#define N_TODO_TODO 1
#define N_TODO_WORK 2
#define N_TODO_DONE 3

#define YES "Yes"
#define NO "No"

/*********************************
 *
 *  TODO ITEM 
 *
 *
 *********************************/

#if 1
typedef enum { TODO_CANCELLED, 
	       TODO_TODO, 
	       TODO_INPROGRESS, 
	       TODO_DONE,
	       TODO_CLOSED,
	       LAST_TODO } gI_TodoStatus;

struct _gI_TodoItem {
    /* Todo item name and status */
    gchar *item;

    gI_TodoStatus todo_status;
    const gchar *status;
    
    /* Time stamps */
    gchar *openedTime;
    gchar *modifiedTime;
    gchar *closedTime;
    gchar *dueDate;
    
    /* Who is working on this? */
    gchar *assignedTo;
    gboolean seen; /* Do they know they're working on this? */
    
    /* Comments */
    GList *comments;
};

struct _gI_TodoList {
    GList *todoPanes;

    GList *todoItems;

    gI_TodoItem *changedItem;
};

#endif

/* Todo Item functions */

gI_TodoItem *
gI_todo_item_create(gchar *item, gchar *time);

void
gI_todo_item_destroy(gI_TodoItem *todo);

void
gI_todo_item_increment(gI_TodoItem *todo);

void
gI_todo_item_decrement(gI_TodoItem *todo);

void
gI_todo_item_close(gI_TodoItem *todo);

void
gI_todo_item_assign(gI_TodoItem *todo,
                    gchar       *who);
void
gI_todo_item_add_comment(gI_TodoItem *todo,
			 gchar *comment);

/* Todo Item List functions */

gI_TodoList *
gI_todo_list_create(void);

void
gI_todo_list_destroy(gI_TodoList *tlist);


void
gI_todo_list_attach(gI_TodoList *tlist,
                    gI_TodoPane *tpane);
void
gI_todo_list_detach(gI_TodoList *tlist,
                    gI_TodoPane *tpane);
inline void
gI_todo_list_add(gI_TodoList *tlist,
                 gI_TodoItem *todo);
inline void
gI_todo_list_remove(gI_TodoList *tlist,
                    gI_TodoItem *todo);
gboolean
gI_todo_list_write_to_file(gI_TodoList *tlist,
                           FILE *file,
                           gchar *beginString,
                           gchar *endString);
gI_TodoList *
gI_todo_list_read_from_file(FILE *file,
                            gchar *endString);
void
gI_add_to_changelog(gchar *changelogEntry,
		    gchar *changelogFileName);




/************************************
 *
 *
 ************* TODO PANE
 *
 *
 **************************************/

#if 1
typedef struct _TodoPaneData TodoPaneData;

struct _TodoPaneData {
    gI_TodoItem *todo;

    GtkCTreeNode *top;
    GtkCTreeNode *createDate;
    GtkCTreeNode *modifiedDate;
    GtkCTreeNode *closedDate;
    GtkCTreeNode *dueDate;

    GtkCTreeNode *commentsRoot;
    GList *commentsNodes;
};

struct _gI_TodoPane {

    gI_TodoList *tlist;

    TodoPaneData *editingData;
        
    GtkWidget *vbox;
    GtkWidget *listFrame;
       GtkWidget *ctree;
    GtkWidget *buttonHBox;
       GtkWidget *listEditFrame;
          GtkWidget *listEditVBox;
             GtkWidget *listEditNew;
             GtkWidget *listEditEdit;
             GtkWidget *listEditDelete;
       GtkWidget *itemEditFrame;
          GtkWidget *itemEditVBox;
             GtkWidget *itemEditIncrement;
             GtkWidget *itemEditDecrement;
             GtkWidget *itemEditClose;
       GtkWidget *miscFrame;
          GtkWidget *miscEditVBox;
             GtkWidget *miscAddComment;
             GtkWidget *miscRemoveComment;
             GtkWidget *miscAssign;
       GtkWidget *editArea;
          GtkWidget *newItemFrame;
             GtkWidget *newItemVBox;
                GtkWidget *itemNameEntry;
                GtkWidget *itemAssignedEntry;
                GtkWidget *itemAdd;
                GtkWidget *itemCancel;
          GtkWidget *commentFrame;
             GtkWidget *commentVBox;
                GtkWidget *commentText;
                GtkWidget *commentAdd;
                GtkWidget *commentCancel;
};

#endif

gI_TodoPane *
gI_todo_pane_create(void);

gI_TodoPane *
gI_todo_pane_create_from_todo(gI_TodoList *tlist);

void
gI_todo_pane_destroy(gI_TodoPane *tpane);


#endif /* PROJECT */



