/* $Header: /cvs/gnome/gIDE/src/gI_tools.h,v 1.2 1999/11/06 17:45:39 jpr Exp $ */
/* gIDE
 * Copyright (C) 1998-2000 Steffen Kern
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef GI_TOOLS_H
#define GI_TOOLS_H

#include <gtk/gtk.h>

/*
 * Prototypes for 'gI_tools.c'
 */
glong c_parse_line( gchar *buf, glong line );
void gen_proto( GtkWidget *widget, gpointer data );
gI_tool *gI_tool_new();
void gI_tool_init( gI_tool *tool );
void gI_tool_lookup( gchar *toolname );
void menu_add_tool( gI_window *window, gI_tool *tool );
void menu_remove_tool( gchar *menu_item_name );
void rem_return( gchar *str );
void add_all_tools( gI_window *window );
void custom_tools( GtkWidget *widget, gpointer data );
void tools_ascii_table( GtkWidget *widget, gpointer data );
void tools_calculator( GtkWidget *widget, gpointer data );

#define TOOL_OUTPUT_NEW 1
#define TOOL_OUTPUT_APPEND 2
#define TOOL_OUTPUT_BOX 3
#define TOOL_OUTPUT_IGNORE 4
#define TOOL_OUTPUT_INSERT 5
#define TOOL_OUTPUT_XTERM 6
#define TOOL_OUTPUT_PIPE 7

void tools_diff( GtkWidget *widget, gpointer data );
gint diff_files( gchar *file1, gchar *file2 );
gint diff_files_if( gchar *file1, gchar *file2 );
void tools_word_count( GtkWidget *widget, gpointer data );

#endif

