------------------------------------------------------------------------------
--                                                                          --
--                 GNU ADA RUN-TIME LIBRARY (GNARL) COMPONENTS              --
--                                                                          --
--                        S Y S T E M . V X W O R K S                       --
--                                                                          --
--                                   S p e c                                --
--                                                                          --
--                             $Revision: 1.1 $                             --
--                                                                          --
--               Copyright (C) 1998 Free Software Foundation                --
--                                                                          --
-- GNARL is free software; you can  redistribute it  and/or modify it under --
-- terms of the  GNU General Public License as published  by the Free Soft- --
-- ware  Foundation;  either version 2,  or (at your option) any later ver- --
-- sion. GNARL is distributed in the hope that it will be useful, but WITH- --
-- OUT ANY WARRANTY;  without even the  implied warranty of MERCHANTABILITY --
-- or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License --
-- for  more details.  You should have  received  a copy of the GNU General --
-- Public License  distributed with GNARL; see file COPYING.  If not, write --
-- to  the Free Software Foundation,  59 Temple Place - Suite 330,  Boston, --
-- MA 02111-1307, USA.                                                      --
--                                                                          --
-- As a special exception,  if other files  instantiate  generics from this --
-- unit, or you link  this unit with other files  to produce an executable, --
-- this  unit  does not  by itself cause  the resulting  executable  to  be --
-- covered  by the  GNU  General  Public  License.  This exception does not --
-- however invalidate  any other reasons why  the executable file  might be --
-- covered by the  GNU Public License.                                      --
--                                                                          --
-- GNARL was developed by the GNARL team at Florida State University. It is --
-- now maintained by Ada Core Technologies Inc. in cooperation with Florida --
-- State University (http://www.gnat.com).                                  --
--                                                                          --
------------------------------------------------------------------------------

--  This is the Alpha VxWorks version of this package.

with Interfaces.C;

package System.VxWorks is
   pragma Preelaborate (System.VxWorks);

   package IC renames Interfaces.C;

   --  Define enough of a Wind Task Control Block in order to
   --  obtain the inherited priority.  When porting this to
   --  different versions of VxWorks (this is based on 5.3[.1]),
   --  be sure to look at the definition for WIND_TCB located
   --  in $WIND_BASE/target/h/taskLib.h

   type Wind_Fill_1 is array (0 .. 16#77#) of IC.unsigned_char;
   type Wind_Fill_2 is array (16#80# .. 16#1c7#) of IC.unsigned_char;
   type Wind_Fill_3 is array (16#1d8# .. 16#777#) of IC.unsigned_char;
 
   type Wind_TCB is record
      Fill_1          : Wind_Fill_1;  -- 0x00 - 0x77
      Priority        : IC.int;  -- 0x78 - 0x7b, current (inherited) priority
      Normal_Priority : IC.int;  -- 0x7c - 0x7f, base priority
      Fill_2          : Wind_Fill_2;  -- 0x80 - 0x1c7
      spare1          : Address;  -- 0x1c8 - 0x1cb
      spare2          : Address;  -- 0x1cc - 0x1cf
      spare3          : Address;  -- 0x1d0 - 0x1d3
      spare4          : Address;  -- 0x1d4 - 0x1d7
 
      --  Fill_3 is much smaller on the board runtime, but the larger size
      --  below keeps this record compatible with vxsim.
 
      Fill_3          : Wind_Fill_3;     -- 0x1d8 - 0x777
   end record;
   type Wind_TCB_Ptr is access Wind_TCB;

end System.VxWorks;
