#include <strstream.h>

#include "StatusbarTest.h"

StatusBarTest * StatusBarTest::theTest = 0;

StatusBarTest::StatusBarTest () :
  pushSomethingButton ( "push something" ),
  popButton ( "pop" ),
  stealButton ( "steal #4" ),
  dumpStackButton ( "dump stack" ),
  contextButton ( "contexts" ),
  statusbarCounter ( 1 )
{
  set_title ( "statusbar" );
  set_border_width ( 0 );

  actionArea . pack_end ( gtkStatusBar );
  connect_to_method ( gtkStatusBar.text_popped, this, &StatusBarTest::popped );
  actionArea . pack_end ( pushSomethingButton );
  connect_to_method ( pushSomethingButton.clicked, this, &StatusBarTest::push );
  actionArea . pack_end ( popButton );
  connect_to_method ( popButton.clicked, this, &StatusBarTest::pop );
  actionArea . pack_end ( stealButton );
  connect_to_method ( stealButton.clicked, this, &StatusBarTest::steal );
  actionArea . pack_end ( dumpStackButton );
  connect_to_method ( dumpStackButton.clicked, this, &StatusBarTest::dump_stack );
  actionArea . pack_end ( contextButton );
  connect_to_method ( contextButton.clicked, this, &StatusBarTest::contexts );
  packControlArea ();
  show_all ();
}

TestFixture* 
StatusBarTest::create () 
{
  if ( theTest == 0 ) 
    {
      theTest = new StatusBarTest ();
      return theTest;
    }
  return 0;
}

void
StatusBarTest::push () 
{
  strstream text;
  text << "something ";
  text << statusbarCounter++ << ends;
  gtkStatusBar.push ( 1, text . str () );
}

void
StatusBarTest::pop () 
{
  gtkStatusBar . pop ( 1 );
}

void
StatusBarTest::steal () 
{
  gtkStatusBar . remove_message ( 1, 4 );
}

void
StatusBarTest::popped ( guint, const char * ) 
{
  if ( gtkStatusBar . messages_begin () == gtkStatusBar . messages_end () )
    statusbarCounter = 1;
}

void
StatusBarTest::contexts () 
{
  string descriptions [] = 
  {
    "any context",
    "idle messages",
    "some text",
    "hit the mouse",
    "hit the mouse2"
  };

  int nDescriptions = sizeof ( descriptions ) / sizeof ( string );

  for ( int n = 0; n < nDescriptions; n++ ) 
      cout << "GtkStatusBar: context=\""
	   << descriptions[ n ]
	   << "\", context_id="
	   << gtkStatusBar . get_context_id ( descriptions [ n ] )
	   << endl;

}

void
StatusBarTest::dump_stack ()
{
  GSList * list;

  for ( Gtk_Statusbar::iterator iter = gtkStatusBar . messages_begin ();
       iter != gtkStatusBar . messages_end ();
       iter++ ) 
    {
      GtkStatusbarMsg * msg = *iter;

      cout << "context_id: "
	   <<  msg->context_id
	   << ", message_id: "
	   << msg->message_id
	   << ", status_text: \""
	   << msg->text
	   << "\""
	   << endl;
    }
}
