#include <iostream>
#include <gtk--.h>

// Gtk-- version of the "hello world" example from the gtk+ tutorial

Gtk_Main *mainwidget;

void destroy_handler()
{
  mainwidget->quit();
}


class HelloWorld : public Gtk_Window
{
  Gtk_Button m_button;

public:
  HelloWorld();
  
  // this is a callback function. the data arguments are ignored in this example..
  // More on callbacks below.
  void hello(gpointer data);
  
  // another callback
  int delete_event_handler(GdkEventAny *event, gpointer data);
  
};

HelloWorld::HelloWorld()
  : Gtk_Window(GTK_WINDOW_TOPLEVEL), // create a new window
    m_button("Hello World")   // creates a new button with the label "Hello World".
{

  // when the window is given the "delete_event" signal (this is given
  // by the window manager, usually by the 'close' option, or on the
  // titlebar), we ask it to call the delete_event () function
  // as defined above.  The data passed to the callback
  // function is NULL and is ignored in the callback function.
  connect_to_method(delete_event, this, &delete_event_handler,
		    static_cast<gpointer>(0));
  
  // here we connect the "destroy" event to a signal handler.  
  // This event occurs when we call gtk_widget_destroy() on the window,
  // or if we return 'FALSE' in the "delete_event" callback.
  connect_to_function(destroy, destroy_handler);

  // sets the border width of the window.
  set_border_width(10);
          
  // When the button receives the "clicked" signal, it will call the
  // hello() method passing it NULL as it's argument. The hello() method is
  // defined below.
  connect_to_method(m_button.clicked, this, &hello, static_cast<gpointer>(0));
  
  // This will cause the window to be destroyed by calling
  // gtk_widget_destroy(window) when "clicked".  Again, the destroy
  // signal could come from here, or the window manager.
  connect_to_signal(m_button.clicked, destroy);


  // this packs the button into the window (a gtk container).
  add(&m_button);

  // the final step is to display this newly created widget...
  m_button.show();
  
  // and the window
  show();

  // NOTE : These last two lines can be replaced by
  // show_all();

}

void HelloWorld::hello(gpointer data)
{
  cout << "Hello World" << endl;
}

int HelloWorld::delete_event_handler(GdkEventAny *event, gpointer data)
{
  cout << "delete event occured" << endl;

  // if you return FALSE in the "delete_event" signal handler,
  // GTK will emit the "destroy" signal.  Returning TRUE means
  // you don't want the window to be destroyed.
  // This is useful for popping up 'are you sure you want to quit ?'
  // type dialogs.

  // Change TRUE to FALSE and the main window will be destroyed with
  // a "delete_event".

  return true;
}
  
int main (int argc, char *argv[])
{
          
  // all GTK applications must have a gtk_main(). Control ends here
  // and waits for an event to occur (like a key press or mouse event).
  Gtk_Main myapp(&argc, &argv);
  mainwidget=&myapp;

  HelloWorld helloworld;

  myapp.run();
  return 0;
}
