#include <gtk--.h>

// Gtk-- version of the "progress bar" example from the gtk+ tutorial


class ProgressBar : public Gtk_Window
{
  bool m_pstat;
  
  Gtk_Button m_bReset, m_bCancel;
  Gtk_Label m_label;
  Gtk_ProgressBar m_pbar;
  Gtk_Table m_table;

  gint delete_event_impl(GdkEventAny*) { 
    Gtk_Main::instance()->quit(); return 0; 
  }
  
public:
  int progress();
  void progress_r() { m_pstat = false; }
  
  ProgressBar();
};

ProgressBar::ProgressBar() :
  m_pstat(true),
  m_bReset("Reset"), m_bCancel("Cancel"),
  m_label("Progress Bar Example"),
  m_table(3,2, true)
{
  set_border_width(10);
  add(&m_table);

  // You don't need attach_default(), Gtk_Table::attach() already has
  // default args
  m_table.attach(m_label, 0,2,0,1);
  m_table.attach(m_pbar,  0,2,0,2);

  // Set the timeout to handle automatic updating of the progress bar
  connect_to_method(Gtk_Main::timeout(50), this, &progress);

  connect_to_method(m_bReset.clicked, this, &progress_r);
  m_table.attach(m_bReset, 0,1,2,3);
  
  connect_to_method(m_bCancel.clicked, Gtk_Main::instance(), &Gtk_Main::quit);

  m_table.attach(m_bCancel, 1,2,2,3);

  show_all();
}

int
ProgressBar::progress()
{
  gfloat pvalue = m_pbar.get_current_percentage();

  pvalue += 0.01;

  if ((pvalue >= 1.0) || (m_pstat == false)) {
    pvalue = 0.0;
    m_pstat = true;
  }

  m_pbar.set_percentage(pvalue);

  return true;
}


int main (int argc, char *argv[])
{
          
  Gtk_Main myapp(&argc, &argv);

  ProgressBar progressbar;

  myapp.run();
  return 0;
}
