
#include "drawable.h"
#include "font.h"
#include "gc.h"
#include "image.h"
#include "pixmap.h"
#include "bitmap.h"

Gdk_Drawable::Gdk_Drawable ()
  :Gdk_Handle<GdkDrawable>(0) {}

Gdk_Drawable::Gdk_Drawable (GdkDrawable *drawable)
  :Gdk_Handle<GdkDrawable>(drawable) {}

Gdk_Drawable::Gdk_Drawable (const Gdk_Drawable &drawable)
  :Gdk_Handle<GdkDrawable>(drawable) {}

Gdk_Drawable::~Gdk_Drawable () {}

void Gdk_Drawable::ref() {}
void Gdk_Drawable::unref() {}


/****************************Methods*******************************/
void Gdk_Drawable::draw_point      (Gdk_GC       &gc,
                     gint          x1,
                     gint          y1)
  {
   gdk_draw_point(obj_,gc,x1,y1);
  }

void Gdk_Drawable::draw_line      (Gdk_GC       &gc,
                     gint          x1,
                     gint          y1,
                     gint          x2,
                     gint          y2)
  {
   gdk_draw_line(obj_,gc,x1,y1,x2,y2);
  }

void Gdk_Drawable::draw_rectangle (Gdk_GC       &gc,
                     gint          filled,
                     gint          x,
                     gint          y,
                     gint          width,
                     gint          height)
  {
   gdk_draw_rectangle(obj_,gc,filled,x,y,width,height);
  }

void Gdk_Drawable::draw_arc       (Gdk_GC       &gc,
                     gint          filled,
                     gint          x,
                     gint          y,
                     gint          width,
                     gint          height,
                     gint          angle1,
                     gint          angle2)
  {
   gdk_draw_arc(obj_,gc,filled,x,y,width,height,
                angle1,angle2);
  }

void Gdk_Drawable::draw_polygon   (Gdk_GC       &gc,
                     gint          filled,
                     Gdk_Points   &points,
                     gint          npoints)
  {}

void Gdk_Drawable::draw_string    (Gdk_Font     &font,
                     Gdk_GC       &gc,
                     gint          x,
                     gint          y,
                     const string &str)
  {
   gdk_draw_string (obj_,font,gc,x,y,str.c_str());
  }

void Gdk_Drawable::draw_text      (Gdk_Font     &font,
                     Gdk_GC       &gc,
                     gint          x,
                     gint          y,
                     const string &text,
                     gint          text_length)
  {
   gdk_draw_text (obj_,font,gc,
     x,y,text.c_str(),text_length);
  }

void Gdk_Drawable::draw_pixmap     
                          (Gdk_GC       &gc,
                           Gdk_Drawable &src,
                           gint          xsrc,
                           gint          ysrc,
                           gint          xdest,
                           gint          ydest,
                           gint          width,
                           gint          height)
  {
   gdk_draw_pixmap (obj_,gc,src,
     xsrc,ysrc,xdest,ydest,width,height);
  }

void Gdk_Drawable::draw_bitmap    
                         (Gdk_GC       &gc,
                          Gdk_Bitmap   &src,
                          gint          xsrc,
                          gint          ysrc,
                          gint          xdest,
                          gint          ydest,
                          gint          width,
                          gint          height)
  {
   gdk_draw_pixmap (obj_,gc,src,
     xsrc,ysrc,xdest,ydest,width,height);
  }

void Gdk_Drawable::draw_image     
                         (Gdk_GC       &gc,
                          Gdk_Image    &image,
                          gint          xsrc,
                          gint          ysrc,
                          gint          xdest,
                          gint          ydest,
                          gint          width,
                          gint          height)
  {
   gdk_draw_image (obj_,gc,image,
   xsrc,ysrc,xdest,ydest,width,height);
  }

void Gdk_Drawable::draw_points    
                         (Gdk_GC        &gc,
                          GdkPoint    *points,
                          gint          npoints)
  {
   gdk_draw_points (obj_,gc,points,npoints);
  }

void Gdk_Drawable::draw_segments  
                         (Gdk_GC       &gc,
                          GdkSegment  *segs,
                          gint          nsegs)
  {
   gdk_draw_segments (obj_,gc,segs,nsegs);
  }

void Gdk_Drawable::draw_lines     
                         (Gdk_GC        &gc,
                          GdkPoint     *points,
                          gint          npoints)
  {
   gdk_draw_lines (obj_,gc,points,npoints);
  }

void Gdk_Drawable::draw_polygon    
                          (Gdk_GC        &gc,
                           gint        filled,
                           GdkPoint    *points,
                           gint          npoints)
  {
   gdk_draw_polygon(obj_,gc,filled,points,npoints);
  }

#if GDK_VERSION_GT(1,0)
void Gdk_Drawable::draw_text_wc   (Gdk_Font      &font,
                     Gdk_GC        &gc,
                     gint          x,
                     gint          y,
                     const GdkWChar *text,
                     gint          text_length)
  {
   gdk_draw_text_wc(*this,font,gc,x,y,text,text_length);
  }    
#endif

