
#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include <malloc.h>
#include <ctype.h>
#include <sys/types.h>
#include <unistd.h>

#include <iostream.h>

// format for SIGNAL_SPEC:
//     SIGNAL_SPEC(void GtkCList@show_all(int,int,int))
// (for arg types, s/_/ /g operation is made for it to transform
// _'s to spaces..)
//
// SIGNAL_START(thisclass, baseclass) - start a block with signals
// SIGNAL_END() - end a block of signals
// CPP_CLASS_INIT_HOOK() - ???
// CLASS_START; - this marks a position in header between #includes and classes
// IMPL_START; - this marks a position between header and .cc file
// BASE_PREFIX(Gtk) - PRefix for base class for gnome support 
//                     (Gtk_ to Gnome_ change)
// PREFIX(Gtk) - prefix for this class...
//
// SIGNAL_SPEC            -       VFUNC, PROXY
// SIGNAL_SHORT_SPEC      -       PROXY
// SIGNAL_VFUNC_SPEC      -       VFUNC
//
//
//VFUNC here means that it attaches to gtk+'s virtual function table and
//generates *_impl virtual function.
//
//PROXY means that it instantiates a Signal_ProxyN class for it.
//

// If gtk+ has an entry in GtkWidgetClass structure, then it should
// have *_impl function in gtk--. (this allows people to override
// the virtual function in derived classes)
//
// If gtk+ has a signal created in gtk_*_class_init, then it should
// have a proxy. (this allows people to connect to the signal and emit...)
//
// If gtk+ has gtk_*_foobar and signal in gtk_*_class_init, then we
// should have a proxy and it should have 3 arguments for proxy's
// constructor - giving &gtk_*_foobar as the 3rd argument. If gtk_*_foobar's
// type doesnt match, might need to add that GtkCList@ part for it.
// (this causes the emit call gtk_*_foobar instead of gtk_signal_emit).

// for determining gtk version (better use gtk/gtk.h, it works on all gtk's)
#include <gtk/gtk.h>
//#include <gtk/gtkfeatures.h>

#ifndef GTK_MAJOR_VERSION
#define GTK_MAJOR_VERSION 0
#define GTK_MINOR_VERSION 0
#define GTK_MICRO_VERSION 0
#endif

#define GTK_VERSION_GT(major,minor) ((GTK_MAJOR_VERSION>major)||(GTK_MAJOR_VERSION==major)&&(GTK_MINOR_VERSION>minor))
#define GTK_VERSION_GE(major,minor) ((GTK_MAJOR_VERSION>major)||(GTK_MAJOR_VERSION==major)&&(GTK_MINOR_VERSION>=minor))
#define GTK_VERSION_EQ(major,minor) ((GTK_MAJOR_VERSION==major)&&(GTK_MINOR_VERSION==minor))
#define GTK_VERSION_NE(major,minor) ((GTK_MAJOR_VERSION!=major)||(GTK_MINOR_VERSION!=minor))
#define GTK_VERSION_LE(major,minor) ((GTK_MAJOR_VERSION<major)||(GTK_MAJOR_VERSION==major)&&(GTK_MINOR_VERSION<=minor))
#define GTK_VERSION_LT(major,minor) ((GTK_MAJOR_VERSION<major)||(GTK_MAJOR_VERSION==major)&&(GTK_MINOR_VERSION<minor))

/****************************** Forward declarations  *****************************************/

struct parameter_spec;
struct type_spec;
struct signal_spec;
struct signal_block_start;

void print_param_list_names(FILE *fptr, parameter_spec *p);
void print_param_list_both(FILE *fptr, parameter_spec *p);
void print_param_list_types(FILE *fptr, parameter_spec *p);
char *signal_func(FILE *fptr,char *c,char*n); 
char *signal_func1(FILE *fptr, char *c,char *n);
void checkchar(char *s, char c);
char *parseparam(char *s, parameter_spec **p);
char *parsename(char *s, char **name);
char *parsesignal(char *signal_decl,char *signal_parm, signal_spec **spec);
char *parsetype(char *s, type_spec *spec);
void parse_error(char *err,char *rest);
void generate_signal_object1(FILE *fptr, signal_spec *p, signal_block_start *bs);

void printfromtemplate(FILE *fptr, const char *format, const char **replacelist);

extern "C" {
    char *strdup(const char *);
}

char *parameter_count(parameter_spec *p);
char *get_arg_types(parameter_spec *p);
char *get_arg_both(parameter_spec *p);
char *get_arg_names(parameter_spec *p);

/*********************************************************************
***** Data structures 
*********************************************************************/
struct parser_keywords 
  {
    char *name;
    char *(*function)(char *b,char *n);
    int line; // should this generate a #line statement
  };

struct signal_block_start 
  {
   public:
     char *uname;
     char *lname;
     char *base;
     char *baseprefix;
     char *prefix;
     struct signal_spec *first;
     signal_block_start() 
       : uname(0), lname(0), base(0), 
       baseprefix(0), prefix(0), first(0) 
       { }
  };

struct type_spec 
  {
    char *name;
  };

struct parameter_spec 
  {
    type_spec type;
    parameter_spec *next;
  };

struct signal_spec 
  {
    type_spec rettype;
    signal_spec *next;
    parameter_spec *firstparameter;
    char *funcname;
    char *funcname_gtk;
    char *classname_gtk;
    int is_short_spec;
    int is_vfunc_spec;
    signal_spec() 
      : next(0), firstparameter(0), funcname(0), 
        is_short_spec(0),is_vfunc_spec(0) 
      { }
  };

struct compare_function 
  {
   const char *op;
   bool (*function)(int major, int minor, int micro);
  };

struct file_info
  {
   char *name;
   char *srcdir;
   char *destdir;
   int local;
   int doc;
   int gnome_widget;
  };

/*********************************************************************
***** Global data 
*********************************************************************/
int pid;
//static char *cpp_class_init_hook = NULL;

struct signal_block_start currentblock;
struct file_info current_file_info={0,0,0,0,0,0};

FILE *current_file;     // current_output (points to one of following)
FILE *headerprivate1;
FILE *headerprivate2; 
FILE *header1;
FILE *header2; 
FILE *source1; 
FILE *source2;
FILE *documentation;

static int linenum=1;

/*********************************************************************
***** Text manipulation functions
*********************************************************************/

char *lowercase(char* s)
  {
    static char tmp[1024];

    if (!s) return s;
    strcpy(tmp,s);
    s=tmp;

    while (*s) 
      {
        *s = tolower(*s);
        ++s;
      }
    return tmp;
  }

char *uppercase(char* s)
  {
    static char tmp[1024];

    if (!s) return s;
    strcpy(tmp,s);
    s=tmp;

    while (*s) 
      {
        *s = toupper(*s);
        ++s;
      }
    return tmp;
  }

char *capitalize(char* s) 
  {
    static char tmp[1024];

    if (!s) return s;
    strcpy(tmp,s);

    strcpy(s,lowercase(s));
    if (tmp[0] != '\0') 
       { tmp[0] = toupper(tmp[0]); }
    return tmp;
  }

//
// Text substitution command
//
// Use this function like this:
// char *repl[]={"NAME","DATA",
//               "FOO","D1",
//               "FOO2","D3",
//                0,0};
// char *source="djkfghdkjhgdjghjk $NAME$FOO$FOO2"
// printfromtemplate(source,repl); will print
// "djkfghdkjhgdjghjk DATAD1D12"
//
void printfromtemplate(FILE *fptr, const char *format, const char **replacelist) 
  {
   char *f=strdup(format);
   char *freeme=f;

   char *t;
   while(1) 
     {
      t=strchr(f,'$');       // t points to next $
      if (t == NULL) break;

      // output part before $ (null-terminate at $ then restore $)
      *t='\0';
      fprintf(fptr,"%s",f);    
      *t='$';                
      
      // check if we have a match
      const char **repllist=replacelist; // replacelist AKA "mapping"

      while( *repllist != '\0')  // mapping is NULL terminated 
        {
         if ( strncmp(*repllist, // The string to replace
           t+1,       // Right after $
           strlen(*repllist)) == 0 ) 
           { break; }
	 else 
           { repllist+=2; }             // Step to next thing to replace
        }

      if (*repllist) 
        {
         // we do. print replacement
         fprintf(fptr,"%s",repllist[1]);   // The replacement string.
	 f = t + strlen(repllist[0]) + 1; // Start after the template.    
        } 
      else 
        {
         fprintf(fptr,"$");
	 f = t + 1;
        }
      }
   fprintf(fptr,"%s",f); // print rest.
   free(freeme);
  }

// If specified, use that; otherwise take guess
//  based on which lib we're compiling.
char *prefix() 
  {
    static char buf[100];
    strncpy(buf, current_file_info.gnome_widget ? 
	  (currentblock.prefix ? lowercase(currentblock.prefix) : "gnome") :
	  "gtk",100);
    return buf;
  }

char *Prefix()
  {
    static char buf[100];
    strncpy(buf, current_file_info.gnome_widget ? 
	  (currentblock.prefix ? capitalize(currentblock.prefix) : "Gnome") :
	  "Gtk",100);
    return buf;
  }

char *PREFIX()
  {
    static char buf[100];
    strncpy(buf, current_file_info.gnome_widget ? 
  	  (currentblock.prefix ? uppercase(currentblock.prefix) : "GNOME") :
	  "GTK",100);
    return buf;
  }


/*********************************************************************
***** Utility  
*********************************************************************/
FILE *safe_fopen (const char *p, char *n)
  {
    char b[1000];
    sprintf (b,"%s%d", p, pid);
    return fopen (b, n);
  }

// Looks for a charactor,  error if not found
void checkchar(char *s, char c) 
  {
    if (*s!=c) { 
	parse_error("checkchar failed.",s);
	fprintf(stderr,"at char '%c'\n",c);
    }
  }

void parse_error(char *err,char *rest) 
  {
    fprintf(stderr,"%d : Parse error %s\nAt: -%s\n",linenum,err,rest);
    char *a=0;
    *a=10; // sigsegv
  }

void usage(char *argv0, char *reason) 
  {
    printf("%s\n",reason);
    printf("Usage: %s [-h] [-l] name srcdir destdir\n",argv0);
    printf("    -h = help\n");
    printf("    -d = generate documentation\n");
    printf("    -l = generate local files -- use this flag for non-gtk-- widgets\n");
    printf("    -g = generate a Gnome widget\n");
    printf("\nNote: This will read srcdir/name.gen_h file and generates destdir/name.cc dir/namedest.h files.\n");
    exit(EXIT_FAILURE);
  }


/*********************************************************************
***** Code generation 
*********************************************************************/

/**** Widget Class Declaration *****/
char *widget_class_decl_template=
  "class $Prefix_$Widget_Class;\n";

char *widget_class_template= 
  "class $Prefix_$Widget_Class \n"
  "  {\n"
  "   public:\n"
  "     typedef $Prefix_$Widget       CppObjectType;\n"
  "     typedef $Prefix$Widget        BaseObjectType;\n"
  "     typedef $Prefix$WidgetClass   BaseClassType;\n"
  "     typedef $BasePrefix_$BASE_Class       CppClassParent;\n"
  "     typedef $BasePrefix$BASEClass         BaseClassParent;\n"
  "\n"
  "     static void class_init_function(BaseClassType *p);\n"
  "     static void object_init_function(BaseObjectType *o);\n"
  "     GtkType get_type();\n"
  "\n"
  "     /* callbacks */\n";

// dump of callbacks
char *widget_class_callback=
  "     static $RETTYPE $NAME_callback(BaseObjectType *o$DOT$ARGTYPES);\n";

char *widget_class_template2= 
  "\n"
  "     /* Data */\n"
  "     char *name;\n"
  "     GtkType  type;\n"
  "     BaseClassType *parent;\n"
  "  };\n";


/**** Widget Class Methods *****/
char *widget_class_methods_template= 
  "#%%line\n"
  "GtkType $Prefix_$Widget_Class::get_type() \n"
  "  {\n"
  "   if (!type) \n"
  "     {\n"
#if GTK_VERSION_EQ(1,0)
  "      GtkTypeInfo info = \n"
  "        {\n"
  "         name, \n"
  "         sizeof(BaseObjectType), \n"
  "         sizeof(BaseClassType),\n"
  "         (GtkClassInitFunc) class_init_function,\n"
  "         (GtkObjectInitFunc) object_init_function,\n"
  "         (GtkArgSetFunc) NULL,\n"
  "         (GtkArgGetFunc) NULL\n"
  "        };\n"
#elif GTK_VERSION_GT(1,0)
  "      GtkTypeInfo info = \n"
  "        {\n"
  "         name, \n"
  "         sizeof(BaseObjectType), \n"
  "         sizeof(BaseClassType),\n"
  "         (GtkClassInitFunc) class_init_function,\n"
  "         (GtkObjectInitFunc) object_init_function,\n"
  "         /* reserved_1 */ NULL,\n"
  "         /* reserved_2 */ NULL,\n"
  "         /*base_class_init_func */ (GtkClassInitFunc) NULL\n" // FIXME
  "        };\n"
#else
#error gensig had problems figuring out your gtk+ version.
#endif
  "      type=gtk_type_unique($prefix_$widget_get_type(), &info);\n"
  "      parent=static_cast<BaseClassType*>(gtk_type_parent_class(type));\n"
  "     }\n"
  "   return type;\n"
  "  }\n"
  "\n"
  "void $Prefix_$Widget_Class::class_init_function($Prefix$WidgetClass *klass)\n"
  "  {\n"
  "   CppClassParent::class_init_function((BaseClassParent*)klass);\n";

char *widget_class_methods_callback= 
  "   klass->$GTKNAME=$NAME_callback;\n";

char *widget_class_methods_template2= 
  "  }\n"
  "\n"
  "void $Prefix_$Widget_Class::object_init_function($Prefix$Widget *)\n"
  "  {}\n"
  "\n"
  "// Initialize static class object\n"
  "$Prefix_$Widget_Class $Prefix_$Widget::$widget_class={\"$Prefix_$Widget\",0,0};\n"
  "\n"
  "void *$Prefix_$Widget::get_parent_class() \n"
  "  {\n"
  "   return static_cast<void*>($widget_class.parent);\n"
  "  }\n"
  "\n"
  "bool $Prefix_$Widget::is$Prefix$Widget(Gtk_Object *checkcast)\n"
  "  {\n"
  "   return $PREFIX_IS_$IS(checkcast->gtkobj());\n"
  "  }\n"
  "\n"
  "GtkType $Prefix_$Widget::get_type()\n"
  "  {\n"
  "   return $widget_class.get_type();\n"
  "  }\n"
  "\n"
;


/**** Widget impl method templates *****/

// insert before list of impl declarations
char *widget_end_template =
  "protected:\n"
  "  /* impl functions */\n";
// impl declaration 
char *widget_impl =
  "  virtual $RETTYPE $NAME_impl($ARGBOTH);\n";
// inserted after list of impl declarations
char *widget_end_template2 =
  "public:\n"
  "  $Prefix$Widget* gtkobj() { return $PREFIX_$IS(gtkobject); }\n"
  "  const $Prefix$Widget* gtkobj() const { return $PREFIX_$IS(gtkobject); }\n"
  "  static bool is$Prefix$Widget(Gtk_Object *checkcast);\n"
  ;


// definition of methods for callbacks and impl methods
char *widget_impl_method =
  "$RETTYPE $Prefix_$Widget::$NAME_impl($ARGBOTH) \n"
  "  {\n"
  "    BaseClassType *sig=static_cast<BaseClassType *>(get_parent_class());\n"
  "    if (!sig->$NAME) \n"
  "      { $RETURN_RV; }\n"
  "    $RETURNsig->$NAME(gtkobj()$DOT$ARGNAMES);\n"
  "  }\n"
  "\n"
  "$RETTYPE $Prefix_$Widget_Class::$NAME_callback($Prefix$Widget *o$DOT$ARGBOTH) \n"
  "  {\n"
  "    CppObjectType *obj=static_cast<CppObjectType *>(gtk_object_get_data(GTK_OBJECT(o),\"cpp\"));\n"
  "    if (obj) \n"
  "      $RETURNobj->$NAME_impl($ARGNAMES);\n"
  "    $RETURN_0;\n"
  "  }\n"
  "\n";


// inserted at the top of a widget declaration
char *widget_begin_template =
  "protected:\n"
  "  typedef $Prefix_$Widget_Class    CppClassType;\n"
  "  typedef $Prefix$Widget           BaseObjectType;\n"
  "  typedef $Prefix$WidgetClass      BaseClassType;\n"
  "\n"
  "  virtual void *get_parent_class();\n"
  "\n"
  "private:\n"
  "  friend CppClassType;\n"
  "  static CppClassType $widget_class; \n"
  "  GtkType get_type(); \n"
  "\n"
  "public:\n"
  ;

// Generates the end of class declarations, 
// Gtk_*_Class declarations and methods, and 
// impl and callback methods
void generate_vfuncs()
  {
    char NAME[100];

    strcpy(NAME,uppercase(currentblock.lname));

    const char *mapping[]={
	"widget",currentblock.lname,
	"Widget",currentblock.uname,
        "IS",NAME,
	"BASE", currentblock.base,
	"BasePrefix", currentblock.baseprefix,
	"prefix", prefix(),
	"Prefix", Prefix(),
	"PREFIX", PREFIX(),
	0,0};

    printfromtemplate(header1,widget_class_decl_template,mapping);
    printfromtemplate(headerprivate2,widget_class_template,mapping);
    printfromtemplate(source2,widget_class_methods_template,mapping);
    printfromtemplate(header2,widget_end_template,mapping);
   
    signal_spec *p=currentblock.first;
    for(;p;p=p->next) 
      {
	const char *mapping[]=
          {
	   "Widget",currentblock.uname,
	   "widget",currentblock.lname,
           "IS",NAME,
           "NUM",parameter_count(p->firstparameter),    
           "RETTYPE",p->rettype.name,
           "ARGTYPES", get_arg_types(p->firstparameter),   
           "NAME", p->funcname, 
           "DOT", (p->firstparameter?",":""),
           "ARGBOTH", get_arg_both(p->firstparameter),
           "ARGNAMES", get_arg_names(p->firstparameter),
           "prefix", prefix(), 
           "Prefix", Prefix(),
           "PREFIX", PREFIX(),
           "GTKNAME", p->funcname_gtk,
           0,0
          }; 

       printfromtemplate(headerprivate2,widget_class_callback,mapping);
       printfromtemplate(source2,widget_class_methods_callback,mapping);
       printfromtemplate(header2, widget_impl,mapping);
      }

    printfromtemplate(headerprivate2,widget_class_template2,mapping);
    printfromtemplate(source2,widget_class_methods_template2,mapping);
    printfromtemplate(header2,widget_end_template2,mapping);

    //if(cpp_class_init_hook)
    //  fprintf(current_file, "    %s;\n", cpp_class_init_hook);

    // Methods
    p=currentblock.first;
    for(;p;p=p->next) 
      {
       const char *mapping[]=
         {
	  "Widget",currentblock.uname,
	  "widget",currentblock.lname,
          "IS",NAME,
          "NUM",parameter_count(p->firstparameter),    
          "RETTYPE",p->rettype.name,
          "ARGTYPES", get_arg_types(p->firstparameter),   
          "NAME", p->funcname, 
          "DOT", (p->firstparameter?",":""),
          "ARGBOTH", get_arg_both(p->firstparameter),
          "ARGNAMES", get_arg_names(p->firstparameter),
          "RETURN_0", (strcmp(p->rettype.name,"void"))?"return 0":"return",
          "RETURN_RV", (!strcmp(p->rettype.name,"gint"))
                        ? "gint rv=*(gint*)gtkmm_rv; *(gint*)gtkmm_rv=0; return rv"
                        : (strcmp(p->rettype.name,"void")
                           ? "return 0"
                           : "return" ),
          "RETURN", (strcmp(p->rettype.name,"void"))?"return ":"",
          "Prefix", Prefix(),
          "PREFIX", PREFIX(),
          "GTKOBJECT", p->classname_gtk,
          0,0  
         }; 

       if(!p->is_short_spec) 
         printfromtemplate(source2,widget_impl_method,mapping);
      }
  }

void generate_signal_object1(FILE *fptr, signal_spec *p, signal_block_start *) 
  {
    char *genheader="";
    if (!p->is_vfunc_spec) 
      {
	if (!strcmp(p->rettype.name,"void")) 
          { genheader="  Signal_proxy$NUM<BaseObjectType$DOT$ARGTYPES> $NAME;"; } 
        else 
          { genheader="  Signal_proxy$NUM_r<$RETTYPE,BaseObjectType$DOT$ARGTYPES> $NAME;"; }
      } 

    /* gtkmm_rv hack here when sig->$NAME is NULL */
    const char *mapping[]=
      {
	"NUM",parameter_count(p->firstparameter),    
	"RETTYPE",p->rettype.name,
	"ARGTYPES", get_arg_types(p->firstparameter),   
	"NAME", p->funcname, 
	"DOT", (p->firstparameter?",":""),
	0,0 /* no casts here, new eg++ does not like them */
      };

    printfromtemplate(fptr,genheader,mapping);
  }


void generate_class_header()
  {
    const char *mapping[]=
      {
	"widget",currentblock.lname,
	"Widget",currentblock.uname,
	"Prefix", Prefix(),
	0,0 /* no casts here, new eg++ does not like them */
      };
    printfromtemplate(current_file,widget_begin_template,mapping);
  }

void generate_headers()
  {

    fprintf(header1,"// -*- c++ -*-\n");
    fprintf(header1,"/*  Generated by gensig from %s.gen_h. DO NOT MODIFY!!! */\n",
      current_file_info.name);
    fprintf(source1,"// -*- c++ -*-\n");
    fprintf(source1,"/*  Generated by gensig from %s.gen_h. DO NOT MODIFY!!! */\n",
      current_file_info.name);
    fprintf(headerprivate1,"// -*- c++ -*-\n");
    fprintf(headerprivate1,"/*  Generated by gensig from %s.gen_h. DO NOT MODIFY!!! */\n",
      current_file_info.name);
    if (!current_file_info.local)
      if (current_file_info.gnome_widget) {
	fprintf(source1,"#include <gnome--/%s.h>\n",current_file_info.name);
      }
      else {
	fprintf(source1,"#include <gtk--/%s.h>\n",current_file_info.name);
      }
    else
      fprintf(source1,"#include \"%s.h\"\n",current_file_info.name);

    if (current_file_info.gnome_widget) {
      // Some of the Gnome basenames have - in them
      char * f = strdup(current_file_info.name);
      char * p = f;
      while (*p != '\0') {
	if (*p == '-') { *p = '_'; }
	++p;
      }
      fprintf(header1,"#ifndef GNOMEMM_%s_HEADER\n#define GNOMEMM_%s_HEADER\n",
        uppercase(f),uppercase(f));
      fprintf(headerprivate1,"#ifndef GNOMEMM_%s_P_HEADER\n#define GNOMEMM_%s_P_HEADER\n",
        uppercase(f),uppercase(f));
      free(f);
    }
    else {
      fprintf(header1,"#ifndef GTKMM_%s_HEADER\n#define GTKMM_%s_HEADER\n",
        uppercase(current_file_info.name), uppercase(current_file_info.name));
      fprintf(headerprivate1,"#ifndef GTKMM_%s_P_HEADER\n#define GTKMM_%s_P_HEADER\n",
        uppercase(current_file_info.name), uppercase(current_file_info.name));
    }
  }

void generate_line(int line)
  {
   fprintf (current_file,"#line %d \"%s.gen_h\"\n", 
            line, current_file_info.name); 
  }

/*********************************************************************
***** Parser functions 
*********************************************************************/
char *parseparam(char *s, parameter_spec **p) 
  {
    *p=new parameter_spec;
    (*p)->next=0;
    switch(*s++) 
      {
        case ')': // end of param list.
          delete *p;
          *p=0;
          s--;
          break;

        case ',': // next param
        case '(': // start of param list
          if (*s==')') 
            { 
              delete *p; 
              *p=0;     
              break; 
            }
          s=parsetype(s,&(*p)->type);
          {   
            char *c=(*p)->type.name;
            for(;*c;c++) 
              if (*c=='_') *c=' '; // convert all _'s to spaces
          }
          s=parseparam(s,&(*p)->next);
          break;

        default:
          parse_error("Parseparam expected '(', ')' or ','",s);
      }
    //fprintf(stderr,"PARAM Parsed\n");
    return s;
  }

char *parsename(char *s, char **name) 
  {
    int l1=strspn(s," ");
    s+=l1;
    int l=strcspn(s," (),");
    if (!l) {
	parse_error("Expected ' ', '(' or ')'",s);
    }
    char *n=new char[l+1];
    *n=0;
    strncpy(n,s,l);
    n[l]=0;
    *name=n;
    //fprintf(stderr,"NAME Parsed\n");
    return s+l;
  }

//
// signaltype is start of signal spec keyword
// s is the start of the type 
// spec is the item to hold the spec 
char *parsesignal(char *signal_decl, char *signal_parm, signal_spec **spec) 
  {
    int len;
    char *lfuncname;
  
    *spec=new signal_spec;
    signal_parm=parsetype(signal_parm,&(*spec)->rettype);
    checkchar(signal_parm++,' ');
    signal_parm=parsename(signal_parm,&(*spec)->funcname);

    // this handles GtkEditable@move_cursor(gint,gint) format
    // so that the GtkEditable is a name of gtk object.. if not
    // present, GtkObjet is used.
    char *delimiter=strchr((*spec)->funcname,'@');
    if (delimiter) 
      {
        (*spec)->classname_gtk=(char*)malloc(delimiter-(*spec)->funcname +1);
        strncpy((*spec)->classname_gtk,(*spec)->funcname,delimiter - (*spec)->funcname);
        (*spec)->classname_gtk[delimiter-(*spec)->funcname]=0;      
        char *tmpd=(*spec)->funcname;
        char *tmps=delimiter+1;
        // no strcpy here because of overlapping strings.
        while(*tmps) 
          { *tmpd++=*tmps++; }
        *tmpd=0;
      } 
    else 
      {
       (*spec)->classname_gtk="GtkObject";
      }

    len = strlen(lfuncname = (*spec)->funcname);
    
    // if funcname ends with '_c', funcname_gtk is funcname without the '_c'
    if(!strcmp(lfuncname + len - 2, "_c")) 
      {
       (*spec)->funcname_gtk = new char[len];
       strncpy((*spec)->funcname_gtk, lfuncname, len - 2);
       (*spec)->funcname_gtk[len - 2 ] = 0;
      } 
    else 
      (*spec)->funcname_gtk = lfuncname;

    (*spec)->is_short_spec = 
      !strncmp(signal_decl, "SIGNAL_SHORT_SPEC", strlen("SIGNAL_SHORT_SPEC"));
    (*spec)->is_vfunc_spec = 
      !strncmp(signal_decl, "SIGNAL_VFUNC_SPEC", strlen("SIGNAL_VFUNC_SPEC"));
    
    checkchar(signal_parm,'(');
    signal_parm=parseparam(signal_parm,&(*spec)->firstparameter);
    checkchar(signal_parm++,')');
    //fprintf(stderr,"SIGNAL Parsed\n");

    return signal_parm;
  }

// cannot have spaces or ,'s inside type.
// this cannot read  void(*)()'s.
char *parsetype(char *s, type_spec *spec) 
  {
    int l=strcspn(s,"), ");
    char *tname=new char[l+1];
    *tname=0;
    strncpy(tname,s,l);
    tname[l]=0;
    spec->name=tname;
    //fprintf(stderr,"TYPE Parsed\n");
    return s+l;
  }

int parameter_count_num(parameter_spec *p) 
  {
    if (!p) 
      return 0;
    return 1+parameter_count_num(p->next);
  }

char *parameter_count(parameter_spec *p) 
  {
    char *t=(char*)malloc(2);
    t[0]="0123456789"[parameter_count_num(p)];
    t[1]=0;
    return t;
  }

char *get_arg_types(parameter_spec *p) 
  {
    char *c=(char*)malloc(2);
    *c=0;
    while(p) 
      {
	char *c1=(char*)malloc(strlen(c)+strlen(p->type.name)+1+1+1);
	strcpy(c1,c);
	strcat(c1,p->type.name);
	p=p->next;
	if (p) strcat(c1,", ");
	free(c);
	c=c1;
      }
    return c;
  }

char *get_arg_both(parameter_spec *p) 
  {
    char *c=(char*)malloc(2);
    *c=0;
    char *pp=(char*)malloc(4);
    pp[0]=' '; pp[1]='p'; pp[3]=0;
    int count=0;
    while(p) 
      {
	char *c1=(char*)malloc(strlen(c)+strlen(p->type.name)+6);
	strcpy(c1,c);
	strcat(c1,p->type.name);
	pp[2]="1234567890"[count];
	strcat(c1,pp);
	p=p->next;
	if (p) strcat(c1,", ");
	free(c);
	c=c1;
	count++;
      }
    return c;
  }

char *get_arg_names(parameter_spec *p) 
  {
    char *c=(char*)malloc(2);
    *c=0;
    char *pp=(char*)malloc(3);
    pp[0]='p'; pp[2]=0;
    int count=0;
    while(p) 
      {
	char *c1=(char*)malloc(strlen(c)+1+2+1+1);
	strcpy(c1,c);
	pp[1]="1234567890"[count];
	strcat(c1,pp);
	p=p->next;
	if (p) strcat(c1,", ");
	free(c);
	c=c1;
	count++;
      }
    return c;
  }



/*********************************************************************
***** Token handling functions 
*********************************************************************/
char *signalspec_func(char *s ,char *c) 
  {  
    signal_spec **spec=&currentblock.first;

    // go to end of list
    while(*spec&&(*spec)->next) 
      { spec=&(*spec)->next; }
    if (*spec) 
      spec=&(*spec)->next;

    checkchar(c++,'(');
    c=parsesignal(s,c,spec);
    checkchar(c++,')');

    generate_signal_object1(current_file,*spec,&currentblock);
    return c;
  }

//char *cppclassinithook_func(char *, char *c) 
//  {
//    int size;
//  
//    char *t;
//  
//    checkchar(c++,'(');
//    if(! (t = strchr(c, ')')))
//       {
//         fprintf(stderr, "Bad CPP_CLASS_INIT_HOOK\n");
//         exit(-1);
//       }
//  
//    cpp_class_init_hook = new char[(size = t - c) + 1];
//    memset(cpp_class_init_hook, 0, size + 1);
//    memcpy(cpp_class_init_hook, c, size);
//
//    //  printf("%%%% : cpp_class_init_hook : '%s'\n", cpp_class_init_hook);
//  
//    return t + 1;
//  
//  }

char *signalstart_func(char *, char *c) 
  {
    currentblock.first=0; // mem leak.
    checkchar(c++,'(');
    c=parsename(c,&currentblock.uname);
    checkchar(c++,',');
    c=parsename(c,&currentblock.base);
    checkchar(c++,')');

    // stupid hack
    if (!current_file_info.gnome_widget) currentblock.baseprefix = strdup("Gtk");

    // the next one converts CheckButton to check_button, and HRuler to hruler
    currentblock.lname=(char*)malloc(strlen(currentblock.uname)+1+15);
    char *tmp1=currentblock.uname;
    char *tmp2=currentblock.lname;
    bool was_upper = false;

    while(*tmp1)
      {
        
        if (isupper(tmp1[0]) &&
  	  !was_upper &&
	  tmp1!=currentblock.uname &&
	  tmp1!=currentblock.uname+1)
	  {
	    *tmp2='_';
	    tmp2++;
	    was_upper = true;
	  } 
        else 
          if (islower(tmp1[0])) 
            {
	     was_upper = false;
	    }
      
        *tmp2=tolower(*tmp1);
        tmp1++; tmp2++;
      }

    *tmp2=0; // null terminate
    //strcpy(currentblock.lname,currentblock.uname);

    generate_class_header();
    return c;
  }

char *signalend_func(char *, char *c) 
  {
    checkchar(c++,'(');
    checkchar(c++,')');
    generate_vfuncs();
    return c;
  }

char *class_start_func(char *, char *c) 
  {
    current_file=header2;
    return c;
  }

char *impl_start_func(char *, char *c) 
  {
    current_file=source1;
    return c;
  }

char *private_start_func(char *, char *c) 
  {
    current_file=headerprivate1;
    return c;
  }

char *documentation_start_func(char *, char *c) 
  {
    current_file=documentation;
    return c;
  }

char *base_prefix_func(char *, char * c) 
  {
    checkchar(c++, '(');
    c=parsename(c,&currentblock.baseprefix);
    checkchar(c++, ')');
    return c;
  }

char *prefix_func(char *, char * c) 
  {
    checkchar(c++, '(');
    c=parsename(c,&currentblock.prefix);
    checkchar(c++, ')');
    return c;
  }

struct parser_keywords keywords[]=
  {
    {"SIGNAL_START",signalstart_func,0},
    {"SIGNAL_SPEC",signalspec_func,0},
    {"SIGNAL_SHORT_SPEC",signalspec_func,0},
    {"SIGNAL_VFUNC_SPEC",signalspec_func,0},
    {"SIGNAL_END",signalend_func,1},
    {"CLASS_START",class_start_func,1},
    {"IMPL_START", impl_start_func,1},
    {"BASE_PREFIX", base_prefix_func,1},
    {"PRIVATE_START", private_start_func,0},
    {"DOCUMENTATION_START", documentation_start_func,0},
    {"PREFIX", prefix_func,1},
    {0,0,0}
  };

bool cond_comp_eq(int major, int minor, int micro) {
   if(major!=GTK_MAJOR_VERSION)
      return false;

   if(minor==-1)
      return true;   
   if(minor!=GTK_MINOR_VERSION)
      return false;

   if(micro==-1)
      return true;
   return micro==GTK_MICRO_VERSION;
}

bool cond_comp_gt(int major, int minor, int micro) {
   int diff;

   diff=GTK_MAJOR_VERSION-major;
   if(diff)
      return diff>0;

   diff=GTK_MINOR_VERSION-minor;
   if(diff)
      return diff>0;

   return GTK_MICRO_VERSION>micro;
}

bool cond_comp_geq(int major, int minor, int micro) {
   return cond_comp_eq(major,minor,micro)
       || cond_comp_gt(major,minor,micro);
}

bool cond_comp_lt(int major, int minor, int micro) {
    return !cond_comp_geq(major,minor,micro);
}

bool cond_comp_leq(int major, int minor, int micro) {
    return cond_comp_eq(major,minor,micro)
	|| cond_comp_lt(major,minor,micro);
}


struct compare_function 
 cond_compare[]={
   { "==", cond_comp_eq },
   { ">=",cond_comp_geq },
   { ">", cond_comp_gt },
   { "<", cond_comp_lt },
   { "<=", cond_comp_leq },
   { 0, 0 }
};

bool cond_output, cond_active;

char *cond_start_func(char *, char *arg) 
  {
   if(cond_active)
      parse_error("nested conditionals not yet allowed",arg);

   while(*arg && isspace(*arg)) ++arg;
   char *start=arg;
   while(*arg && !isspace(*arg) && !isdigit(*arg)) ++arg;
   if(start==arg)
      parse_error("expecting comparison operator",arg);

   compare_function *c=cond_compare;
   while(c->op) {
      if(!strncmp(start,c->op,arg-start))
         break;
      ++c;
   }
   if(!c->op) 
      parse_error("expecting comparison operator",arg);

   int major, minor, micro;
   if(sscanf(arg,"%d.%d.%d",&major,&minor,&micro)!=3)
      if(sscanf(arg,"%d.%d",&major,&minor)!=2)
         if(sscanf(arg,"%d",&major)!=1)
            parse_error("expecting gtk version number",arg);
         else
            minor=micro=-1;
      else
         micro=-1;

   cond_output=(c->function)(major,minor,micro);
   cond_active=true;

   return 0;
  }

char *cond_else_func(char *, char *arg) 
  {
   if(!cond_active)
      parse_error("#elsegtk without #ifgtk",arg);
   cond_output=!cond_output;
   return 0;
  }

char *cond_end_func(char *, char *arg) 
  {
   if(!cond_active)
      parse_error("#endifgtk without #ifgtk",arg);
   cond_output=true;
   cond_active=false;
   return 0;
  }

struct parser_keywords cond_keywords[]=
  {
    {"#ifgtk", cond_start_func,1},
    {"#elsegtk", cond_else_func,1},
    {"#endifgtk", cond_end_func,1},
    {0,0,0}
  };

void parser(FILE *infile) 
  {  
    char buf[180];
    cond_active=false;
    cond_output=true;
    while(fgets(buf,180,infile)) 
      {
	char *sbuf=buf;
	while(sbuf) 
          {
            parser_keywords *p=cond_keywords;
            while(p->name) 
              {
               unsigned int name_len=strlen(p->name);
               if(strlen(sbuf)>=name_len &&
                  !strncmp(sbuf,p->name,name_len))
               {
                  (void)(p->function)(sbuf,sbuf+name_len);
                  if(cond_output)
 		     generate_line(linenum+1);
                  sbuf=0;
                  goto nextfind;
               }
               ++p;
              }
            if(!cond_output) 
              {
               sbuf=0;
               goto nextfind;
              }
	    p=keywords;
	    while(p->name) 
              {
		char *t=strstr(sbuf,p->name);
		if (t) 
                  {
		    sbuf=(p->function)(t,t+strlen(p->name));
		    checkchar(sbuf++,';');
		    if (p->line) generate_line(linenum);
		    goto nextfind;
		  }
		p++;
	      }
	    // default action is to print the line as it is and read next.
	    fprintf(current_file,"%s",sbuf);
	    sbuf=0;
	  nextfind:;
	  } 
	linenum++;
    }
    //fprintf(stderr,"FILE Parsed\n");
  }

int main(int argc,char *argv[]) 
  {
    FILE *in=0;
    int i=1;
    char buf[1024],error[240],*bptr1,*bptr2;

    while ((i<argc)&&(argv[i][0]=='-'))
      {switch (argv[i][1])
         {case 'h': /* version */
            usage(argv[0],"");
          case 'l': /* local */
            current_file_info.local=1;
            break;
	  case 'd': /* documentation */
	    current_file_info.doc = 1;
	    break;
	  case 'g': /* Gnome widget */
	    current_file_info.gnome_widget = 1;
	    break;
          default:
            printf("Unknown option %s\n",argv[i]);
         }
       i++;
      } 

    if (argc-i==3) 
      {
        current_file_info.name=argv[i];
        current_file_info.srcdir=argv[i+1];
        current_file_info.destdir=argv[i+2]; 

        strcpy(buf,current_file_info.srcdir);
        strcat(buf,current_file_info.name);
        strcat(buf,".gen_h");
	in=fopen(buf,"r");
	if (!in) 
          {
	    sprintf(error,"Cannot open file %s.",buf);
	    usage(argv[0],error);
          }
      } 
    else 
      {
	usage(argv[0],"Invalid number of arguments.");
      }
    pid = getpid();
    
    current_file=safe_fopen(".gtkmmheader1_","w");
    source1=safe_fopen(".gtkmmsource1_","w");
    source2=safe_fopen(".gtkmmsource2_","w");
    header1=safe_fopen(".gtkmmheader1_","w");
    header2=safe_fopen(".gtkmmheader2_","w");
    headerprivate1=safe_fopen(".gtkmmpheader1_","w");
    headerprivate2=safe_fopen(".gtkmmpheader2_","w");
    if (!current_file_info.doc)
      documentation=fopen("/dev/null","w");
    else
      documentation=header2;
   
    current_file=header1;

    generate_headers(); 
    parser(in);

    fprintf(headerprivate2,"#endif\n");
    fprintf(header2,"#endif\n");

    fclose(headerprivate1);
    fclose(headerprivate2);
    fclose(header1);
    fclose(header2);
    fclose(source1);
    fclose(source2);
    if (!current_file_info.doc)
      fclose(documentation);

    // compare new .h with current one, rename it only if different
    char newtarget[1024], currenttarget[1024];
    sprintf(newtarget, "%s/%s_tmp.h", current_file_info.destdir,current_file_info.name);
    sprintf(currenttarget, "%s/%s.h", current_file_info.destdir,current_file_info.name);
    sprintf(buf,"cat .gtkmmheader1_%d .gtkmmheader2_%d >%s",pid,pid,newtarget);
    system(buf);
    sprintf(buf, "cmp %s %s >/dev/null 2>/dev/null", newtarget, currenttarget);

    if(system(buf)) 
     {
      cerr << currenttarget << " changed. " << endl;
      rename(newtarget, currenttarget);
     } 
    else 
     {
      //cerr << "generated " << newtarget
      //   << " is identical with current" << endl;
      unlink(newtarget);
     }
    
    if (!current_file_info.doc)
      {
       sprintf(newtarget, "%s/%s_tmp.cc", current_file_info.destdir,current_file_info.name);
       sprintf(currenttarget, "%s/%s.cc", current_file_info.destdir,current_file_info.name);
       sprintf(buf," awk '{line=line+1; if ($0==\"#%%%%line\") print \"#line\",line,\"\\\"%s.cc\\\"\"; else print; }' .gtkmmsource1_%d .gtkmmsource2_%d >%s",
         current_file_info.name,pid,pid,newtarget);
       system(buf);
       sprintf(buf, "cmp %s %s >/dev/null 2>/dev/null", newtarget, currenttarget);

       if(system(buf)) 
         {
           cerr << currenttarget << " changed. " << endl;
           rename(newtarget, currenttarget);
         } 
       else 
         {
           //cerr << "generated " << newtarget
           //   << " is identical with current" << endl;
           unlink(newtarget);
         }


       sprintf(newtarget, "%s/private/%s_p_tmp.h", current_file_info.destdir,current_file_info.name);
       sprintf(currenttarget, "%s/private/%s_p.h", current_file_info.destdir,current_file_info.name);
       sprintf(buf,"cat .gtkmmpheader1_%d .gtkmmpheader2_%d >%s",pid,pid,newtarget);
       system(buf);
       sprintf(buf, "cmp %s %s >/dev/null 2>/dev/null", newtarget, currenttarget);

       if(system(buf)) 
         {
           cerr << currenttarget << " changed. " << endl;
           rename(newtarget, currenttarget);
         } 
         else 
         {
           //cerr << "generated " << newtarget
           //   << " is identical with current" << endl;
           unlink(newtarget);
         }
      }
    
    sprintf(buf,"rm .gtkmmheader1_%d .gtkmmheader2_%d .gtkmmpheader1_%d .gtkmmpheader2_%d .gtkmmsource1_%d .gtkmmsource2_%d",
      pid,pid,pid,pid,pid,pid);
    system(buf);
    return 0;
  }

