/*
 *
 * Copyright 1998-1999, University of Notre Dame.
 * Authors: Jeffrey M. Squyres, Kinis L. Meyer with M. D. McNally 
 *          and Andrew Lumsdaine
 *
 * This file is part of the Notre Dame LAM implementation of MPI.
 *
 * You should have received a copy of the License Agreement for the
 * Notre Dame LAM implementation of MPI along with the software; see
 * the file LICENSE.  If not, contact Office of Research, University
 * of Notre Dame, Notre Dame, IN 46556.
 *
 * Permission to modify the code and to distribute modified code is
 * granted, provided the text of this NOTICE is retained, a notice that
 * the code was modified is included with the above COPYRIGHT NOTICE and
 * with the COPYRIGHT NOTICE in the LICENSE file, and that the LICENSE
 * file is distributed with the modified code.
 *
 * LICENSOR MAKES NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED.
 * By way of example, but not limitation, Licensor MAKES NO
 * REPRESENTATIONS OR WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY
 * PARTICULAR PURPOSE OR THAT THE USE OF THE LICENSED SOFTWARE COMPONENTS
 * OR DOCUMENTATION WILL NOT INFRINGE ANY PATENTS, COPYRIGHTS, TRADEMARKS
 * OR OTHER RIGHTS.  
 *
 * Additional copyrights may follow.
 *
 *	Ohio Trollius
 *	Copyright 1996 The Ohio State University
 *	GDB
 *
 *	$Id: asc_workdir.c,v 6.1 1999/06/16 06:27:04 jsquyres Exp $
 *
 *	Function:	- sets working dir for an application schema
 *			- LAM specific
 *	Accepts:	- parsed application schema
 *			- working dir
 *	Returns:	- 0 or LAMERROR
 */

#include <string.h>

#include "all_list.h"
#include "app_schema.h"

int
asc_workdir(LIST *applist, char *wrkdir)
{
    struct aschema *p;			/* current app process */
/*
 * Set workdir in each entry in the schema.
 */
    p = al_top(applist);
    while (p) {
	if (!p->asc_env->ape_wrkdir) {
	    p->asc_env->ape_wrkdir = strdup(wrkdir);

	    if (!p->asc_env->ape_wrkdir)
		return(LAMERROR);
	}

	p = al_next(applist, p);
    }

    return(0);
}
