/*
 *
 * Copyright 1998-1999, University of Notre Dame.
 * Authors: Jeffrey M. Squyres, Kinis L. Meyer with M. D. McNally 
 *          and Andrew Lumsdaine
 *
 * This file is part of the Notre Dame LAM implementation of MPI.
 *
 * You should have received a copy of the License Agreement for the
 * Notre Dame LAM implementation of MPI along with the software; see
 * the file LICENSE.  If not, contact Office of Research, University
 * of Notre Dame, Notre Dame, IN 46556.
 *
 * Permission to modify the code and to distribute modified code is
 * granted, provided the text of this NOTICE is retained, a notice that
 * the code was modified is included with the above COPYRIGHT NOTICE and
 * with the COPYRIGHT NOTICE in the LICENSE file, and that the LICENSE
 * file is distributed with the modified code.
 *
 * LICENSOR MAKES NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED.
 * By way of example, but not limitation, Licensor MAKES NO
 * REPRESENTATIONS OR WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY
 * PARTICULAR PURPOSE OR THAT THE USE OF THE LICENSED SOFTWARE COMPONENTS
 * OR DOCUMENTATION WILL NOT INFRINGE ANY PATENTS, COPYRIGHTS, TRADEMARKS
 * OR OTHER RIGHTS.  
 *
 * Additional copyrights may follow.
 *
 *
 *	Revision 6.2  1999/03/17 14:19:38  jsquyres
 *
 *	Revision 6.1  1996/11/23 21:54:41  nevin
 *	Ohio Release
 *	
 * Revision 6.0  96/02/29  13:53:07  gdburns
 * Ohio Release
 * 
 * Revision 5.2  94/08/22  14:00:23  gdburns
 * Ohio Release
 * 
 * Revision 5.1  94/05/18  12:44:14  gdburns
 * Ohio Release
 * 
 * Revision 2.3  94/04/22  12:48:38  gdburns
 * Ohio Release
 * 
 * Revision 2.2.1.4  94/01/08  16:34:07  raja
 * Remove const from prototypes for now.
 * 
 * Revision 2.2.1.3  94/01/07  16:05:01  raja
 * Make list elements (void *).
 * 
 * Revision 2.2.1.2  93/12/11  17:04:02  raja
 * Use const in prototypes.
 * 
 * Revision 2.2.1.1  93/09/15  14:59:15  raja
 * Declare ANSI C and C++ function prototypes.
 * 
 * Revision 2.2  92/04/30  14:44:52  trillium
 * Ohio Release
 * 
 * Revision 2.1  92/01/10  17:36:38  gdburns
 * initial revision
 * 
 *	Function:	- constants and templates associated with all_slist
 */

#ifndef _ALLSLIST
#define _ALLSLIST

#include <all_list.h>

typedef struct al_desc	SLIST;

#define als_top(x) ((void *) al_body(x->al_ltop))
#define als_bottom(x) ((void *) al_body(x->al_lbottom))
#define als_find al_find
#define als_next al_next
#define als_prev al_prev
#define als_count al_count

#ifdef __cplusplus
extern "C" {
#endif

extern SLIST		*als_init __ARGS((int4 elemsize, int4 (*comp)(),
				int4 nlist, struct al_head *list, SLIST *ald));
extern void		*als_append __ARGS((SLIST *ald, void *unew));
extern void		*als_insert __ARGS((SLIST *ald, void *unew));
extern int4		*als_delete __ARGS((SLIST *ald, char *old));

#ifdef __cplusplus
}
#endif

#endif
