/*
 *
 * Copyright 1998-1999, University of Notre Dame.
 * Authors: Jeffrey M. Squyres, Kinis L. Meyer with M. D. McNally 
 *          and Andrew Lumsdaine
 *
 * This file is part of the Notre Dame LAM implementation of MPI.
 *
 * You should have received a copy of the License Agreement for the
 * Notre Dame LAM implementation of MPI along with the software; see
 * the file LICENSE.  If not, contact Office of Research, University
 * of Notre Dame, Notre Dame, IN 46556.
 *
 * Permission to modify the code and to distribute modified code is
 * granted, provided the text of this NOTICE is retained, a notice that
 * the code was modified is included with the above COPYRIGHT NOTICE and
 * with the COPYRIGHT NOTICE in the LICENSE file, and that the LICENSE
 * file is distributed with the modified code.
 *
 * LICENSOR MAKES NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED.
 * By way of example, but not limitation, Licensor MAKES NO
 * REPRESENTATIONS OR WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY
 * PARTICULAR PURPOSE OR THAT THE USE OF THE LICENSED SOFTWARE COMPONENTS
 * OR DOCUMENTATION WILL NOT INFRINGE ANY PATENTS, COPYRIGHTS, TRADEMARKS
 * OR OTHER RIGHTS.  
 *
 * Additional copyrights may follow.
 *
 *
 *	$Id: laminternal.h,v 1.1 1999/07/29 21:10:58 jsquyres Exp $
 *
 *	Function:	- prototypes for internally used LAM functions
 */

#ifndef _LAM_INTERNAL_H
#define _LAM_INTERNAL_H

#include <sys/types.h>
#include <sys/uio.h>

#include <lam_config.h>
#include <kreq.h>
#include <portable.h>
#include <tstdio.h>
#include <typical.h>

#ifdef __cplusplus
extern "C" {
#endif

extern char	*getworkdir __ARGS((void));
extern int	getinetaddr __ARGS((char *, unsigned char *));

extern char	*killname __ARGS((void));
extern char 	*sockname __ARGS((void));

extern int	lam_mktmpid __ARGS((int, char *, unint));

extern void	(*(_lam_signal())) __ARGS((int, void (*) ()));

extern int4	stoi __ARGS((unsigned char *));

extern void	nodespin_init __ARGS((char *));
extern void	nodespin_next __ARGS((int4));
extern void	nodespin_end __ARGS((void));

extern void	_cio_cleanup __ARGS((void));
extern void	_cio_bail __ARGS((int));
extern int	_cipc_ksrfront __ARGS((struct kreq *, struct kreply *));
extern int	_cipc_ksrback __ARGS((struct kreq *, struct kreply *));

extern off_t 	lam_iomap_lseek __ARGS((unsigned int, int, off_t, int));
extern int 	lam_iomap_open __ARGS((unsigned int, char *, int, int));
extern int	lam_iomap_close __ARGS((unsigned int, int));
extern int 	lam_iomap_read __ARGS((unsigned int, int, char *, int));
extern int 	lam_iomap_write __ARGS((unsigned int, int, const char *, int));

extern void 	_getbuf __ARGS((register TFILE *));
extern int	_fmt __ARGS((TFILE *, char *, const char *, ...));

extern int	 mread __ARGS((int, char *, int4));
extern int	 mreadv __ARGS((int, struct iovec *, int));
extern int	 mwrite __ARGS((int, const char *, int));
extern int	 mwritev __ARGS((int, struct iovec *, int));

#ifdef __cplusplus
}
#endif

#endif	/* _LAM_INTERNAL_H */
