/*
 *
 * Copyright 1998-1999, University of Notre Dame.
 * Authors: Jeffrey M. Squyres, Kinis L. Meyer with M. D. McNally 
 *          and Andrew Lumsdaine
 *
 * This file is part of the Notre Dame LAM implementation of MPI.
 *
 * You should have received a copy of the License Agreement for the
 * Notre Dame LAM implementation of MPI along with the software; see
 * the file LICENSE.  If not, contact Office of Research, University
 * of Notre Dame, Notre Dame, IN 46556.
 *
 * Permission to modify the code and to distribute modified code is
 * granted, provided the text of this NOTICE is retained, a notice that
 * the code was modified is included with the above COPYRIGHT NOTICE and
 * with the COPYRIGHT NOTICE in the LICENSE file, and that the LICENSE
 * file is distributed with the modified code.
 *
 * LICENSOR MAKES NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED.
 * By way of example, but not limitation, Licensor MAKES NO
 * REPRESENTATIONS OR WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY
 * PARTICULAR PURPOSE OR THAT THE USE OF THE LICENSED SOFTWARE COMPONENTS
 * OR DOCUMENTATION WILL NOT INFRINGE ANY PATENTS, COPYRIGHTS, TRADEMARKS
 * OR OTHER RIGHTS.  
 *
 * Additional copyrights may follow.
 *
 *	Ohio Trollius
 *	Copyright 1997 The Ohio	State University
 *	NJN/RBD
 *
 *	$Id: tstruct_f.c,v 6.4 1999/09/02 01:34:36 prijks Exp $
 *
 *	Function:	- MPI_Type_struct F77 wrapper
 */

#include <lam_config.h>

#include <errno.h>
#include <stdlib.h>

#include <blktype.h>
#include <mpi.h>
#include <MPISYSF.h>
#include <mpisys.h>

void
mpi_type_struct_(c, b, d, t, nt, ierr)

int			*c, *b,	*d, *t,	*nt, *ierr;

{
	MPI_Datatype	dtype;
	MPI_Datatype	*tp;
	MPI_Aint	*dp;
	int		i;

	if (*c > 0) {
		tp = (MPI_Datatype *) malloc((*c) * sizeof(MPI_Datatype));
		if (tp == 0) {
			lam_setfunc_m(BLKMPITSTRUCT);
			*ierr =	lam_errfunc(MPI_COMM_WORLD, BLKMPITSTRUCT,
					lam_mkerr(MPI_ERR_OTHER, errno));
			return;
		}

		dp = (MPI_Aint *) malloc((*c) * sizeof(MPI_Aint));
		if (dp == 0) {
			free((char *) tp);
			lam_setfunc_m(BLKMPITSTRUCT);
			*ierr =	lam_errfunc(MPI_COMM_WORLD, BLKMPITSTRUCT,
					lam_mkerr(MPI_ERR_OTHER, errno));
			return;
		}
	} else {
		tp = 0;
		dp = 0;
	}

	for (i = 0; i <	*c; ++i) {
		tp[i] =	GETHDL(t[i]);
		dp[i] =	(MPI_Aint) d[i];
	}

	*ierr =	MPI_Type_struct(*c, b, dp, tp, &dtype);

	if (lam_F_make_hdl(nt, ierr, dtype, BLKMPITSTRUCT)) {
		dtype->dt_f77handle = *nt;
		dtype->dt_flags |= LAM_LANGF77;
	}

	free((char *) tp);
	free((char *) dp);
}
