/*
 *
 * Copyright 1998-1999, University of Notre Dame.
 * Authors: Jeffrey M. Squyres, Kinis L. Meyer with M. D. McNally 
 *          and Andrew Lumsdaine
 *
 * This file is part of the Notre Dame LAM implementation of MPI.
 *
 * You should have received a copy of the License Agreement for the
 * Notre Dame LAM implementation of MPI along with the software; see
 * the file LICENSE.  If not, contact Office of Research, University
 * of Notre Dame, Notre Dame, IN 46556.
 *
 * Permission to modify the code and to distribute modified code is
 * granted, provided the text of this NOTICE is retained, a notice that
 * the code was modified is included with the above COPYRIGHT NOTICE and
 * with the COPYRIGHT NOTICE in the LICENSE file, and that the LICENSE
 * file is distributed with the modified code.
 *
 * LICENSOR MAKES NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED.
 * By way of example, but not limitation, Licensor MAKES NO
 * REPRESENTATIONS OR WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY
 * PARTICULAR PURPOSE OR THAT THE USE OF THE LICENSED SOFTWARE COMPONENTS
 * OR DOCUMENTATION WILL NOT INFRINGE ANY PATENTS, COPYRIGHTS, TRADEMARKS
 * OR OTHER RIGHTS.  
 *
 * Additional copyrights may follow.
 *
 *	Ohio Trollius
 *	Copyright 1997 The Ohio State University
 *	RBD
 *
 *	$Id: sendrecvrep.c,v 6.3 1999/05/25 22:08:15 kmeyer1 Exp $
 *
 *	Function:	- send and receive using same buffer
 *	Accepts:	- buffer
 *			- count
 *			- datatype
 *			- destination
 *			- send tag
 *			- source
 *			- receive tag
 *			- communicator
 *			- status (out)
 *	Returns: 	- MPI_SUCCESS or error code
 */

#include <stdlib.h>

#include <blktype.h>
#include <mpi.h>
#include <mpisys.h>
#include <terror.h>


int
MPI_Sendrecv_replace(buf, count, dtype, dest, stag, src, rtag, comm, status)

void			*buf;
int			count;
MPI_Datatype		dtype;
int			dest;
int			stag;
int			src;
int			rtag;
MPI_Comm		comm;
MPI_Status		*status;

{
	int		err;			/* error code */
	int		fl_trace;		/* do tracing? */
	int		pkpos;			/* packing position */
	int		pksize;			/* packing size */
	char		*pkbuf;			/* packing buffer */

	lam_initerr_m();
	lam_setfunc_m(BLKMPISENDRECVREP);
/*
 * Most of the arguments will be checked in the sendrecv call.
 * Generate a start wrapper trace.
 */
	fl_trace = ((_kio.ki_rtf & RTF_TRON) == RTF_TRON);

	if (fl_trace) {
		lam_tr_wrapstart(BLKMPISENDRECVREP);
	}
/*
 * Pack the message to send.
 */
	err = MPI_Pack_size(count, dtype, comm, &pksize);
	if (err != MPI_SUCCESS) {
		return(lam_errfunc(comm, BLKMPISENDRECVREP, err));
	}

	if (pksize > 0) {
		pkbuf = malloc((unsigned) pksize);
		if (pkbuf == 0) {
			return(lam_errfunc(comm, BLKMPISENDRECVREP,
					lam_mkerr(MPI_ERR_OTHER, errno)));
		}
	} else {
		pkbuf = 0;
	}

	pkpos = 0;

	err = MPI_Pack(buf, count, dtype, pkbuf, pksize, &pkpos, comm);
	if (err != MPI_SUCCESS) {
		if (pkbuf) free(pkbuf);
		return(lam_errfunc(comm, BLKMPISENDRECVREP, err));
	}
/*
 * Send & receive.
 */
	err = MPI_Sendrecv(pkbuf, pksize, MPI_PACKED, dest, stag,
				buf, count, dtype, src, rtag, comm, status);
	if (err != MPI_SUCCESS) {
		if (pkbuf) free(pkbuf);
		return(lam_errfunc(comm, BLKMPISENDRECVREP, err));
	}

	if (pkbuf) free(pkbuf);
/*
 * Generate an end wrapper trace.
 */
	if (fl_trace) {
		lam_tr_wrapend(BLKMPISENDRECVREP);
	}
	
	lam_resetfunc_m(BLKMPISENDRECVREP);
	return(MPI_SUCCESS);
}
