/*
 *
 * Copyright 1998-1999, University of Notre Dame.
 * Authors: Jeffrey M. Squyres, Kinis L. Meyer with M. D. McNally 
 *          and Andrew Lumsdaine
 *
 * This file is part of the Notre Dame LAM implementation of MPI.
 *
 * You should have received a copy of the License Agreement for the
 * Notre Dame LAM implementation of MPI along with the software; see
 * the file LICENSE.  If not, contact Office of Research, University
 * of Notre Dame, Notre Dame, IN 46556.
 *
 * Permission to modify the code and to distribute modified code is
 * granted, provided the text of this NOTICE is retained, a notice that
 * the code was modified is included with the above COPYRIGHT NOTICE and
 * with the COPYRIGHT NOTICE in the LICENSE file, and that the LICENSE
 * file is distributed with the modified code.
 *
 * LICENSOR MAKES NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED.
 * By way of example, but not limitation, Licensor MAKES NO
 * REPRESENTATIONS OR WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY
 * PARTICULAR PURPOSE OR THAT THE USE OF THE LICENSED SOFTWARE COMPONENTS
 * OR DOCUMENTATION WILL NOT INFRINGE ANY PATENTS, COPYRIGHTS, TRADEMARKS
 * OR OTHER RIGHTS.  
 *
 * Additional copyrights may follow.
 *
 *	Ohio Trollius
 *	Copyright 1994 The Ohio State University
 *	GDB
 *
 *	$Log: rbfsweep.c,v $
 *	Revision 6.2  1999/05/26 21:50:00  kmeyer1
 *	
 *	added copyright
 *	
 *	Revision 6.1  1996/11/24 00:25:53  nevin
 *	Ohio Release
 *	
 * Revision 6.0  96/02/29  14:04:57  gdburns
 * Ohio Release
 * 
 * Revision 5.2  94/08/22  14:13:27  gdburns
 * Ohio Release
 * 
 * Revision 5.1  94/05/18  12:58:04  gdburns
 * Ohio Release
 * 
 * Revision 2.3  94/04/22  12:46:13  gdburns
 * Ohio Release
 * 
 * Revision 2.2.1.1  94/02/15  15:32:15  gdburns
 * Revise bufferd request codes.
 * 
 * Revision 2.2  93/10/15  11:28:33  gdburns
 * pre-release to 2.3
 * 
 *	Function:	- removes all buffered messages
 */

#include <net.h>
#include <events.h>
#include <bfreq.h>

int
rbfsweep(node)

int4			node;

{
	struct nmsg	nhead;		/* network header */
	struct bfreq  	*request;	/* bufferd request */

	request = (struct bfreq *) nhead.nh_data;
	request->bfq_req = BFQSWEEP;

	nhead.nh_node = node;
	nhead.nh_event = EVBUFFERD;
	nhead.nh_type = DLCTL;
	nhead.nh_flags = NOBUF;
	nhead.nh_length = 0;
	nhead.nh_msg = 0;

	return(nsend(&nhead));
}
