/*
** Copyright (c) Massachusetts Institute of Technology 1994-1998.
**          All Rights Reserved.
**          Unpublished rights reserved under the copyright laws of
**          the United States.
**
** THIS MATERIAL IS PROVIDED AS IS, WITH ABSOLUTELY NO WARRANTY EXPRESSED
** OR IMPLIED.  ANY USE IS AT YOUR OWN RISK.
**
** This code is distributed freely and may be used freely under the 
** following conditions:
**
**     1. This notice may not be removed or altered.
**
**     2. Works derived from this code are not distributed for
**        commercial gain without explicit permission from MIT 
**        (for permission contact lclint-request@sds.lcs.mit.edu).
*/
/*
** boolStack.h
*/

# ifndef boolStack_H
# define boolStack_H

typedef struct _boolStack
{
  int nelements;
  int nspace;
  int current;
  /*@reldef@*/ bool  *elements;
} _boolStack ;

typedef _boolStack *boolStack ;

# define boolStack_size(s) ((s)->nelements)   
# define boolStack_isEmpty(s) (boolStack_size(s) == 0)
# define boolStack_empty(s) (boolStack_size(s) == 0)

extern boolStack boolStack_new(void);

extern void boolStack_push (boolStack s, bool el) ;
extern void boolStack_pop (boolStack s) ;
extern bool boolStack_top (boolStack s) ;

extern cstring boolStack_unparse (boolStack s) ;
extern void boolStack_free (/*@only@*/ boolStack s) ;
extern void boolStack_switchTop (boolStack s);

# define boolStackBASESIZE MIDBASESIZE

# else
# error "Multiple include"
# endif




