package com.jclark.xsl.tr;

import com.jclark.xsl.om.*;
import com.jclark.xsl.expr.VariantBase;

public abstract class ResultFragmentVariantBase extends VariantBase implements ResultFragmentVariant {
  public String convertToString() throws XSLException {
    StringResult result = new StringResult();
    append(result);
    return result.toString();
  }

  static private class BooleanResult implements Result {
    boolean empty = true;

    public void characters(String str) {
      if (str.length() > 0)
	empty = false;
    }

    public void startElement(Name elementType,
			     NamespacePrefixMap nsMap) {
      empty = false;
    }

    public void endElement(Name elementType) {
      empty = false;
    }

    public void comment(String str) {
      empty = false;
    }

    public void processingInstruction(String target, String data) {
      empty = false;
    }

    public void attribute(Name name, String value) { }

    public void start() { }
    public void end() { }
  }

  public boolean convertToBoolean() throws XSLException {
    BooleanResult result = new BooleanResult();
    append(result);
    return !result.empty;
  }
}
