// Copyright (C) 1999 Open Source Telecom Corporation.
//  
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software 
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
// 
// As a special exception to the GNU General Public License, permission is 
// granted for additional uses of the text contained in its release 
// of APE.
// 
// The exception is that, if you link the APE library with other files
// to produce an executable, this does not by itself cause the
// resulting executable to be covered by the GNU General Public License.
// Your use of that executable is in no way restricted on account of
// linking the APE library code into it.
// 
// This exception does not however invalidate any other reasons why
// the executable file might be covered by the GNU General Public License.
// 
// This exception applies only to the code released under the 
// name APE.  If you copy code from other releases into a copy of
// APE, as the General Public License permits, the exception does
// not apply to the code that you add in this way.  To avoid misleading
// anyone as to the status of such modified files, you must delete
// this exception notice from them.
// 
// If you write modifications of your own for APE, it is your choice
// whether to permit this exception to apply to your modifications.
// If you do not wish that, delete this exception notice.  

#include "config.h"
#include "macros.h"
#include "thread.h"
#include "socket.h"
#include <fcntl.h>
#include <errno.h>

#ifndef	O_NONBLOCK
#define	O_NONBLOCK	O_NDELAY
#endif

UDPSimplex::UDPSimplex(InetAddress &ia, short port, short foreign) : 
Socket(AF_INET, SOCK_DGRAM, 0)
{
	struct	sockaddr_in addr;

	if(!foreign)
		foreign = port;

	Disconnect();	// assure not started live
	addr.sin_family = AF_INET;
	addr.sin_addr = getaddress(ia);
	addr.sin_port = htons(port);
	if(bind(so, (sockaddr *)&addr, sizeof(addr)))
	{
		close(so);
		state = SOCKET_INITIAL;
		throw((Socket *)this);
		return;
	}
	state = SOCKET_BOUND;
	peer = foreign;
}

int UDPSimplex::Connect(InetHostAddress &ia)
{
	struct sockaddr_in addr;
	int len = sizeof(addr);

	addr.sin_family = AF_INET;
	addr.sin_addr = getaddress(ia);
	addr.sin_port = peer;
	return connect(so, (sockaddr *)&addr, len);
}

int UDPSimplex::Broadcast(BroadcastAddress &subnet)
{
	struct sockaddr_in addr;
	int len = sizeof(addr);
	int bcast = 1;

	setsockopt(so, SOL_SOCKET, SO_BROADCAST, (char *)&bcast, (socklen_t)sizeof(bcast));
	addr.sin_family = AF_INET;
	addr.sin_addr = getaddress(subnet);
	addr.sin_port = peer;
	return connect(so, (sockaddr *)&addr, len);
}

int UDPSimplex::Loopback(void)
{
	struct sockaddr_in addr;
	socklen_t len = sizeof(addr);
	int rtn;

	rtn = getsockname(so, (sockaddr *)&addr, &len);
	if(rtn)
		return rtn;

	return connect(so, (sockaddr *)&addr, len);
}

#ifdef	AF_UNSPEC
int UDPSimplex::Disconnect(void)
{
	struct sockaddr_in addr;
	int len = sizeof(addr);

	memset(&addr, 0, len);
	addr.sin_family = AF_UNSPEC;
	return connect(so, (sockaddr *)&addr, len);
}
#else
int UDPSimplex::Disconnect(void)
{
	return Loopback();
}
#endif

UDPDuplex::UDPDuplex(InetAddress &bind, short from, short to)
{
	sender = new UDPSimplex(bind, from, to);
	receiver = new UDPSimplex(bind, to, from);
};

UDPDuplex::~UDPDuplex()
{
	if(sender)
		delete sender;

	if(receiver)
		delete receiver;
}

int UDPDuplex::Connect(InetHostAddress &host)
{
	int rtn = sender->Connect(host);
	if(rtn)
	{
		sender->Disconnect();
		receiver->Disconnect();
		return rtn;
	}
	return receiver->Connect(host);
}

int UDPDuplex::Broadcast(BroadcastAddress &subnet)
{
	int rtn = sender->Broadcast(subnet);
	if(rtn)
	{
		sender->Disconnect();
		receiver->Disconnect();
		return rtn;
	}
	return receiver->Broadcast(subnet);
}

int UDPDuplex::Disconnect(void)
{
	int rtn = sender->Disconnect();
	return rtn | receiver->Disconnect();
}

int UDPDuplex::Loopback(void)
{
	int rtn = sender->Loopback();
	return rtn | receiver->Loopback();
}

