/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing;

import com.sun.java.accessibility.Accessible;
import com.sun.java.accessibility.AccessibleComponent;
import com.sun.java.accessibility.AccessibleContext;
import com.sun.java.accessibility.AccessibleRole;
import com.sun.java.accessibility.AccessibleState;
import com.sun.java.accessibility.AccessibleStateSet;
import com.sun.java.swing.JLayeredPane;
import com.sun.java.swing.JRootPane;
import com.sun.java.swing.RootPaneContainer;
import com.sun.java.swing.SwingUtilities;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.FocusListener;
import java.io.Serializable;
import java.util.Locale;

public class JWindow
extends Window
implements Accessible,
RootPaneContainer {
    protected JRootPane rootPane;
    protected boolean rootPaneCheckingEnabled = false;
    protected AccessibleContext accessibleContext;

    public JWindow() {
        this(null);
    }

    public JWindow(Frame frame) {
        super(frame == null ? SwingUtilities.getSharedOwnerFrame() : frame);
        this.windowInit();
    }

    protected void windowInit() {
        this.setRootPane(this.createRootPane());
        this.setRootPaneCheckingEnabled(true);
    }

    protected JRootPane createRootPane() {
        return new JRootPane();
    }

    protected boolean isRootPaneCheckingEnabled() {
        return this.rootPaneCheckingEnabled;
    }

    protected void setRootPaneCheckingEnabled(boolean bl) {
        this.rootPaneCheckingEnabled = bl;
    }

    private Error createRootPaneException(String string) {
        String string2 = this.getClass().getName();
        return new Error("Do not use " + string2 + "." + string + "() use " + string2 + ".getContentPane()." + string + "() instead");
    }

    protected void addImpl(Component component, Object object, int n) {
        if (this.isRootPaneCheckingEnabled()) {
            throw this.createRootPaneException("add");
        }
        super.addImpl(component, object, n);
    }

    public void setLayout(LayoutManager layoutManager) {
        if (this.isRootPaneCheckingEnabled()) {
            throw this.createRootPaneException("setLayout");
        }
        super.setLayout(layoutManager);
    }

    public JRootPane getRootPane() {
        return this.rootPane;
    }

    protected void setRootPane(JRootPane jRootPane) {
        if (this.rootPane != null) {
            this.remove(this.rootPane);
        }
        this.rootPane = jRootPane;
        if (this.rootPane != null) {
            boolean bl = this.isRootPaneCheckingEnabled();
            try {
                this.setRootPaneCheckingEnabled(false);
                this.add((Component)this.rootPane, "Center");
                return;
            }
            finally {
                Object var4_3 = null;
                this.setRootPaneCheckingEnabled(bl);
            }
        }
    }

    public Container getContentPane() {
        return this.getRootPane().getContentPane();
    }

    public void setContentPane(Container container) {
        this.getRootPane().setContentPane(container);
    }

    public JLayeredPane getLayeredPane() {
        return this.getRootPane().getLayeredPane();
    }

    public void setLayeredPane(JLayeredPane jLayeredPane) {
        this.getRootPane().setLayeredPane(jLayeredPane);
    }

    public Component getGlassPane() {
        return this.getRootPane().getGlassPane();
    }

    public void setGlassPane(Component component) {
        this.getRootPane().setGlassPane(component);
    }

    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleJWindow();
        }
        return this.accessibleContext;
    }

    protected class AccessibleJWindow
    extends AccessibleContext
    implements Serializable,
    AccessibleComponent {
        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.WINDOW;
        }

        public AccessibleStateSet getAccessibleStateSet() {
            AccessibleStateSet accessibleStateSet = SwingUtilities.getAccessibleStateSet(JWindow.this);
            if (JWindow.this.getFocusOwner() != null) {
                accessibleStateSet.add(AccessibleState.ACTIVE);
            }
            return accessibleStateSet;
        }

        public Accessible getAccessibleParent() {
            Container container = JWindow.this.getParent();
            if (container instanceof Accessible) {
                return (Accessible)((Object)container);
            }
            return null;
        }

        public int getAccessibleIndexInParent() {
            return SwingUtilities.getAccessibleIndexInParent(JWindow.this);
        }

        public int getAccessibleChildrenCount() {
            return SwingUtilities.getAccessibleChildrenCount(JWindow.this);
        }

        public Accessible getAccessibleChild(int n) {
            return SwingUtilities.getAccessibleChild(JWindow.this, n);
        }

        public Locale getLocale() {
            return JWindow.this.getLocale();
        }

        public AccessibleComponent getAccessibleComponent() {
            return this;
        }

        public Color getBackground() {
            return ((Component)JWindow.this).getBackground();
        }

        public void setBackground(Color color) {
            ((Component)JWindow.this).setBackground(color);
        }

        public Color getForeground() {
            return JWindow.this.getForeground();
        }

        public void setForeground(Color color) {
            JWindow.this.setForeground(color);
        }

        public Cursor getCursor() {
            return JWindow.this.getCursor();
        }

        public void setCursor(Cursor cursor) {
            ((Component)JWindow.this).setCursor(cursor);
        }

        public Font getFont() {
            return JWindow.this.getFont();
        }

        public void setFont(Font font) {
            ((Component)JWindow.this).setFont(font);
        }

        public FontMetrics getFontMetrics(Font font) {
            return JWindow.this.getFontMetrics(font);
        }

        public boolean isEnabled() {
            return JWindow.this.isEnabled();
        }

        public void setEnabled(boolean bl) {
            JWindow.this.setEnabled(bl);
        }

        public boolean isVisible() {
            return JWindow.this.isVisible();
        }

        public void setVisible(boolean bl) {
            ((Component)JWindow.this).setVisible(bl);
        }

        public boolean isShowing() {
            return JWindow.this.isShowing();
        }

        public boolean contains(Point point) {
            return JWindow.this.contains(point);
        }

        public Point getLocationOnScreen() {
            return JWindow.this.getLocationOnScreen();
        }

        public Point getLocation() {
            return JWindow.this.getLocation();
        }

        public void setLocation(Point point) {
            ((Component)JWindow.this).setLocation(point);
        }

        public Rectangle getBounds() {
            return JWindow.this.getBounds();
        }

        public void setBounds(Rectangle rectangle) {
            ((Component)JWindow.this).setBounds(rectangle);
        }

        public Dimension getSize() {
            return JWindow.this.getSize();
        }

        public void setSize(Dimension dimension) {
            ((Component)JWindow.this).setSize(dimension);
        }

        public Accessible getAccessibleAt(Point point) {
            return SwingUtilities.getAccessibleAt(JWindow.this, point);
        }

        public boolean isFocusTraversable() {
            return JWindow.this.isFocusTraversable();
        }

        public void requestFocus() {
            JWindow.this.requestFocus();
        }

        public void addFocusListener(FocusListener focusListener) {
            JWindow.this.addFocusListener(focusListener);
        }

        public void removeFocusListener(FocusListener focusListener) {
            JWindow.this.removeFocusListener(focusListener);
        }

        AccessibleJWindow() {
            JWindow.this = JWindow.this;
        }
    }
}

