/*
 * The contents of this file are subject to the Mozilla Public License
 * Version 1.0 (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS"
 * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See the
 * License for the specific language governing rights and limitations
 * under the License.
 *
 * The Initial Developer of this code is David Baum.
 * Portions created by David Baum are Copyright (C) 1998 David Baum.
 * All Rights Reserved.
 */

#include <stdio.h>
#include "Symbol.h"
#include "PreProc.h"
#include "parser.h"

void PrintToken(int t, TokenVal v);

#define PREPROC
#define TESTFILE "::test.lex"

void main()
{
	int t;
	TokenVal v;
	FILE *fp;
	
	fp = fopen(TESTFILE, "r");
	if (!fp) return;
	
	LexPushFile(TESTFILE, fp);

#ifdef PREPROC
	while((t=gPreProc->Get(v)) != 0)
#else
	while((t=yylex(v)) != 0)
#endif
	{
		LexLocation loc;
		LexCurrentLocation(loc);
		printf("%3d : ", loc.fLine);
		PrintToken(t, v);
	}
	//gSymbolTable->Dump();
}


void PrintToken(int t, TokenVal v)
{
	printf("%3d / ", t);
	if (t < 256)
		printf("%c", t);
	else switch(t)
	{
		case ID:
			printf("%s",v.fSymbol->GetKey());
			break;
		case NUMBER:
			printf("%d", v.fInt);
			break;
		case IF:
			printf("if");
			break;
		case STRING:
			printf("%s", v.fString);
			break;
		default:
			printf("0x%08x", v.fInt);
			break;
	}
	
	printf("\n");
}


const char *FindFile(const char *filename)
{
	return filename;
}
