
/*
 * Computer Algebra Kit (c) 1993,99 by Comp.Alg.Objects.  All Rights Reserved.
 * $Id: matsq.m,v 1.2 1999/07/06 19:48:10 stes Exp $
 */

#include "cakit.h"

@implementation CAMatrixSequenceScalars
- _setUpContent:aMatrix
{
  content = aMatrix;
  eachSequence = [aMatrix eachSequence];
  return self;
}

+ content:aMatrix
{
  return [[super new] _setUpContent:aMatrix];
}

- toFirst
{
  currentSequence = [eachSequence firstElement];
  [currentSequence toFirst];
  return self;
}

- toLast
{
  currentSequence = [eachSequence lastElement];
  [currentSequence toLast];
  return self;
}

- (BOOL) isEmpty
{
  return [eachSequence isEmpty];
}

- (unsigned) size
{
  [self doesNotRecognize:_cmd];
  return 0;
}

- toElementAt:(int)i
{
  [self doesNotRecognize:_cmd];
  return self;
}

- next
{
  id next;
  assert (currentSequence != nil);

  if ((next = [currentSequence next]))
    {
      return next;
    }
  else
    {
      if ((currentSequence = [eachSequence next]))
	{
	  [currentSequence toFirst];
	  return [self next];
	}
      else
	{
	  [self toLast];
	  return nil;
	}
    }
}

- previous
{
  id previous;
  assert (currentSequence != nil);

  if ((previous = [currentSequence previous]))
    {
      return previous;
    }
  else
    {
      if (currentSequence = [eachSequence previous])
	{
	  [currentSequence toLast];
	  return [self previous];
	}
      else
	{
	  [self toFirst];
	  return nil;
	}
    }
}

@end
 
