
/*
 * Computer Algebra Kit (c) 1995,98,99 by David Stes.  All Rights Reserved.
 * $Id: monomc.m,v 1.2 1999/07/06 19:48:11 stes Exp $
 */

#include "cakit.h"

@implementation monomialc
- empty 
{
  [self subclassResponsibility:_cmd];
  return nil;
}
- (BOOL)isEmpty 
{
  [self subclassResponsibility:_cmd];
  return NO;
}
- (int)numTerms 
{
  [self subclassResponsibility:_cmd];
  return 0;
}
- eachTerm 
{
  [self subclassResponsibility:_cmd];
  return nil;
}
- insertTerm:aTerm 
{
  [self subclassResponsibility:_cmd];
  return nil;
}

- square
{
  id seq, term, res;
  res = [self empty];
  seq = [self eachTerm];
  while (term = [seq next])
    [res insertTerm:[term square]];
  return res;
}

- multiply:b
{
  id res, seq, term;
  res = [self empty];

  seq = [self eachTerm];
  while (term = [seq next])
    [res insertTerm:term];

  seq = [b eachTerm];
  while (term = [seq next])
    [res insertTerm:term];

  return res;
}

- divide:b
{
  id res, seq, term;
  res = [self empty];

  seq = [self eachTerm];
  while (term = [seq next])
    [res insertTerm:term];

  seq = [b eachTerm];
  while (term = [seq next])
    {
      term = [term inverse];
      assert ([term check]);
      if ([res insertTerm:term])
	{
	  continue;
	}
      else
	{
	  return nil;
	}
    }

  return res;
}

@end
 
