
/*
 * Computer Algebra Kit (c) 1993,99 by Comp.Alg.Objects.  All Rights Reserved.
 * $Id: symbol.m,v 1.2 1999/07/06 19:48:12 stes Exp $
 */

#include "cakit.h"

@implementation Symbol

static BOOL 
CheckValue (STR buf, int len)
{
  if (len && isalpha (buf [0]))
    {
      int i;
      for (i = 1; i < len; i++)
	if (isalnum (buf [i]) == 0)
	  return NO;
      return YES;
    }
  else
    {
      return NO;
    }
}

+ str:(STR)aString
{
  int len = strlen (aString);
  if (CheckValue (aString, len))
    {
      return [self chars:aString count:len];
    }
  else
    {
      return nil;
    }
}

- _setUpChars:(char *)aBuffer count:(int)numChars
{
  value = (char *) OC_Malloc (sizeof (char) * (numChars + 1));
  strncpy (value, aBuffer, numChars);
  value [numChars] = 0;
  return self;
}

- chars:(char *)aBuffer count:(int)numChars
{
  return [self notImplemented:_cmd];
}

+ chars:(char *)aBuffer count:(int)numChars
{
  return [[super new] _setUpChars:aBuffer count:numChars];
}

- copy
{
  STR copy = OC_Malloc (sizeof (char) * (strlen (value) + 1));
  strcpy (copy, value);
  self = [super copy];
  value = copy;
  return self;
}

- deepCopy
{
  return [self copy];
}

- release
{
  OC_Free (value);
  return [super release];
}


- (STR) str
{
  return value;
}

- str:(STR)aString
{
  return [isa str:aString];
}

- (unsigned) hash
{
  unsigned len = strlen (value);
  assert (len);
  return (len & 255) + (((unsigned) value [0]) << 8) + (((unsigned) value [len - 1]) << 16);
}

- (BOOL) isEqual:b
{
  return (self == b) ? YES : 0 == strcmp (value, [b str]);
}

- (int) compare:b
{
  return (self == b) ? 0 : strcmp (value, [b str]);
}

- (BOOL) isLetter
{
  return strlen (value) == 1;
}


- printOn:(IOD)aFile
{
  fprintf (aFile, "%s", value);
  return self;
}


- fileOutOn:aFiler
{
  [super fileOutOn:aFiler];
  [aFiler fileOut:&value type:'*'];
  return self;
}

- fileInFrom:aFiler
{
  [super fileInFrom:aFiler];
  [aFiler fileIn:&value type:'*'];
  return self;
}

@end
 
