/***********************************************************************/
/*                                                                     */
/*                           Objective Caml                            */
/*                                                                     */
/*            Xavier Leroy, projet Cristal, INRIA Rocquencourt         */
/*                                                                     */
/*  Copyright 1996 Institut National de Recherche en Informatique et   */
/*  en Automatique.  All rights reserved.  This file is distributed    */
/*  under the terms of the GNU Library General Public License.         */
/*                                                                     */
/***********************************************************************/

/* $Id: read.c,v 1.2 1999/11/17 18:58:14 xleroy Exp $ */

#include <string.h>
#include <mlvalues.h>
#include <memory.h>
#include <signals.h>
#include "unixsupport.h"

value unix_read(value fd, value buf, value ofs, value len) /* ML */
{
  DWORD numbytes, numread;
  BOOL ret;
  char iobuf[UNIX_BUFFER_SIZE];
  HANDLE h = Handle_val(fd);

  Begin_root (buf);
    numbytes = Long_val(len);
    if (numbytes > UNIX_BUFFER_SIZE) numbytes = UNIX_BUFFER_SIZE;
    enter_blocking_section();
    ret = ReadFile(h, iobuf, numbytes, &numread, NULL);
    leave_blocking_section();
    if (! ret) {
      _dosmaperr(GetLastError());
      uerror("read", Nothing);
    }
    bcopy(iobuf, &Byte(buf, Long_val(ofs)), numread);
  End_roots();
  return Val_int(numread);
}
