(*	$Id: OakMathL.Mod,v 1.1 1997/02/07 07:45:32 oberon1 Exp $	*)
MODULE OakMathL;

IMPORT LRealMath;
  
  
CONST
  pi* = LRealMath.pi;
  e* = LRealMath.exp1;
  
PROCEDURE sqrt* (x: LONGREAL): LONGREAL;
(* sqrt(x) returns the square root of x, where x must be positive. *)
  BEGIN
    RETURN LRealMath.sqrt (x)
  END sqrt;
  
PROCEDURE power* (x, base: LONGREAL): LONGREAL;             
(* power(x, base) returns the x to the power base. *)
  BEGIN
    RETURN LRealMath.power (x, base)
  END power;

PROCEDURE exp* (x: LONGREAL): LONGREAL;
(* exp(x) is the exponential of x base e.  x must not be so small that this 
   exponential underflows nor so large that it overflows. *)
  BEGIN
    RETURN LRealMath.exp (x)
  END exp;

PROCEDURE ln* (x: LONGREAL): LONGREAL;  
(* ln(x) returns the natural logarithm (base e) of x. *)
  BEGIN
    RETURN LRealMath.ln (x)
  END ln;

PROCEDURE log* (x, base: LONGREAL): LONGREAL;
(* log(x,base) is the logarithm of x base b.  All positive arguments are 
   allowed.  The base b must be positive. *)
  BEGIN
    RETURN LRealMath.log (x, base)
  END log;
   
PROCEDURE round* (x: LONGREAL): LONGREAL;
(* round(x) if fraction part of x is in range 0.0 to 0.5 then the result is 
   the largest integer not greater than x, otherwise the result is x rounded 
   up to the next highest whole number.  Note that integer values cannot always
   be exactly represented in LONGREAL or REAL format. *)
  BEGIN
    RETURN LRealMath.round (x)
  END round;

PROCEDURE sin* (x: LONGREAL): LONGREAL;
  BEGIN
    RETURN LRealMath.sin (x)
  END sin;
  
PROCEDURE cos* (x: LONGREAL): LONGREAL;
  BEGIN
    RETURN LRealMath.cos (x)
  END cos;

PROCEDURE tan* (x: LONGREAL): LONGREAL;
(* sin, cos, tan(x) returns the sine, cosine or tangent value of x, where x is
   in radians. *)
  BEGIN
    RETURN LRealMath.tan (x)
  END tan;

PROCEDURE arcsin* (x: LONGREAL): LONGREAL;
  BEGIN
    RETURN LRealMath.arcsin (x)
  END arcsin;
  
PROCEDURE arccos* (x: LONGREAL): LONGREAL;
  BEGIN
    RETURN LRealMath.arccos (x)
  END arccos;

PROCEDURE arctan* (x: LONGREAL): LONGREAL;
(* arcsin, arcos, arctan(x) returns the arcsine, arcos, arctan value in radians
   of x, where x is in the sine, cosine or tangent value. *)
  BEGIN
    RETURN LRealMath.arctan (x)
  END arctan;

PROCEDURE arctan2* (xn, xd: LONGREAL): LONGREAL;
(* arctan2(xn,xd) is the quadrant-correct arc tangent atan(xn/xd).  If the 
   denominator xd is zero, then the numerator xn must not be zero.  All
   arguments are legal except xn = xd = 0. *)
  BEGIN
    RETURN LRealMath.arctan2 (xn, xd)
  END arctan2;


PROCEDURE sinh* (x: LONGREAL): LONGREAL;
(* sinh(x) is the hyperbolic sine of x.  The argument x must not be so large 
   that exp(|x|) overflows. *) 
  BEGIN
    RETURN LRealMath.sinh (x)
  END sinh;
  
PROCEDURE cosh* (x: LONGREAL): LONGREAL;
(* cosh(x) is the hyperbolic cosine of x.  The argument x must not be so large
   that exp(|x|) overflows. *)
  BEGIN
    RETURN LRealMath.cosh (x)
  END cosh;
   
PROCEDURE tanh* (x: LONGREAL): LONGREAL;
(* tanh(x) is the hyperbolic tangent of x.  All arguments are legal. *)
  BEGIN
    RETURN LRealMath.tanh (x)
  END tanh;

PROCEDURE arcsinh* (x: LONGREAL): LONGREAL;
(* arcsinh(x) is the arc hyperbolic sine of x.  All arguments are legal. *)
  BEGIN
    RETURN LRealMath.arcsinh (x)
  END arcsinh;

PROCEDURE arccosh* (x: LONGREAL): LONGREAL;
(* arccosh(x) is the arc hyperbolic cosine of x.  All arguments greater than 
   or equal to 1 are legal. *)
  BEGIN
    RETURN LRealMath.arccosh (x)
  END arccosh;
   
PROCEDURE arctanh* (x: LONGREAL): LONGREAL;
(* arctanh(x) is the arc hyperbolic tangent of x.  |x| < 1 - sqrt(em), where 
   em is machine epsilon.  Note that |x| must not be so close to 1 that the 
   result is less accurate than half precision. *)
  BEGIN
    RETURN LRealMath.arctanh (x)
  END arctanh;


END OakMathL.
