/* -*-Mode: C++;-*-
 *
 *  GraphClass.mc
 *  Author : Renaud Pawlak (pawlak@ecoledoc.lip6.fr)
 *
 *  If you find out some problems in this sample, just email me :
 *  pawlak@ecoledoc.lip6.fr / pawlak@cnam.fr
 */

#include "GraphClass.h"
#include <fstream.h>
#include <string.h>
#include <stdio.h>
#include <stdlib.h>
#include <sys/types.h>
#include <sys/stat.h>

char *outname = "gclass-test.wish";

// Initiatization of static slots...

ofstream* GraphClass::fsp;
int GraphClass::nofClasses = 0;

// Redefinition of Class::Initialize()

bool GraphClass::Initialize()
{
    ChangeDefaultMetaclass("GraphClass");

    /* ofstream should be instantiated and fsp should be initialized
       here since Initialize() may be invoked before initializing
       static members. */
    fsp = new ofstream(outname);

    ofstream& f = *fsp;
    FILE *base;
    char ch;
    char *buf;    
    int lbase;

    if(!(base = fopen("baseScript","r")))
	cerr << "Unable to find base tk script...\n";
    fseek(base, 0L, SEEK_END);
    lbase = ftell(base);
    fseek(base, 0L, SEEK_SET);
    buf = (char*)malloc(lbase);
    fread(buf, sizeof(char), lbase-1, base);
    f << buf << endl;
    free(buf);
    fclose(base);
    return true;
}

// Redefinition of Class::TranslateClass()

void GraphClass::TranslateClass(Environment* env)
{
    Ptree *pt = Name();
    Member m;
    int i;
    bool written;
    TypeInfo type;
    ofstream& f = *fsp;

    // call the 'makeClass' tk routine...
    f << "makeClass " << (nofClasses*200)%900 << " 0 ";
    nofClasses++;
    pt->Write(f);

    // create public members...
    f << " {";
    i=1; written=FALSE;
    while(NthMember(i,m)) {
	if(m.IsPublic()) {
	    if(written) f << " ";
	    f << "{";
	    m.Name()->Write(f);
	    if(m.IsFunction()) {
		f << "(";
		m.ArgumentList()->Write(f);
		f << ")";
	    } else {      
		f << " : ";
		m.Signature(type);
		if(type.IsReferenceType() || type.IsPointerType())
		    type.Dereference();
		type.FullTypeName()->Write(f);
	    }
	    f << "}";
	    written=TRUE;
	}
	i++;
    }

    // create protected members...
    f << "} {";
    i=1; written=FALSE;
    while(NthMember(i,m)) {
	if(m.IsProtected()) {
	    if(written) f << " ";
	    f << "{";
	    m.Name()->Write(f);
	    if(m.IsFunction()) {
		f << "(";
		m.ArgumentList()->Write(f);
		f << ")";
	    } else {      
		f << " : ";
		m.Signature(type);
		if(type.IsReferenceType() || type.IsPointerType())
		    type.Dereference();
		type.FullTypeName()->Write(f);
	    }
	    f << "}";
	    written=TRUE;
	}
	i++;
    }

    // create private members...
    f << "} {";
    i=1; written=FALSE;
    while(NthMember(i,m)) {
	if(m.IsPrivate()) {
	    if(written) f << " ";
	    f << "{";
	    m.Name()->Write(f);
	    if(m.IsFunction()) {
		f << "(";
		m.ArgumentList()->Write(f);
		f << ")";
	    } else {      
		f << " : ";
		m.Signature(type);
		if(type.IsReferenceType() || type.IsPointerType())
		    type.Dereference();
		type.FullTypeName()->Write(f);
	    }
	    f << "}";
	    written=TRUE;
	}
	i++;
    }
    f << "}\n";
}

// Redefinition of Class::FinalizeClass()

Ptree *GraphClass::FinalizeClass()
{
    ClassArray classes;
    int nclasses = InstancesOf("GraphClass", classes);
    Member member;
    int nmember, relatedClass;
    TypeInfo type;
    ofstream& f = *fsp;

    // create relations if needed...
    if(!nclasses)
	return nil;

    for(int i = 0; i < nclasses; i++) {
	nmember = 1;
	while(classes[i]->NthMember(nmember,member)) {
	    member.Signature(type);
	    if(relatedClass=SearchClass(type,classes))
		f << "makeRelation " << i+1 << " " << relatedClass << "\n";
	    nmember++;
	}
    }
    f.close();
#if !defined(_MSC_VER)
    chmod(outname, S_IREAD|S_IEXEC);
#endif
    cout << "'" << outname << "'" << " has been sucessfully generated...\n";
    return nil;
}  

int GraphClass::SearchClass(TypeInfo& type,ClassArray& classes)
{
    int nclasses=classes.Number();

    if(type.IsPointerType() || type.IsReferenceType())
	type.Dereference();

    for(int i=0;i<nclasses;i++)
	if(classes[i] == type.ClassMetaobject())
	    return i+1;

    return 0;
}




