#! /usr/bin/perl -w

package Option;

sub new {
    my $class = shift;
    $class = ref($class) || $class; # see Camel Book, p295
    my $self = {};		    # ref to empty hash
    bless $self,$class;
    $self->_initialize(@_);
    return $self;
}
sub _initialize {
    my $self = shift;
    $$self{value}    = shift or warn "_initialize: value not specified";
    $$self{type}     = shift or warn "_initialize: type not specified";
    $$self{name}     = shift || "";
    $$self{longname} = shift || "";
    $$self{descript} = shift || "";
}
sub hasname {
    my $self = shift;
    return ($$self{name} ne "" ? 1 : 0);
}
sub haslongname {
    my $self = shift;
    return ($$self{longname} ne "" ? 1 : 0);
}

## getval returns the actual value of the variable associated
## with the option
sub getval {
    my $self = shift;
    return ${$$self{value}};
}
## stringval is like getval, but it returns the variable as a
## string, appropriately translated for the type of option.  
## For FLAGs, this means translating 1/0 to +/-
## For NEGFLAGs, this does the automatic inversion
## For STRINGs, quotes are added
## For INTLEVELs, 7 -> -vvvvvv so that -v7 -> -v-vvvvvvv
sub stringval {
    my $self = shift;
    $string = ${$$self{value}};
    if ($$self{type} =~ /STRING/) {
	$string='"' . $string . '"';
    }
    if ($$self{type} =~ /FLAG/) {
	print STDERR "This shouldn't happen!!\n";
	$string = ($string ? 1 : 0);
	$string = 1-$string if ($$self{type} =~ /NEG/);
	$string = ($string == 1 ? "+" : "-");
    }
    ## eg, for INTLEVEL, -v7 is written as -v-vvvvvvv
    if ($$self{type} =~ /LEVEL/) {
	$string = $$self{name} x $string;
        $string = "-" . $string;
    } 
    $string;
}
sub menuval {
    my $self = shift;
    $string = ${$$self{value}};
    if ($$self{type} =~ /STRING/) {
	$string='"' . $string . '"';
    }
    if ($$self{type} =~ /FLAG/) {
	$string = ($string ? 1 : 0);
	$string = 1-$string if ($$self{type} =~ /NEG/);
	$string = ($string == 1 ? "TRUE" : "FALSE");
    }
    ## eg, for INTLEVEL, -v7 is written as ON:7
    if ($$self{type} =~ /LEVEL/) {
	if ($string == 0) {
	    $string="OFF";
	} elsif ($string == 1) {
	    $string="ON";
	} elsif ($string > 1) {
	    $string="ON:".$string;
	}
    } 
    $string;
}
## sets the value of the associated variable according to the $val string
## that the user specifies on the command line
sub setval {
    my $self = shift;
    my $val = shift;
    if ($$self{type} =~ /FLAG/ or $$self{type} =~ /INTLEVEL/) {
	## translate + to 1, - to 0;
	$val =~ tr/+-/10/;
	## make sure val is either 1 or 0
	$val = ($val ? 1 : 0);
	## if it's a NEGFLAG, then invert the value
	$val = 1-$val if ($$self{type} =~ /NEG/);
    }
    if ($$self{type} =~ /INT/) {
	$val = int($val);
    }
    ${$$self{value}} = $val;
}

sub increment {
    my $self = shift;
    ++${$$self{value}};
}    
sub thename {
    my $self = shift;
    return $$self{name}     if $$self{name};
    return $$self{longname} if $$self{longname};
    warn "Option [$self] has no name\n";
    return undef;
}

sub print {
    my $self = shift;
    print "name=",$self->thename(),", ";
    print "type=",$$self{type},", ";
    print "value=",$self->getval(),".";
    print "\n";
}

package Option_FLAG;
@ISA = qw( Option );

sub toggle {
    my $self = shift;
    ${$$self{value}} = (${$$self{value}} ? 0 : 1);
}

sub stringval {
    my $self = shift;
    *string = $self->{value};

    die unless ($$self{type} =~ /FLAG/); # paranoid!

    $string = ($string ? 1 : 0);
    $string = 1-$string if ($$self{type} =~ /NEG/);
    $string = ($string == 1 ? "+" : "-");
    $string;
}

sub setval {
    my $self = shift;
    my $val = shift;

    ## translate + to 1, - to 0;
    $val =~ tr/+-/10/;
    ## make sure val is either 1 or 0
    $val = ($val ? 1 : 0);
    ## if it's a NEGFLAG, then invert the value
    $val = 1-$val if ($$self{type} =~ /NEG/);

    ${$self->{value}} = $val;
}

1;

