/*
 * Copyright (c) 1999 The University of Utah and the Flux Group.
 * All rights reserved.
 * 
 * Contributed by the Computer Security Research division,
 * INFOSEC Research and Technology Office, NSA.
 * 
 * This file is part of the Flux OSKit.  The OSKit is free software, also known
 * as "open source;" you can redistribute it and/or modify it under the terms
 * of the GNU General Public License (GPL), version 2, as published by the Free
 * Software Foundation (FSF).  To explore alternate licensing terms, contact
 * the University of Utah at csl-dist@cs.utah.edu or +1-801-585-3271.
 * 
 * The OSKit is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GPL for more details.  You should have
 * received a copy of the GPL along with the OSKit; see the file COPYING.  If
 * not, write to the FSF, 59 Temple Place #330, Boston, MA 02111-1307, USA.
 */

/* FLASK */

#ifndef _AVDEFTAB_H_
#define _AVDEFTAB_H_

#include "symtab.h"
#include "constraint.h"


typedef struct 
{
    access_vector_t read;
    access_vector_t readby;
    access_vector_t write;
    access_vector_t writeby;
} mls_perms_t;


typedef struct
{
    symtab_t *common;	        /* common permissions */
    symtab_t private;    	/* private permissions */
    constraint_node_t *constraints; /* constraints for all access rulings */
    mls_perms_t mlsperms;       /* mls permissions */
} avdef_datum_t;

typedef struct avdef_node_t* avdef_ptr_t;

struct avdef_node_t 
{
  unsigned int key;
  avdef_datum_t datum;
  avdef_ptr_t next;
};

#define AVDEFTAB_SIZE 23

typedef struct 
{
    avdef_ptr_t htable[AVDEFTAB_SIZE];	
    unsigned int nel;		/* number of elements */
    unsigned int ncons;  	/* number of constrained elements */
} avdeftab_t;

int avdeftab_init(avdeftab_t *);

int avdeftab_insert(avdeftab_t *h, unsigned int key, avdef_datum_t *d);
avdef_datum_t *avdeftab_search(avdeftab_t *h, unsigned int key);
void avdeftab_destroy(avdeftab_t *h);
int avdeftab_map(avdeftab_t *h,
		 int (*apply)(unsigned int key,
			     avdef_datum_t *d,
			     void *args),
		void *args);

#endif _AVDEFTAB_H_

/* FLASK */
