/*
 * Copyright (c) 1999 The University of Utah and the Flux Group.
 * All rights reserved.
 * 
 * Contributed by the Computer Security Research division,
 * INFOSEC Research and Technology Office, NSA.
 * 
 * This file is part of the Flux OSKit.  The OSKit is free software, also known
 * as "open source;" you can redistribute it and/or modify it under the terms
 * of the GNU General Public License (GPL), version 2, as published by the Free
 * Software Foundation (FSF).  To explore alternate licensing terms, contact
 * the University of Utah at csl-dist@cs.utah.edu or +1-801-585-3271.
 * 
 * The OSKit is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GPL for more details.  You should have
 * received a copy of the GPL along with the OSKit; see the file COPYING.  If
 * not, write to the FSF, 59 Temple Place #330, Boston, MA 02111-1307, USA.
 */

/* FLASK */

#ifndef _CONSTRAINT_H_
#define _CONSTRAINT_H_

#include "ebitmap.h"

typedef struct constraint_expr 
{
#define CONSTRAINT_EXPR_TYPE_NOT		1
#define CONSTRAINT_EXPR_TYPE_AND		2	
#define CONSTRAINT_EXPR_TYPE_OR			3	
#define CONSTRAINT_EXPR_TYPE_SAMEUSER		4	
#define CONSTRAINT_EXPR_TYPE_TYPE_SOURCE	5	
#define CONSTRAINT_EXPR_TYPE_TYPE_TARGET	6	
#define CONSTRAINT_EXPR_TYPE_ROLE_SOURCE	7
#define CONSTRAINT_EXPR_TYPE_ROLE_TARGET	8
#define CONSTRAINT_EXPR_TYPE_ROLE_RELATION	9	
    unsigned expr_type;				/* expression type */
#define CONSTRAINT_EXPR_VALUE_RELATION_DOM	1 
#define CONSTRAINT_EXPR_VALUE_RELATION_DOMBY	2 
#define CONSTRAINT_EXPR_VALUE_RELATION_EQ	3
#define CONSTRAINT_EXPR_VALUE_RELATION_INCOMP	4
    unsigned relation;				/* set for relation */ 
    ebitmap_t bitmap;				/* set for source, target */
    struct constraint_expr *left;		/* set for not, and, or */
    struct constraint_expr *right; 		/* set for and, or */ 
    unsigned count;
} constraint_expr_t;

typedef struct constraint_node
{
  access_vector_t permissions;			/* constrained permissions */
  constraint_expr_t *expr;			/* constraint on permissions */ 
  struct constraint_node *next;			/* next constraint */
} constraint_node_t;

#endif _CONSTRAINT_H_

/* FLASK */
