/*
 * Copyright (c) 1999 The University of Utah and the Flux Group.
 * All rights reserved.
 * 
 * Contributed by the Computer Security Research division,
 * INFOSEC Research and Technology Office, NSA.
 * 
 * This file is part of the Flux OSKit.  The OSKit is free software, also known
 * as "open source;" you can redistribute it and/or modify it under the terms
 * of the GNU General Public License (GPL), version 2, as published by the Free
 * Software Foundation (FSF).  To explore alternate licensing terms, contact
 * the University of Utah at csl-dist@cs.utah.edu or +1-801-585-3271.
 * 
 * The OSKit is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GPL for more details.  You should have
 * received a copy of the GPL along with the OSKit; see the file COPYING.  If
 * not, write to the FSF, 59 Temple Place #330, Boston, MA 02111-1307, USA.
 */
/* FLASK */

#ifndef _POLICYDB_H_
#define _POLICYDB_H_

#include "hashtab.h"
#include "symtab.h"
#include "avtab.h"
#include "avdeftab.h"
#include "trtab.h"
#include "queue.h"
#include "context.h"
#include "prvavtab.h"


typedef struct
{
    security_id_t sid;	   	/* initial SID value */
    int isvalid;	   	/* context defined for this SID */
    ss_root_context_t context;  /* context for this SID */
} initial_sid_datum_t;


typedef struct
{
    unsigned int value;		/* permission value (bit in access vector) */
#define MLS_BASE_READ    1
#define MLS_BASE_WRITE   2
#define MLS_BASE_READBY  4
#define MLS_BASE_WRITEBY 8
    unsigned int base_perms;	/* MLS base permissions associated with this permission */
} perm_datum_t;


typedef struct
{
    unsigned int value;		/* security class value */
    unsigned int unused;	/* unused */
} class_datum_t;    


typedef struct 
{
    unsigned int value;		/* type value (internal only) */
    unsigned int unused;        /* unused */
} type_info_t;


typedef struct
{
    int isalias;		/* is this an alias for the type? */
    type_info_t *info;		/* information about the type */
} type_datum_t;


typedef struct 
{
    int isalias;		/* is this an alias for the level? */
    mls_level_t *level;		/* sensitivity value, associated categories */
} level_datum_t;


typedef struct 
{
    int isalias;		/* is this an alias for the category? */
    unsigned int value;		/* category value (internal only) */
} cat_datum_t;


typedef struct {
    unsigned int value;		/* role value (internal use only) */
    ebitmap_t	 dominates;	/* dominated roles */
    ebitmap_t    types;		/* set of authorized types */
} role_datum_t;


typedef struct 
{
    unsigned int value;		/* user value (internal use only) */
    ebitmap_t roles;		/* set of static authorized roles */
    queue_t ranges;		/* list of authorized levels (mls_range_t) */
} user_datum_t;


typedef struct
{
    symtab_t *sids;		/* sid name -> initial_sid_datum_t */
    symtab_t *commons;		/* common name -> symtab_t */
    symtab_t *classes;		/* class name -> class_datum_t */
    avdeftab_t *avdefs;		/* avdef_key_t -> avdef_datum_t */
    symtab_t *roles;		/* role name -> role_datum_t */
    symtab_t *types;		/* type name -> type_datum_t */
    trtab_t  *transitions;	/* tr_key_t -> tr_datum_t */
    unsigned nlevels;		/* number of actual levels, as opposed to prim sens */
    symtab_t *levels;		/* level name -> level_datum_t */
    symtab_t *cats;		/* category name -> cat_datum_t */
    symtab_t *users;		/* user name -> user_datum_t */
#define TE_DEFAULT_NONE	0
#define TE_DEFAULT_ALL	1
#define TE_DEFAULT_SELF	2
    int	     defallow;
    int	     defauditallow;
    int      defauditdeny;
    int      defnotify;
    avtab_t  *rules;		/* av_key_t -> av_datum_t */
    prvavtab_t *provided;       /* prvav_key_t -> prvav_datum_t */
    /* inverse lookup tables (value -> name) */
    char **role_val_to_name;	
    char **type_val_to_name;	
    char **sens_val_to_name;
    char **cat_val_to_name;
    char **user_val_to_name;
    /* inverse lookup tables (value -> struct) */
    user_datum_t **user_val_to_struct;
    role_datum_t **role_val_to_struct;
} policydb_t;


extern int constraint_expr_destroy(constraint_expr_t *expr);

extern int policydb_init(policydb_t *p);
extern int policydb_transform(policydb_t *p);
extern void policydb_destroy(policydb_t *p);

extern policydb_t *policydbp;
extern queue_t id_queue;
extern unsigned int policydb_errors;

#define POLICYDB "/ss_policy"

#endif _POLICYDB_H_

/* FLASK */
