/*
 * Copyright (c) 1996, 1998, 1999 University of Utah and the Flux Group.
 * All rights reserved.
 * 
 * This file is part of the Flux OSKit.  The OSKit is free software, also known
 * as "open source;" you can redistribute it and/or modify it under the terms
 * of the GNU General Public License (GPL), version 2, as published by the Free
 * Software Foundation (FSF).  To explore alternate licensing terms, contact
 * the University of Utah at csl-dist@cs.utah.edu or +1-801-585-3271.
 * 
 * The OSKit is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GPL for more details.  You should have
 * received a copy of the GPL along with the OSKit; see the file COPYING.  If
 * not, write to the FSF, 59 Temple Place #330, Boston, MA 02111-1307, USA.
 */

#include <svm/svm_internal.h>

/*
 * The software bits page directory.
 */
unsigned char		**svm_sdir;

extern int	enable_gdb;	/* XXX */

void
svm_machdep_init(void)
{
	extern char	_start[], start_of_data[];
	oskit_addr_t	start_addr;
	oskit_addr_t	svm_sdir_pa;
	
	base_paging_init();

	if (pdir_alloc(&svm_sdir_pa))
		panic("Can't allocate software bits directory");

	/*
	 * Convert it to a kv address since the hardware never sees this.
	 */
	svm_sdir = (unsigned char **) phystokv(svm_sdir_pa);

	/*
	 * REMAP the text segment as read-only, unless GDB is enabled.
	 */
	if (! enable_gdb) {
		start_addr = (unsigned) _start & ~(PAGE_SIZE - 1);
		
#ifdef  DEBUG_SVM
		printf("Mapping 0x%x to 0x%x\n",
		       (int) start_addr, (int)start_of_data);
#endif	
		if (svm_map_range((oskit_addr_t) start_addr,
				  (oskit_addr_t) start_addr,
				  (oskit_addr_t) start_of_data -
				  (oskit_addr_t) start_addr,
				  (PTE_MBITS_VALID|PTE_MBITS_R)))
			panic("Can't direct-map text memory");
	}

	/*
	 * REMAP the bottom page of the stack as read-only. 
	 */
#ifdef  DEBUG_SVM
	printf("Mapping 0x%x to 0x%x\n", (int) base_stack_start,
	       (int) base_stack_start + PAGE_SIZE);
#endif	
	if (svm_map_range((oskit_addr_t) base_stack_start,
		(oskit_addr_t) base_stack_start, PAGE_SIZE,
		PTE_MBITS_VALID|PTE_MBITS_R))
		panic("Can't direct-map stack redzone");

	/*
	 * Allocate a memory map for the virtual range. 
	 */
	amm_init(&svm_amm, 0x40000000, 0x80000000);
}

