#include <oskit/error.h>

#include <errno.h>

extern int native_errno;

static inline oskit_error_t
native_to_oskit_error(int err)
{
#if EINVAL < 1000
	/* A mapping table will do.  */
	extern const oskit_error_t oskit_native_errors[];
	extern const int oskit_native_nerrors;
	if ((unsigned)err < oskit_native_nerrors)
		return oskit_native_errors[err];
#else
	switch (err) {
#define NATIVE_ERROR(native, oskit) case native: return oskit;
#include "native_errnos.h"
	}
#endif
	return OSKIT_E_FAIL;
}
