/*
 * GSDV_JPG.C - PGS JPEG routines
 *
 * Source Version: 2.0
 * Software Release #92-0043
 *
 */

#include "cpyright.h"
#include "pgs.h"
#include "gsrast.h"

int
 PG_jpg_quality = 100;

#ifndef HAVE_JPEGLIB

/*--------------------------------------------------------------------------*/
 
/* PG_SETUP_JPEG_DEVICE - stub for systems that don't have libjpeg.a
 *
 */

void PG_setup_jpeg_device(d)
   PG_device *d;
   {return;}

/*--------------------------------------------------------------------------*/

#else

#include "jpeglib.h"

/* to use the JPEG device issue a call
 *
 *   PG_register_device("JPEG", PG_setup_jpeg_device);
 *
 */

/*--------------------------------------------------------------------------*/

/*                            PAGE STATE ROUTINES                           */

/*--------------------------------------------------------------------------*/

/* _PG_JP_FINISH_PLOT - do what's necessary to finish up a graphical image
 *                    - and get the device updated with the image
 *                    - after this function nothing more can be added to
 *                    - the image
 */
 
static void _PG_JP_finish_plot(dev)
   PG_device *dev;
   {int row_stride;
    long imagesize, i, j;
    unsigned char *input, *r, *g, *b;
    char fname[MAXLINE];
    FILE *fh;
    struct jpeg_compress_struct cinfo;
    struct jpeg_error_mgr jerr;
    JSAMPROW row_pointer[1];
    frame *fr;
    PG_RAST_device *mdv;

    GET_RAST_DEVICE(dev, mdv);

    sprintf(fname, "%s.%03d", mdv->out_fname, mdv->quant++);
    fh = fopen(fname, "wb");
    if (fh == NULL)
       return;

/* This function calls the Independent JPEG Group
 * (IJG) JPEG library to write the input image to
 * a file in JPEG format
 */

/* initialize jpeg library default error handler */
    cinfo.err = jpeg_std_error(&jerr);

/* initialize the jpeg library compression structure */
    jpeg_create_compress(&cinfo);

/* tell the jpeg library the destination (output file) */
    jpeg_stdio_dest(&cinfo, fh);

    cinfo.image_width      = mdv->width;
    cinfo.image_height     = mdv->height;
    cinfo.input_components = 3;       /* # color components */
    cinfo.in_color_space   = JCS_RGB; /* color space */

    jpeg_set_defaults(&cinfo);

/* set image quality if requested */
    if ((PG_jpg_quality > 0) && (PG_jpg_quality <= 100))
       jpeg_set_quality(&cinfo, PG_jpg_quality, TRUE);

/* begin a compression cycle */
    jpeg_start_compress(&cinfo, TRUE);

    row_stride = mdv->width * cinfo.input_components;
    fr         = mdv->inner_frame;

    imagesize = mdv->width * mdv->height * cinfo.input_components;
   
    input = FMAKE_N(unsigned char, imagesize, "PG_CLOSE_JPEG:input");

    GET_RGB(fr, r, g, b);

    for (i = 0, j=0; i < (mdv->width * mdv->height); i++, j+=3)
        {input[j]   = r[i];
         input[j+1] = g[i];
         input[j+2] = b[i];}

    while (cinfo.next_scanline < cinfo.image_height)
       {row_pointer[0] = &input[cinfo.next_scanline * row_stride];
        jpeg_write_scanlines(&cinfo, row_pointer, 1);}

/* finish the compression cycle */
    jpeg_finish_compress(&cinfo);

/* close the output file */
    fclose(fh);

    SC_free(input);

/* release the compression object's subsidiary memory */
    jpeg_destroy_compress(&cinfo);

    return;}
 
/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* _PG_JP_OPEN - initialize a JPEG device */
 
static PG_device *_PG_JP_open(dev, xf, yf, dxf, dyf)
   PG_device *dev;
   double xf, yf, dxf, dyf;
   {PG_RAST_device *mdv;
    int Lightest, Light, Light_Gray, Dark_Gray, Dark, Darkest;
    int display_width, display_height, n_colors;
    char fname[MAXLINE], *name, *s;
    REAL intensity;
    REAL view_x_max, view_y_max;
    PG_font_family *ff;

    PG_setup_markers();

    dev->type_index       = JPEG_DEVICE;
    dev->quadrant         = QUAD_FOUR;
    dev->hard_copy_device = TRUE;
    dev->print_labels     = TRUE;

    _PG_rst_set_dev_prop(dev, (int) dxf, (int) dyf, N_RAST_COLOR);

    strcpy(fname, dev->title);
    name = SC_strtok(fname, " \t\n\r\\?~.,;:<>/'`\"[]{}()=+|!@#$%^&*", s);

    strcat(fname, ".jpeg");

    mdv = PG_make_raster_device((int) dxf, (int) dyf, fname,
				NULL, TRUE, NULL);
    if (mdv == NULL)
       return(NULL);

    dev->file = (FILE *) mdv;

/* get the window shape in NDC */
    if ((xf == 0.0) && (yf == 0.0))
       {xf = 0.0;
        yf = 0.0;};

    if ((dxf == 0.0) && (dyf == 0.0))
       {dxf = 1.0;
        dyf = 1.0;};

    PG_query_screen(dev, &display_width, &display_height, &n_colors);

/* set device pixel coordinate limits */
    dev->min_pc_x = SHRT_MIN + display_width;
    dev->max_pc_x = SHRT_MAX - display_width;
    dev->min_pc_y = SHRT_MIN + display_height;
    dev->max_pc_y = SHRT_MAX - display_height;
 
    dev->window_x      = 0.0;
    dev->window_y      = 0.0;
    dev->window_width  = display_width;
    dev->window_height = display_height;

    dev->window_x_off  = dev->window_x;
    dev->window_y_off  = dev->window_y;

    dev->ncolor = N_RAST_COLOR;
    dev->absolute_n_color = N_RAST_COLOR;
    intensity  = dev->max_intensity*MAXPIX;
    if (dev->background_color_white)
       {Color_Map(dev, 1, 0, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15);
	Lightest   = 0;
	Light      = intensity;
	Light_Gray = 0.8*intensity;
	Dark_Gray  = 0.5*intensity;
	Dark       = 0;
	Darkest    = intensity;}

    else
       {Color_Map(dev, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15);
        Lightest   = intensity;
        Light      = intensity;
	Light_Gray = 0.8*intensity;
	Dark_Gray  = 0.5*intensity;
        Dark       = 0;
        Darkest    = 0;};

/* compute the view port */
    if (dev->view_x == 0.0)
       {dev->view_x = 0.175;
        dev->view_y = 0.175;};

    if (dev->view_width == 0.0)
       dev->view_width = 0.65;

    if (dev->view_height == 0.0)
       dev->view_height = 0.65;

    view_x_max = dev->view_x + dev->view_width;
    view_y_max = dev->view_y + dev->view_height;

/* set the view port */
    PG_set_viewport(dev, dev->view_x, view_x_max, dev->view_y, view_y_max);
    PG_set_window(dev, 0.0, 1.0, 0.0, 1.0);
 
/* initialize fonts */
    ff = PG_make_font_family(dev, "helvetica", NULL, 4,
                             "Helvetica",
                             "Helvetica-Oblique",
                             "Helvetica-Bold",
                             "Helvetica-BoldOblique");

    ff = PG_make_font_family(dev, "times", ff, 4,
                             "Times-Roman",
                             "Times-Italic",
                             "Times-Bold",
                             "Times-BoldItalic");

    ff = PG_make_font_family(dev, "courier", ff, 4,
                             "Courier",
                             "Courier-Oblique",
                             "Courier-Bold",
                             "Courier-BoldOblique");

    dev->font_family = ff;

    PG_set_font(dev, "helvetica", "medium", 12);

/* put in the default palettes */
    PG_setup_standard_palettes(dev, 64,
			       Light, Dark,
			       Light_Gray, Dark_Gray,
			       Lightest, Darkest);

    getln = (PFfgets) io_gets_hook;
    putln = (PFfprintf) io_printf_hook;

    return(dev);}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* _PG_JP_CLOSE_DEVICE - close a device */
 
static void _PG_JP_close_device(dev)
   PG_device *dev;
   {PG_RAST_device *rdv;

    GET_RAST_DEVICE(dev, rdv);

    _PG_free_frame(rdv->inner_frame);
    SFREE(rdv->out_fname);
    SFREE(rdv);

/* clean up the device */
   _PG_rl_device(dev);

   return;}

/*--------------------------------------------------------------------------*/

/*                            PGS INTERFACE ROUTINES                        */

/*--------------------------------------------------------------------------*/
 
/* PG_SETUP_JPEG_DEVICE - do the device dependent device initialization
 *                      - for PG_make_device
 */

void PG_setup_jpeg_device(d)
   PG_device *d;
   {

    PG_setup_raster_device(d);

    d->type_index   = JPEG_DEVICE;
    d->close_device = _PG_JP_close_device;
    d->finish_plot  = _PG_JP_finish_plot;
    d->open_screen  = _PG_JP_open;

    return;}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

#endif
