/*
 * GSLTST.C - test of graphics library
 *
 * Source Version: 2.0
 * Software Release #92-0043
 *
 */

#include "cpyright.h"

#include "pgs.h"

#define N 50

#define DASHED     2
#define DOTTED     3
#define DOTDASHED  4

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* DRAW_SET_1 - draw the first data set */

static void draw_set_1(x, y, SCR_dev, SCR_dew, PS_dev, CGM_dev)
   REAL *x, *y;
   PG_device *SCR_dev, *SCR_dew, *PS_dev, *CGM_dev;
   {int i;
    PG_graph *data;

    for (i = 0; i < N; i++)
        {x[i] = -(i+1)/8.0;
         y[i] = 6.022e23/x[i];};

    data = PG_make_graph_1d('A', "Test Data #1", FALSE, N,
                            x, y, "X Values", "Y Values");

    PG_turn_grid(SCR_dev, OFF);
    PG_turn_grid(SCR_dew, OFF);
    PG_turn_grid(PS_dev, OFF);
    PG_turn_grid(CGM_dev, OFF);

    PG_plot_labels = TRUE;

/* picture #1 */
    _PG_axis_tick_type = RIGHT_OF_AXIS;
    data->info = PG_set_line_info(data->info, CARTESIAN, CARTESIAN,
				  DASHED, FALSE, 0, 4, 0, 0.0);
    PG_draw_graph(SCR_dev, data);
    PG_draw_graph(PS_dev, data);
    PG_draw_graph(CGM_dev, data);
    SC_pause();

/* picture #2 */
    data->info = PG_set_line_info(data->info, POLAR, POLAR,
				  DOTTED, FALSE, 0, 4, 0, 0.0);
    PG_draw_graph(SCR_dew, data);
    PG_draw_graph(PS_dev, data);
    PG_draw_graph(CGM_dev, data);
    SC_pause();

/* picture #3 */
    data->info = PG_set_line_info(data->info, INSEL, INSEL,
				  SOLID, FALSE, 0, 4, 0, 0.0);
    PG_draw_graph(SCR_dev, data);
    PG_draw_graph(PS_dev, data);
    PG_draw_graph(CGM_dev, data);
    SC_pause();

/* picture #4 */
    _PG_axis_tick_type = LEFT_OF_AXIS;
    data->info = PG_set_line_info(data->info, HISTOGRAM, CARTESIAN,
				  SOLID, FALSE, 0, 4, 0, 0.0);
    PG_draw_graph(SCR_dew, data);
    PG_draw_graph(PS_dev, data);
    PG_draw_graph(CGM_dev, data);
    SC_pause();

    return;}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* DRAW_SET_2 - draw the second set */

static void draw_set_2(x, y, SCR_dev, SCR_dew, PS_dev, CGM_dev)
   REAL *x, *y;
   PG_device *SCR_dev, *SCR_dew, *PS_dev, *CGM_dev;
   {int i;
    PG_graph *data;

    for (i = 0; i < N; i++)
        {x[i] = i/8.0;
         y[i] = cos(x[i]);};

    data = PG_make_graph_1d('B', "Test Data #2", FALSE, N,
                            x, y, "X Values", "Y Values");

    PG_turn_grid(SCR_dev, ON);
    PG_turn_grid(SCR_dew, ON);
    PG_turn_grid(PS_dev, ON);
    PG_turn_grid(CGM_dev, ON);

    PG_plot_labels = FALSE;

/* picture #5 */
    _PG_axis_tick_type = RIGHT_OF_AXIS;
    data->info = PG_set_line_info(data->info, HISTOGRAM, CARTESIAN,
				  SOLID, FALSE, 0, 5, 1, 0.0);
    PG_draw_graph(SCR_dev, data);
    PG_draw_graph(PS_dev, data);
    PG_draw_graph(CGM_dev, data);
    SC_pause();

/* picture #6 */
    data->info = PG_set_line_info(data->info, INSEL, INSEL,
				  SOLID, FALSE, 0, 5, 0, 0.0);
    PG_draw_graph(SCR_dew, data);
    PG_draw_graph(PS_dev, data);
    PG_draw_graph(CGM_dev, data);
    SC_pause();

/* picture #7 */
    data->info = PG_set_line_info(data->info, POLAR, POLAR,
				  DOTDASHED, FALSE, 0, 5, 0, 0.0);
    PG_draw_graph(SCR_dev, data);
    PG_draw_graph(PS_dev, data);
    PG_draw_graph(CGM_dev, data);
    SC_pause();

/* picture #8 */
    _PG_axis_tick_type = LEFT_OF_AXIS;
    data->info = PG_set_line_info(data->info, CARTESIAN, CARTESIAN,
				  SOLID, FALSE, 0, 5, 0, 0.0);
    PG_draw_graph(SCR_dew, data);
    PG_draw_graph(PS_dev, data);
    PG_draw_graph(CGM_dev, data);
    SC_pause();

    return;}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

main(argc, argv)
   int argc;
   char **argv;
   {int i, use_color;
    REAL *x, *y;
    char *s;
    PG_graph *data;
    PG_device *SCR_dev, *SCR_dew, *PS_dev, *CGM_dev;

    use_color = FALSE;
    s = SC_strsavef("WINDOW", "char*:GSLTST:s");
    for (i = 1; i < argc; i++)
        if (argv[i][0] == '-')
           {switch (argv[i][1])
               {case 'c' : use_color = TRUE;
                           break;
                case 'h' : i++;
                           s = argv[i];
                           break;};};

    x = FMAKE_N(REAL, N, "GSLTST.C:x");
    y = FMAKE_N(REAL, N, "GSLTST.C:y");

/* set up the left window */
    SCR_dev = PG_make_device(s, "COLOR", "PGS Test A");
    PG_white_background(SCR_dev, TRUE);
    PG_turn_data_id(SCR_dev, ON);
    PG_open_device(SCR_dev, 0.05, 0.2, 0.45, 0.45);

/* set up the right window */
    SCR_dew = PG_make_device(s, "COLOR", "PGS Test B");
    PG_white_background(SCR_dew, FALSE);
    PG_turn_data_id(SCR_dew, ON);
    PG_set_max_intensity(SCR_dew, 0.8);
    PG_open_device(SCR_dew, 0.5, 0.2, 0.45, 0.45);

/* set up the hard copy device */
    if (use_color)
       PS_dev = PG_make_device("PS", "COLOR", "gsltst 2.0 2.0");
    else
       PS_dev = PG_make_device("PS", "MONOCHROME", "gsltst 2.0 2.0");
    PG_turn_data_id(PS_dev, ON);
    PG_open_device(PS_dev, 0.0, 0.0, 0.0, 0.0);

/* set up the hard copy device */
    if (use_color)
       CGM_dev = PG_make_device("CGM", "COLOR", "gsltst");
    else
       CGM_dev = PG_make_device("CGM", "MONOCHROME", "gsltst");
    PG_turn_data_id(CGM_dev, ON);
    PG_set_max_intensity(CGM_dev, 0.8);
    PG_open_device(CGM_dev, 0.0, 0.0, 0.0, 0.0);

    draw_set_1(x, y, SCR_dev, SCR_dew, PS_dev, CGM_dev);
    draw_set_2(x, y, SCR_dev, SCR_dew, PS_dev, CGM_dev);

    PG_close_device(SCR_dev);
    PG_close_device(SCR_dew);
    PG_close_device(PS_dev);
    PG_close_device(CGM_dev);

    return(0);}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/
