/*
 * SXCRV.C - support for curve database in ULTRA
 *
 * Source Version: 3.0
 * Software Release #92-0043
 *
 */

#include "cpyright.h"
 
#include "sx.h"

#define NCURVE  100    /* number of additional curves to allocate at a time */

object
 *SX_crv_obj[NDISPLAY],
 *SX_crv_proc[NDISPLAY],
 *SX_crv_varbl[NDISPLAY];

static int
 _SX_next_space_available = 0;

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* _SX_CURVE_ID - given the curve character return the integer identifier */

int _SX_curve_id(c)
   int c;
   {if (islower(c))
       return(min(toupper(c)-'A', NDISPLAY));

    return(c - 'A');}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* SX_CURVE_ID - given the curve object return the integer identifier */

int SX_curve_id(c)
   object *c;
   {return(_SX_curve_id(*SS_get_string(c)));}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* SX_ENLARGE_DATASET - allocate or reallocate the arrays whose size
 *                    - depends on the number of curves when more curves
 *                    - are requested (in blocks of NCURVE)
 *                    - also adjust any places that reference the number
 *                    - of curves
 */

void SX_enlarge_dataset()
   {int i, nc;

    nc = SX_N_Curves;

    if (nc == 0)
       {SX_dataset = FMAKE_N(curve, NCURVE,
                             "SX_ENLARGE_DATASET:dataset");
        SX_number  = FMAKE_N(int, NCURVE,
                             "SX_ENLARGE_DATASET:number");
        SX_N_Curves += NCURVE;}
    else
       {SX_N_Curves += NCURVE;
        REMAKE_N(SX_dataset, curve, SX_N_Curves);
        REMAKE_N(SX_number, int, SX_N_Curves);};

/* initialize the new curves */
    for (i = nc; i < SX_N_Curves; i++)
        {SX_dataset[i].id       = ' ';
         SX_dataset[i].obj      = (byte *) SS_null;
         SX_dataset[i].n        = 0;
         SX_dataset[i].modified = FALSE;
         SX_dataset[i].info     = PG_set_line_info(NULL,
						   CARTESIAN, CARTESIAN,
						   SOLID, FALSE, 0, 0,
						   0, 0.0);
         SX_number[i]           = -1;};

    return;}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* SX_ASSIGN_NEXT_ID - assign next available curve id  */

void SX_assign_next_id(i, fnc)
   int i;   
   PFVoid fnc;
   {int j;

    for (j = 0; j < NDISPLAY; j++)
        {if (SX_data_index[j] == -1)
	    {if (j >= 0)
	        {SX_dataset[i].id = 'A' + j;
		 SX_data_index[j] = i;};

	     return;};};

    if (fnc != NULL)
       {(*fnc)();
	SS_error("ALL 26 CURVE ID'S IN USE - SX_ASSIGN_NEXT_ID", SS_null);};

    return;}
        
/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* SX_NEXT_SPACE - return the index for the next available curve data slot */

int SX_next_space()
   {int i;

    for (i = _SX_next_space_available; i < SX_N_Curves; i++)
        if (SX_dataset[i].n == 0)
           {_SX_next_space_available = i + 1;
            return(i);};

    SX_enlarge_dataset();

    return(SX_next_space());}
        
/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* SX_GET_CURVE - return the curve index if the object is a curve that is
 *              - currently visible
 *              - otherwise return -1
 */

int SX_get_curve(obj)
   object *obj;
   {if (SX_curvep_a(obj))
       return(SX_data_index[_SX_curve_id(*SS_get_string(obj))]);
    else
       return(-1);}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* SX_ZERO_CURVE - clear out the entry in the data set */

void SX_zero_curve(i)
   int i;
   {curve *crv;

    crv = SX_dataset + i;

    crv->id       = ' ';
    crv->obj      = (byte *) SS_null;
    crv->n        = 0;
    crv->modified = FALSE;

    crv->info = PG_set_line_info(crv->info,
			         CARTESIAN, 0, 0, 0,
			         0, 0, 0, 0.0);

    if (i < _SX_next_space_available)
       _SX_next_space_available = i;

    SFREE(crv->text);
    SFREE(crv->file);

    return;}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* SX_MK_CURVE_PROC - return a Scheme procedure object made from the
 *                  - specified curve
 *                  - also bind the variable whose name is the lower
 *                  - case version of the curve label (curve.id) to
 *                  - the new object
 */

object *SX_mk_curve_proc(i)
   int i;
   {char s[2];
    int j;
    object *obj;

    s[0] = SX_dataset[i].id;
    s[1] = '\0';
    
    j = _SX_curve_id(s[0]);

    obj = SX_crv_obj[j];

    SS_PROCEDURE_DOC(SX_crv_proc[j]) = SX_dataset[i].text;
    SS_VARIABLE_VALUE(obj)    = SX_crv_proc[j];
    SS_VARIABLE_NAME(obj)     = SS_PROCEDURE_NAME(SX_crv_proc[j]);

    SX_dataset[i].obj = (byte *) obj;

    return(obj);}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* _SX_MK_CURVE - the C level function that creates a new curve object */

object *_SX_mk_curve(na, xa, ya, label, filename, fnc)
   int na;
   REAL *xa, *ya;
   char *label, *filename;
   PFVoid fnc;
   {int i, j, k;
    REAL xmin, xmax, ymin, ymax, tmp;
    REAL *xpj, *xpi, *ypj, *ypi;
    REAL *xp, *yp;

    i = SX_next_space();
    SX_zero_curve(i);
    SX_assign_next_id(i, fnc);

    SX_dataset[i].text     = SC_strsavef(label,
					 "char*:_SX_MK_CURVE:label");
    SX_dataset[i].modified = FALSE;

    if (filename != NULL)
       SX_dataset[i].file = SC_strsavef(filename,
					"char*:_SX_MK_CURVE:fname");
    else
       SX_dataset[i].file = NULL;

    xmin =  HUGE;
    xmax = -HUGE;
    ymin =  HUGE;
    ymax = -HUGE;
    xp = xa;
    yp = ya;
    for (j = 0; j < na; j++, xp++, yp++)
        {tmp  = *xp;
         xmin = (tmp < xmin) ? tmp : xmin;
         xmax = (tmp > xmax) ? tmp : xmax;
         tmp  = *yp;
         ymin = (tmp < ymin) ? tmp : ymin;
         ymax = (tmp > ymax) ? tmp : ymax;};

    SX_dataset[i].xmin = xmin;
    SX_dataset[i].xmax = xmax;
    SX_dataset[i].ymin = ymin;
    SX_dataset[i].ymax = ymax;
    SX_dataset[i].n    = na;
    xpj = xa;
    ypj = ya;
    xpi = SX_dataset[i].xp = FMAKE_N(REAL, na, "_SX_MK_CURVE:xpi");
    ypi = SX_dataset[i].yp = FMAKE_N(REAL, na, "_SX_MK_CURVE:ypi");
    if (xpi == NULL || ypi == NULL)
       SS_error("OUT OF MEMORY - CREATE_CURVE", SS_null);

/* copy data */
    for (k = 0; k < na; k++)
        {*xpi++ = *xpj++;
         *ypi++ = *ypj++;};

    PG_set_line_info(SX_dataset[i].info, CARTESIAN, CARTESIAN, SOLID,
		     FALSE, 0, _SX_next_color(SX_graphics_device), 0, 0.0);

    return(SX_mk_curve_proc(i));}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* SX_RL_CURVE - release a curve object */

object *SX_rl_curve(j)
   int j;
   {int i;
    object *obj;

    i = SX_data_index[j];

/* release the curve data points */
    SFREE(SX_dataset[i].xp);
    SFREE(SX_dataset[i].yp);

/* make the curve object a simple variable for the benefit of objects
 * still pointing to it
 */
    obj = SX_crv_obj[j];

    SS_VARIABLE_VALUE(obj) = SX_crv_varbl[j];
    SS_VARIABLE_NAME(obj)  = SS_VARIABLE_NAME(SX_crv_varbl[j]);

/* re-initialize the curve and mark */
    SX_zero_curve(i);
    SX_data_index[j] = -1;

    return(obj);}

/*--------------------------------------------------------------------------*/

/*                          CURVE TEST ROUTINES                             */

/*--------------------------------------------------------------------------*/

/* _SX_CURVEP - tests whether object is legitimate curve */

int _SX_curvep(s)
   char *s;
   {int i, j;
        
    j = _SX_curve_id(*s);
    if ((j >= 0) && (j < NDISPLAY) && isprint(*s))
       {i = SX_data_index[j];
        if ((-1 < i) && (i < SX_N_Curves))
           if (SX_dataset[i].n > 0)
              return(TRUE);};

    return(FALSE);}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* SX_CURVEP_A - tests whether Scheme object is legitimate curve
 *             - regardless of whether or not the object is a procedure
 *             - return TRUE if it is an Ultra curve and
 *             - return FALSE otherwise
 */

int SX_curvep_a(obj)
   object *obj;
   {char *s;
        
    if (SS_nullobjp(obj) || SS_consp(obj))
       return(FALSE);

    s = SS_get_string(obj);
    if (strlen(s) == 1)
       return(_SX_curvep(s));
    else
       return(FALSE);}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* SX_CURVEP_B - return TRUE iff the given object is a procedure whose
 *              - name is an active curve
 */

int SX_curvep_b(obj)
   object *obj;
   {if (SS_procedurep(obj))
       {if (_SX_curvep(SS_PROCEDURE_NAME(obj)))
           return(TRUE);};

    return(FALSE);}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* SX_CURVEOBJP - Scheme predicate testing for Ultra curves */

object *SX_curveobjp(obj)
   object *obj;
   {return(SX_curvep_a(obj) ? SS_t : SS_f);}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/
