/*
 * SXHBO.C - handler for SS_binary operations between mappings
 *
 * Source Version: 3.0
 * Software Release #92-0043
 *
 */

#include "cpyright.h"
 
#include "sx.h"

/*--------------------------------------------------------------------------*/

#if 0

/*--------------------------------------------------------------------------*/

/* _SX_LINK_GRAPHS - link the graphs from the arglist
 *                 - return a pointer to the first link in the list
 */

static PG_graph *_SX_link_graphs(argl)
   object *argl;
   {PG_graph *h, *ph, *pn;
    object *obj;

    h = NULL;
    while (SS_consp(argl))
       {SX_GET_OBJECT_FROM_LIST(SX_GRAPHP(obj), pn,
                                SS_GET(PG_graph, obj),
                                argl, "BAD GRAPH - _SX_LINK_GRAPHS");

        if (h == NULL)
           h = ph = pn;
        else
           {ph->next = pn;
            ph       = pn;};};

    return(h);}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* _SX_UNLINK_GRAPHS - unlink the graphs */

static void _SX_unlink_graphs(h)
   PG_graph *h;
   {PG_graph *ph, *pn;

    for (ph = h; ph != NULL; ph = pn)
        {pn = ph->next;
         ph->next = NULL;};

    return;}

/*--------------------------------------------------------------------------*/

#endif

/*--------------------------------------------------------------------------*/

/* _SX_LINK_MAPPINGS - link the mappings from the arglist
 *                   - return a pointer to the first link in the list
 */

static PM_mapping *_SX_link_mappings(argl)
   object *argl;
   {PM_mapping *h, *ph, *pn;

    h = NULL;
    while (SS_consp(argl))
       {SX_determine_mapping(&pn, &argl);

        if (h == NULL)
           h = ph = pn;
        else
           {ph->next = pn;
            ph       = pn;};};

    if (h != NULL)
       pn->next = NULL;

    return(h);}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* _SX_UNLINK_MAPPINGS - unlink the mappings */

static void _SX_unlink_mappings(h)
   PM_mapping *h;
   {PM_mapping *ph, *pn;

    for (ph = h; ph != NULL; ph = pn)
        {pn = ph->next;
         ph->next = NULL;};

    return;}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* SX_BUILD_COMMON_DOMAIN - given a list of mappings
 *                        - build a reasonable domain set
 *                        - which preserves the resolution
 *                        - as much as possible
 *                        - check that domains are commensurate
 *                        - check that ranges are commensurate
 */

PM_set *SX_build_common_domain(h)
   PM_mapping *h;
   {int i, nde, nd, sk, dk;
    int *dmx, *smx;
    char bf[MAXLINE], *type, *s;
    REAL sx, sn, dx, dn;
    REAL *sdextr, *dextr;
    PM_set *sd, *domain;
    PM_mapping *ph;

    sd  = h->domain;
    nd  = sd->dimension;
    nde = sd->dimension_elem;

/* get the number of bytes per component of a range element */
    dmx   = FMAKE_N(int, nd, "SX_BUILD_COMMON_DOMAIN:dmx");
    dextr = FMAKE_N(REAL, 2*nde, "SX_BUILD_COMMON_DOMAIN:dextr");
    for (i = 0; i < nde; i++)
        {dextr[2*i]   = HUGE;
         dextr[2*i+1] = -HUGE;};

/* get the max indexes and the extremal values of each component */
    for (ph = h; ph != NULL; ph = ph->next)
        {smx = ph->domain->max_index;
         for (i = 0; i < nd; i++)
             {sk = *smx++;
              dk = dmx[i];
              dmx[i] = max(dk, sk);};

         sdextr = (REAL *) ph->domain->extrema;
         for (i = 0; i < nde; i++)
             {sn = *sdextr++;
              sx = *sdextr++;
              dn = dextr[2*i];
              dx = dextr[2*i+1];
              dextr[2*i]   = min(dn, sn);
              dextr[2*i+1] = max(dx, sx);};

/* detect things like (+ a a) */
         if (ph == ph->next)
            break;};

    strcpy(bf, sd->element_type);
    type = SC_strtok(bf, " *", s);
    domain = PM_make_lr_domain("Domain", type,
			       sd->dimension, sd->dimension_elem,
			       dmx, dextr);

    SFREE(dextr);

    return(domain);}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* _SX_INTERPOLATE_MAPPING - interpolate the range of the source mapping
 *                         - onto an intermediate array centered on the
 *                         - destination mapping
 *                         - return the intermediate array which is
 *                         - allocated in this routine
 */

static REAL *_SX_interpolate_mapping(dest, source)
   PM_mapping *dest, *source;
   {int i, j, id, is, n;
    int sne, dne, snde, snre, dnde;
    REAL **sde, **sre, **dde, *tre, *wgts;
    REAL *src, *trc, *wgt, *ssc, *dsc;
    REAL dx, val, wg, wgc, iwc;
    REAL d, w, rho, a, x;
    PM_set *sr, *sd, *dr, *dd;

    sd = source->domain;
    dd = dest->domain;
    sr = source->range;
    dr = dest->range;

    snde = sd->dimension_elem;
    sne  = sd->n_elements;
    sde  = (REAL **) sd->elements;
    ssc  = (REAL *) sd->scales;

    sre  = (REAL **) sr->elements;
    snre = sr->n_elements;

    dne = dd->n_elements;
    dde = (REAL **) dd->elements;
    dsc = (REAL *) dd->scales;

    dnde = dr->dimension_elem;

/* allocate the working spaces */
    tre  = FMAKE_N(REAL, dnde*dne,
                   "_SX_INTERPOLATE_MAPPING:tre");
    wgts = FMAKE_N(REAL, dnde*dne,
                   "_SX_INTERPOLATE_MAPPING:wgts");

/* set the scale of the cutoff */
    if (snde == 1)
       a = 20.0;
    else
       a = 4.0;

/* construct measure of the relative mesh scales */
    rho = 0.0;
    for (j = 0; j < snde; j++)
        {d = ABS(ssc[j]/dsc[j]);
         rho = max(rho, d);};

/*
    rho = 0.0;
    for (j = 0; j < snde; j++)
        {d = ssc[j]/dsc[j];
         rho += d*d;};
    rho = sqrt(rho);
*/

/* weight every source point in the destination mesh
 *
 * pros
 * 1) gives great continuity and differentiability
 * 2) saves having to interpolate over holes in the destination mesh
 *
 * cons
 * 1) N^2 problem
 */
/* GOTCHA: this assumes the range is indexed the same as the domain
 *         which is only true if there are phony zones on a cell centered
 *         range
 */
    trc = tre;
    wgt = wgts;
    for (i = 0; i < dnde; i++)
        {src = sre[i];
         for (id = 0; id < dne; id++)
             {val = 0.0;
              wg  = 0.0;
              for (is = 0; is < sne; is++)
                  {d = 0.0;
                   for (j = 0; j < snde; j++)
                       {dx = (dde[j][id] - sde[j][is])/(dsc[j] + SMALL);
                        d += dx*dx;};

                   d = sqrt(d);

/* GOTCHA: this clause is not right it is merely safe - see above GOTCHA */
		   if (is >= snre)
		      {val = 0.0;
		       wg  = 1;
		       break;}

		   else if (d < SMALL) 
		      {val = src[is];
		       wg  = 1;
		       break;}

		   else
		      {x = a*(d - rho);
		       if (x > 5.0)
			  continue;
		       w    = 1.0/((d + SMALL)*(1.0 + exp(x)));
		       val += src[is]*w;
		       wg  += w;};};
              *trc++ += val;
              *wgt++ += wg;};};

    trc = tre;
    wgt = wgts;
    n   = dnde*dne;
    for (i = 0; i < n; i++)
        {wgc = wgt[i];
	 iwc = (wgc == 0.0) ? 0.0 : 1.0/wgc;
	 trc[i] *= iwc;};

    SFREE(wgts);

    return(tre);}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* _SX_ACCUMULATE_RANGE - accumulate a range set into the accumulator set
 *                      - using the specified function
 *                      - WARNING: as its written it precludes
 *                      -          operations such as multiplying a
 *                      -          vector by a scalar (Hmmmm!)
 *                      - NOTE: this is dependent on element type!!!
 */

static void _SX_accumulate_range(dest, source, f)
   PM_mapping *dest, *source;
   PFDouble f;
   {int i, id, dnde, dne;
    REAL *trc, *tre, *drc, **dre;

    tre  = _SX_interpolate_mapping(dest, source);
    dnde = dest->range->dimension_elem;
    dne  = dest->domain->n_elements;
    dre  = (REAL **) dest->range->elements;

/* perform the binary operation */
    trc = tre;
    for (i = 0; i < dnde; i++)
        {drc = dre[i];
         for (id = 0; id < dne; id++)
             drc[id] = (REAL) (*f)(drc[id], *trc++);};

/* clean up the mess */
    SFREE(tre);

    return;}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* SX_BUILD_ACCUMULATOR_MAPPING - given a domain set
 *                              - initialize a range set to act as an
 *                              - accumulator and bind it with the domain
 *                              - to form a mapping which will be returned
 *                              - this checks that the ranges are
 *                              - commensurate
 *                              - WARNING: as its written it precludes
 *                              -          operations such as multiplying a
 *                              -          vector by a scalar (Hmmmm!)
 *                              - NOTE: this is independent of element
 *                              -       type!!!
 */

PM_mapping *SX_build_accumulator_mapping(domain, h)
   PM_set *domain;
   PM_mapping *h;
   {PM_set *range, *set;
    PM_mapping *f, *ph;
    int i, id, nd, nde, nbe, tnd, tnde, ne;
    char *type, *ttype;
    int *maxes, *dm;
    byte **elem;
    REAL *tre, *trc, *drc;
    char label[MAXLINE];

/* check that the ranges are commensurate */
    range = h->range;
    nd    = range->dimension;
    nde   = range->dimension_elem;
    ne    = range->n_elements;
    type  = range->element_type;
    for (ph = h->next; ph != NULL; ph = ph->next)
        {range = ph->range;
         tnd   = range->dimension;
         tnde  = range->dimension_elem;
         ttype = range->element_type;
         if ((tnd != nd) || (tnde != nde) || (strcmp(ttype, type) != 0))
            SS_error("INCOMMENSURATE RANGE SET - SX_BUILD_ACCUMULATOR_MAPPING",
                     SS_null);

/* detect things like (+ a a) */
         if (ph == ph->next)
            break;};

/* get the number of bytes per component of a range element */
    strcpy(label, range->es_type);
    PD_dereference(label);
    nbe = SIZEOF(label);

/* get the useful information from the domain */
    nd = domain->dimension;
    ne = domain->n_elements;
    dm = domain->max_index;

    maxes = FMAKE_N(int, nd, "SX_BUILD_ACCUMULATOR_MAPPING:maxes");
    for (i = 0; i < nd; i++)
        maxes[i] = dm[i];

    nbe *= ne;
    elem = FMAKE_N(byte *, nde, "SX_BUILD_ACCUMULATOR_MAPPING:elem");
    for (i = 0; i < nde; i++)
        elem[i] = FMAKE_N(char, nbe,
                          "SX_BUILD_ACCUMULATOR_MAPPING:elem[]");

    set = _PM_make_set(range->name, type, FALSE,
                       ne, nd, range->dimension_elem,
                       maxes, elem, range->opers, NULL,
                       NULL, NULL, NULL, NULL, NULL, NULL, NULL);

    sprintf(label, "f:%s->%s", domain->name, set->name);
    f = PM_make_mapping(label, PM_LR_S, domain, set, N_CENT, NULL);

    tre = _SX_interpolate_mapping(f, h);
    trc = tre;
    for (i = 0; i < nde; i++)
        {drc = (REAL *) elem[i];
         for (id = 0; id < ne; id++)
             drc[id] = *trc++;};

    PM_find_extrema(set);

    SFREE(tre);

    return(f);}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* _SX_MH_B_S - SX Math Handler for Binary Scalar operators
 *            - first cut will be to apply operator to scalar elements
 *            - of the range set of the given list of mappings
 */

object *_SX_mh_b_s(fn, argl)
   PFPObject fn;
   object *argl;
   {int plf;
    char label[MAXLINE];
    PFDouble fnc;
    PM_set *domain;
    PM_mapping *f, *h, *ph;
    object *first, *mo;

    first = SS_car(argl);
    if (SS_floatp(first))
       return(SS_binary_flt(fn, argl));

    fnc = (PFDouble) fn;
    plf = SX_have_display_list();
    h   = _SX_link_mappings(argl);

/* build the return mapping */
    domain = SX_build_common_domain(h);
    f      = SX_build_accumulator_mapping(domain, h);

    sprintf(label, "%s->(%s %s", domain->name,
            SS_get_string(SS_Fun), h->range->name);

/* compute the range values for the return mapping */
    for (ph = h->next; ph != NULL; ph = ph->next)
        {_SX_accumulate_range(f, ph, fnc);
         strcat(label, " ");
         strcat(label, ph->range->name);

/* detect things like (+ a a) */
         if (ph == ph->next)
            break;};

    strcat(label, ")");

    SFREE(f->name);
    f->name = SC_strsavef(label, "char*:_SX_MH_B_S:label");
    PM_find_extrema(f->range);

    _SX_unlink_mappings(h);

    SX_plot_flag = TRUE;

    mo = SX_mk_mapping(f);
    if (plf)
       mo = SX_display_map(mo);

    return(mo);}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* SX_BUILD_RESTRICTED_DOMAIN - build a domain whose extent is the
 *                            - intersection of the list of values
 *                            - in ARGL and the extrema of HD
 */

PM_set *SX_build_restricted_domain(hd, argl)
   PM_set *hd;
   object *argl;
   {int i, nd, ne, nde;
    int *maxes, *dmx;
    char name[MAXLINE];
    REAL mn, mx, dn, dx, rd, rf;
    REAL *extr;
    PM_set *fd;

    nd  = hd->dimension;
    nde = hd->dimension_elem;
    dmx = hd->max_index;
    ne  = _SS_length(argl);
    if (ne != 2*nd)
       SS_error("DOMAIN DIMENSION MISMATCH - SX_BUILD_RESTRICTED_DOMAIN",
		argl);

    extr  = FMAKE_N(REAL, ne, "SX_BUILD_RESTRICTED_DOMAIN:extr");
    maxes = FMAKE_N(int, nd, "SX_BUILD_RESTRICTED_DOMAIN:maxes");

    PM_array_real(hd->element_type, hd->extrema, ne, extr);

    for (i = 0; i < nd; i++)
        {SS_args(argl,
		 SC_DOUBLE_I, &mn,
		 SC_DOUBLE_I, &mx,
		 0);

	 dn = extr[2*i];
	 dx = extr[2*i+1];

	 rd  = dmx[i];
	 rf  = (mx - mn)/(dx - dn);
	 rd *= ABS(rf);

	 maxes[i] = (int) rd;

	 dn = max(dn, mn);
	 dx = min(dx, mx);

	 extr[2*i]   = dn;
	 extr[2*i+1] = dx;};

    sprintf(name, "Sub %s", hd->name);

    fd = PM_make_lr_domain(name, SC_REAL_S, nd, nde, maxes, extr);

    SFREE(extr);

    return(fd);}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* SX_EXTRACT_MAPPING - extract a mapping from the given mapping 
 *                    - from xstart to xstop by xstep
 */

PM_mapping *SX_extract_mapping(h, argl)
   PM_mapping *h;
   object *argl;
   {int plf;
    char label[MAXLINE];
    PM_set *fd, *hd;
    PM_mapping *f;
    object *mo;

    plf = SX_have_display_list();

    hd = h->domain;

/* build the return mapping */
    fd = SX_build_restricted_domain(hd, argl);
    f  = SX_build_accumulator_mapping(fd, h);

    sprintf(label, "Extract %s", h->name);

    SFREE(f->name);
    f->name = SC_strsavef(label, "char*:SX_EXTRACT_MAPPING:label");

    PM_find_extrema(f->range);

    SX_plot_flag = TRUE;

    mo = SX_mk_mapping(f);
    if (plf)
       mo = SX_display_map(mo);

    return(f);}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/
