/*
 * SXSHAR.C - routines for all of C coded spoke handlers
 *
 * Source Version: 3.0
 * Software Release #92-0043
 *
 */

#include "cpyright.h"
 
#include "sxtrans.h"

int
 N_file_types = 0;

TR_FILE
 TR_file_funcs[N_FILE_TYPES];

char
 *SYMENT = "syment";

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/
 
/* TR_INSTALL_FUNCS - install the generic TRANSL functions */
 
void TR_install_funcs()
   {SS_install("open-bin-file",
               "Open a binary file",
	       SS_nargs,
	       TR_open_bin, SS_PR_PROC);

    SS_install("close-bin-file",
               "Close a binary file",
	       SS_nargs,
	       TR_close_bin, SS_PR_PROC);

    SS_install("file-type",
               "Return the type of the given file as a string",
	       SS_sargs,
	       TR_file_type, SS_PR_PROC);

    SS_install("have-spoke?",
               "Return the #t iff the argument names a present spoke",
	       SS_sargs,
	       TR_spokep, SS_PR_PROC);

    TR_file_funcs[N_file_types].open      = (PFPByte) PD_open;
    TR_file_funcs[N_file_types].close     = (PFPByte) PD_close;
    TR_file_funcs[N_file_types].type      = SX_PDBFILE_S;
    TR_file_funcs[N_file_types].type_hook = SX_pdbfilep;
    N_file_types++;

    return;}
 
/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* TR_CONV_IN - convert some data to internal format */

void TR_conv_in(file, out, in, type, nitems)
   PDBfile *file;
   byte *out, *in;
   char *type;
   long nitems;
   {long ino, outo;
    SC_THREAD_ID(_t_index);

    switch (setjmp(_PD_TRACE_ERR(_t_index)))
       {case ABORT    : return;
        case ERR_FREE : return;
        default       : memset(PD_err, 0, MAXLINE);
                        break;};

    ino = outo = 0L;
    PD_convert((char **) &out, (char **) &in, type, type, nitems,
               file->std, file->host_std, file->host_std,
               &ino, &outo,
               file->chart, file->host_chart, 0, PD_TRACE);

    return;}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* TR_OPEN_BIN - open up the named binary file */

object *TR_open_bin(arg)
   object *arg;
   {int i;
    char *name, *mode, *type, *path, *scope;
    PFPByte fun;
    byte *file;
    object *obj;
    g_file *po;

    name  = NULL;
    mode  = NULL;
    scope = NULL;
    SS_args(arg,
            SC_STRING_I, &name,
            SC_STRING_I, &mode,
            SC_STRING_I, &scope,
            0);

    if (name == NULL)
       SS_error("BAD FILE NAME - TR_OPEN_BIN", arg);

    if ((scope == NULL) || (strcmp(scope, "local") == 0))
       path = SC_search_file(NULL, name);
    else
       path = SC_search_file(SC_path, name);
    if (path == NULL)
       SS_error("CAN'T FIND FILE - TR_OPEN_BIN", arg);

    if (mode == NULL)
       mode = "r";

/* search for an existing file by this name */
    for (po = SX_file_list; po != NULL; po = po->next)
        {if (strcmp(path, po->name) == 0)
             return(po->file_object);};

    obj = SS_null;
    for (i = 0; i < N_file_types; i++)
        {fun  = TR_file_funcs[i].open;
         type = TR_file_funcs[i].type;

/* open the file */
         file = (*fun)(path, mode);
	 if ((file == NULL) && (strcmp(mode, "r") != 0))
	    file = (*fun)(path, "r");
         if (file != NULL)
            {obj = SX_mk_gfile(_SX_mk_file(path, SX_PDBFILE_S, type, file));
             SS_UNCOLLECT(obj);

/* get the miserable, pesky type REAL in once and for all!! */
	     if (strcmp(type, SX_PDBFILE_S) == 0)
	        {PD_typedef_primitive_types((PDBfile *) file);
	         if (sizeof(REAL) == sizeof(double))
		    PD_typedef((PDBfile *) file, "double", "REAL");
		 else
		    PD_typedef((PDBfile *) file, "float", "REAL");};

             po              = SS_GET(g_file, obj);
             po->file_object = obj;
             po->type_hook   = TR_file_funcs[i].type_hook;

/* add to file_list */
             SX_file_list = po;
             break;};};

    if (obj == SS_null)
       SS_error("FILE OF UNKNOWN TYPE OR ACCESS DENIED - TR_OPEN_BIN", arg);

    return(obj);}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* TR_CLOSE_BIN - close the named binary file */

object *TR_close_bin(arg)
   object *arg;
   {int i;
    PFPByte fun;
    g_file *po;

    po = NULL;
    SS_args(arg,
            G_FILE, &po,
            0);
    
    if (po != NULL)
       for (i = 0; i < N_file_types; i++)
           if (strcmp(TR_file_funcs[i].type, po->external_type) == 0)
              {fun  = TR_file_funcs[i].close;
               return(SX_close_file(arg, (PFInt) fun));};

    return(SS_f);}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* TR_FILE_TYPE - return a string object containing the file type name */

object *TR_file_type(arg)
   object *arg;
   {g_file *po;

    po = NULL;
    SS_args(arg,
            G_FILE, &po,
            0);

    return((po == NULL) ? SS_null : SS_mk_string(po->external_type));}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* TR_SPOKEP - return #t iff the named spoke is present */

object *TR_spokep(arg)
   object *arg;
   {int i;
    char *type;

    type = NULL;
    SS_args(arg,
            SC_STRING_I, &type,
            0);

    for (i = 0; i < N_file_types; i++)
        if (strcmp(type, TR_file_funcs[i].type) == 0)
           return(SS_t);

    return(SS_f);}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/
