/*
 * ULTRA.H - the main header supporting the Ultra system
 *
 * Source Version: 4.0
 * Software Release #92-0043
 *
 */

#ifndef PCK_ULTRA

#include "cpyright.h"
 
#define PCK_ULTRA

/* Think C compiler defines THINK_C; CodeWarrior defines __MWERKS__ */
#ifdef THINK_C
# include "sx.h"
#else
# ifdef __MWERKS__
#  include "sx.h"
# else
#  include <sx.h>
# endif
#endif

#undef CODE
#define CODE "ULTRA 2.4"

#define UL_INTEGER   SC_INTEGER_I
#define UL_REAL      SC_DOUBLE_I
#define UL_LONG      SC_LONG_I
#define UL_CHAR      SC_CHAR_I
#define UL_STRING    SC_STRING_I
#define UL_P_STRING  SC_POINTER_I
#define UL_UNKNOWN   ERR_OBJ

#define UL_CURVE_INDEX_I 500
#define UL_DATA_ID_I     501   

#define HIST_LEFT    -10
#define HIST_RIGHT   -11
#define HIST_CENTER  -12

#ifdef __cplusplus
extern "C" {
#endif

/*--------------------------------------------------------------------------*/

/*                           VARIABLE DECLARATIONS                          */

/*--------------------------------------------------------------------------*/

extern int
 UL_simple_append;

extern REAL
 UL_derivative_tolerance;

extern REAL
 *UL_buf1x,
 *UL_buf1y,
 *UL_buf2x,
 *UL_buf2y;

extern object
 *UL_ann_lst;

/*--------------------------------------------------------------------------*/

/*                          PROCEDURE DECLARATIONS                          */

/*--------------------------------------------------------------------------*/


/* ULAUXF.C declarations */

extern object
 *SC_DECLARE(UL_fft, (int j)),
 *SC_DECLARE(UL_ifft, (object *argl)),
 *SC_DECLARE(UL_cfft, (object *argl)),
 *SC_DECLARE(UL_get_value, 
	     (REAL *sp, REAL *vp, double val, int n, int id)),
 *SC_DECLARE(UL_curve_eval, (object *arg)),
 *SC_DECLARE(UL_getx, (object *obj, object *tok)),
 *SC_DECLARE(UL_gety, (object *obj, object *tok)),
 *SC_DECLARE(UL_fit, (object *obj, object *tok)),
 *SC_DECLARE(UL_fit_curve, (object *argl)),
 *SC_DECLARE(UL_dupx, (int j)),
 *SC_DECLARE(UL_stat, (int j)),
 *SC_DECLARE(UL_stats, (object *argl)),
 *SC_DECLARE(UL_disp, (int j, double d1, double d2));

extern void
 SC_DECLARE(UL_install_aux_funcs, (byte));

extern PM_matrix
 SC_DECLARE(*UL_lsq, (PM_matrix *a, PM_matrix *ay));


/* ULCNTL.C declarations */

extern void
 SC_DECLARE(UL_init_hash, (byte)),
 SC_DECLARE(UL_install_global_vars, (byte)),
 SC_DECLARE(UL_plot_limits, (PG_device *dev, int pflg,
	    REAL *pxmn, REAL *pxmx, REAL *pymn, REAL *pymx)),
 SC_DECLARE(UL_pause, (int pf));

extern object
 *SC_DECLARE(UL_describe, (object *s)),
 *SC_DECLARE(UL_apropos, (object *obj));


/* ULFUNC.C declarations */

extern void
 SC_DECLARE(_UL_quit, (int i)),
 SC_DECLARE(UL_install_scheme_funcs, (byte)),
 SC_DECLARE(UL_install_funcs, (byte));

extern object
 *SC_DECLARE(UL_delete, (object *s)),
 *SC_DECLARE(UL_sort, (int k)),
 *SC_DECLARE(_UL_make_ln,
	     (double slope, double interc, 
	      double first, double last, int n));


/* ULHAND.C declarations */

extern void
 SC_DECLARE(UL_lmt, 
            (REAL *pt, int n, REAL *mymin, REAL *mymax)),
 SC_DECLARE(UL_check_order, (REAL *p, int n, int i));

extern int
 SC_DECLARE(UL_curve_strp, (object *obj));

extern object
 *SC_DECLARE(UL_bltov, (PFInt basicf, object *argl)),
 *SC_DECLARE(UL_us, (PFInt basicf, object *argl)),
 *SC_DECLARE(UL_uc, (PFInt basicf, object *argl)),
 *SC_DECLARE(UL_opxc, (PFInt basicf, object *argl)),
 *SC_DECLARE(UL_opyc, (PFInt basicf, object *argl)),
 *SC_DECLARE(UL_ul2toc, (PFInt basicf, object *argl)),
 *SC_DECLARE(UL_ul2tocnp, (PFInt basicf, object *argl)),
 *SC_DECLARE(_UL_ul2toc, 
	     (PFInt basicf, object *argl, int flag)),
 *SC_DECLARE(UL_ulntoc, (PFInt basicf, object *argl)),
 *SC_DECLARE(UL_uopxc, (PFInt basicf, object *argl)),
 *SC_DECLARE(UL_uopyc, (PFInt basicf, object *argl)),
 *SC_DECLARE(UL_bftoc, (PFInt basicf, object *argl)),
 *SC_DECLARE(UL_bltoc, (PFInt basicf, object *argl)),
 *SC_DECLARE(UL_bltocnp, (PFInt basicf, object *argl)),
 *SC_DECLARE(UL_bc, (PFInt basicf, object *argl)),
 *SC_DECLARE(UL_bcxl, (PFInt basicf, object *argl));


/* ULTRA.C declarations */

#ifdef DEBUG

extern int
 heapch;

#endif

extern object
 *SC_DECLARE(UL_mode_text, (byte)),
 *SC_DECLARE(UL_mode_graphics, (byte)),
 *SC_DECLARE(UL_plot, (byte)),
 *SC_DECLARE(UL_printscr, (byte)),
 *SC_DECLARE(UL_set_id, (object *argl)),
 *SC_DECLARE(UL_thru, (object *s)),
 *SC_DECLARE(UL_copy_curve, (int j)),
 *SC_DECLARE(UL_extract_curve, (object *argl)),
 *SC_DECLARE(UL_xindex_curve, (int j));

extern void
 SC_DECLARE(UL_init_view, (byte)),
 SC_DECLARE(UL_set_graphics_state, (PG_device *d)),
 SC_DECLARE(UL_init_curves, (byte)),
 SC_DECLARE(UL_print_banner, (byte));


#ifdef __cplusplus
}
#endif

#endif

