(* Copyright (C) 1992, Digital Equipment Corporation                         *)
(* All rights reserved.                                                      *)
(* See the file COPYRIGHT for a full description.                            *)
(*                                                                           *)
(* Created on Sep 15 1988 by Jorge Stolfi                      *)
(* Last modified on Tue Jun 16 18:29:58 PDT 1992 by muller     *)
(*      modified on Fri Feb 16  0:35:06 PST 1990 by stolfi     *)
(*      modified on Fri Jan 20 11:14:55 PST 1989 by glassman   *)

INTERFACE R4x4;

(* Real 4 x 4 matrices.

   This interface implements operations on 4 x 4 real matrices,
   and uses them to represent linear transformations of R4.
  
   Index: reals, matrices of
   points; geometry; linear algebra; numerical routines; 
   vectors; reals, vectors of
   
*)

(********************************************************************)
(*                                                                  *)
(* WARNING: DO NOT EDIT THIS FILE.  IT WAS GENERATED MECHANICALLY.  *)
(* See the  Makefile for more details.                              *)
(*                                                                  *)
(********************************************************************)

IMPORT R4;

TYPE
  INT = INTEGER;
  NAT = CARDINAL;
  BOOL = BOOLEAN;

  Axis = R4.Axis;
  Matrix = ARRAY Axis OF R4.T;
  T = Matrix; 
  
  ArrT = ARRAY OF T;
  RefT = REF T;
  RefArrT = REF ArrT;
  
PROCEDURE FromRows(READONLY p0, p1, p2, p3: R4.T): Matrix; 
  (* Matrix with given rows, which maps the ith canonical vector 
  to the ith given point. *)

PROCEDURE Zero(): Matrix;
  (* Null linear map, with zero matrix. *)

PROCEDURE Identity(): Matrix; 
  (* Identity linear map *)

PROCEDURE Equal(READONLY A, B: Matrix): BOOL; 
  (* True if A=B *)

PROCEDURE Scale (alpha: REAL; READONLY A: Matrix): Matrix;
  (* Scalar multiplication alpha * A. *)

PROCEDURE Add (READONLY A, B: Matrix): Matrix;
  (* Matrix addition A + B. *)

PROCEDURE Sub (READONLY A, B: Matrix): Matrix;
  (* Matrix difference A - B. *)

PROCEDURE Minus (READONLY A: Matrix): Matrix;
  (* Negation - A. *)

PROCEDURE Mul(READONLY A, B: Matrix): Matrix; 
  (* Matrix product A*B *)

PROCEDURE Map(READONLY p: R4.T; READONLY A: Matrix): R4.T;
  (* Computes p (as a row vector) times A *)

PROCEDURE Row(READONLY A: Matrix; i: Axis): R4.T;
  (* Extracts row i of A as a vector. *)

PROCEDURE Col(READONLY A: Matrix; j: Axis): R4.T;
  (* Extracts column j of A as a vector. *)

PROCEDURE Diagonal(READONLY A: Matrix): R4.T;
  (* Extracts the diagonal of A as a vector. *)

PROCEDURE Transpose(READONLY A: Matrix): Matrix; 
  (* Transpose of matrix A *)
   
PROCEDURE TrMap(READONLY A: Matrix; READONLY p: R4.T): R4.T;
  (* Computes A times p (viewed as a column vector) *)
  
PROCEDURE Inv(READONLY A: Matrix): Matrix;
  (* Inverse of matrix or map. *)

PROCEDURE Det(READONLY A: Matrix): REAL; 
  (* Determinant *)

END R4x4.

