
(define-class <email-archive> (<object>)
  (file-name type: <string>))

(define-class <email-message> (<document>) :abstract
  (subject-line #|type: (union <string> #f)|# init-value: #f)
  (time-sent #|type: (union <time> #f)|# init-value: #f))

(define-class <extern-email-message> (<email-message>)
  (archive type: <email-archive>)
  (record-number type: <fixnum>))

(define-class <inline-email-message> (<email-message>)
  (content type: <string>))

;;;

(define *open-stores* (make-string-table))

(define-method get-lss ((self <email-archive>))
  (or (table-lookup *open-stores* (file-name self))
      (let ((l (lss-open (file-name self) #f #t)))
	(table-insert! *open-stores* (file-name self) l)
	l)))

(define-method content ((self <extern-email-message>))
  (lss-read (get-lss (archive self)) (record-number self)))

(define-method initialize ((self <email-message>))
  (next-method)
  (bind ((s t (get-subject-and-time-from-email (content self))))
    (set-subject-line! self s)
    (set-time-sent! self t)
    self))

;;;

(define-method get-keywords ((self <email-message>))
  (get-keywords-from-email (content self)))

;;;

(define-method display-object ((self <email-message>) port)
  (if (time-sent self)
      (format port "[~a] " (time->string (time-sent self) "%m-%d")))
  (if (subject-line self)
      (write-string port (subject-line self))))
