
;;
;;  <work-item> objects are associated with users
;;  and change requests, and record the queue of work 
;;  for the user
;;
;;  they are also the atomic units of work, and are
;;  immutable in owner
;;
;;  when a change request's list of active work items
;;  becomes empty, it goes into its next state
;;  

(define-class <work-item> (<object>) :abstract
    (owner type: <user>)
    (base-request type: <change-request>)
    (activate-audit-entry init-value: #f)
    (close-audit-entry init-value: #f))

;; the method allows us to use `cr' in a --format clause

(define-method cr ((self <work-item>))
  (base-request self))

;;
;;  a code review is posted to a group lead when a
;;  change is made to code owned by the group, if the
;;  group requests code review for filesystem
;;

(define-class <code-review> (<work-item>)
  (group type: <group>))

;;
;;  a work request is posted to a user when a change
;;  request is pending new examination, e.g., when the
;;  previous set of work items have been resolved and
;;  a new phase is required
;;
;;  the target is the <change-request>
;;

(define-class <work-request> (<work-item>)
  ;; `state' is the state which the system is requesting work
  ;; to move out of.  e.g., the initial <work-request> has a 
  ;; state of `open'
  state)

(define-class <fs-change> (<work-item>)
    (file-system type: <file-system>)
    (new-versions type: <list> init-value: '()))

(define-method write-object ((self <fs-change>) port)
    (format port "#[<fs-change> ~d, ~a, ~a]" 
    		(id (base-request self))
		(name (owner self))
		(name (file-system self))))

;;
;;  a <comment-request> can be used to solicit a comment,
;;  or simply to attach a comment (in which case it is closed
;;  at the same time it is opened)

(define-class <comment-request> (<work-item>)
  (comment init-value: #f))

(define-class <title-change> (<work-item>)
  (old-title init-value: #f)
  (new-title init-value: #f))

(define-class <summary-change> (<work-item>)
  (old-summary init-value: #f)
  (new-summary init-value: #f))

(define-class <property-change> (<work-item>)
  (the-property init-value: #f)
  (old-value init-value: #f)
  (new-value init-value: #f))

(define-class <property-add> (<work-item>)
  (the-property init-value: #f)
  (new-value init-value: #f))

(define-class <integration-request> (<work-item>)
  (file-system type: <file-system>)
  (snapshots type: <list> init-value: '()))
