(define (thread-list envt)
  (for-each
   (lambda ((k <fixnum>))
     (let* ((t (table-lookup *thread-table* k))
	    (t (and t (thread t))))
       (if t
	   (let (((n <string>) (internal-thread-name t)))
	     (format #t " ~-5d [~a]~a ~6a ~10a"
		     (thread-number t)
		     n
		     (vector-ref '#("          "
				    "         "
				    "        "
				    "       "
				    "      "
				    "     "
				    "    "
				    "   "
				    "  "
				    " "
				    "")
				 (min 10 (string-length n)))
		   (gvec-ref $thread-state-names (thread-state t))
		   (thread-time t))
	     (if (eq? (thread-state t) $thread-state-blocked)
		 (format #t " ~a\n" 
			 (class-name (object-class (thread-blocked-on t))))
		 (newline))))))
   (sort (key-sequence *thread-table*) <)))

(define-command-proc tl thread-list ((",tl" "show thread list")))
