      SUBROUTINE PBCHER2( ICONTXT, UPLO, XYDIST, N, NB, NZ, ALPHA, X,
     $                    INCX, Y, INCY, A, LDA, IXPOS, IYPOS, IAROW,
     $                    IACOL, XYCOMM, XWORK, YWORK, AWORK, MULLEN,
     $                    WORK )
*
*  -- PB-BLAS routine (version 2.1) --
*     University of Tennessee, Knoxville, Oak Ridge National Laboratory.
*     April 28, 1996
*
*     Jaeyoung Choi, Oak Ridge National Laboratory
*     Jack Dongarra, University of Tennessee and Oak Ridge National Lab.
*     David Walker,  Oak Ridge National Laboratory
*
*     .. Scalar Arguments ..
      CHARACTER*1        AWORK, UPLO, XWORK, XYCOMM, XYDIST, YWORK
      INTEGER            IACOL, IAROW, ICONTXT, INCX, INCY, IXPOS,
     $                   IYPOS, LDA, MULLEN, N, NB, NZ
      COMPLEX            ALPHA
*     ..
*     .. Array Arguments ..
      COMPLEX            A( LDA, * ), X( * ), Y( * ), WORK( * )
*     ..
*
*  Purpose
*  =======
*
*  PBCHER2 is a parallel blocked version of CHER2.
*  PBCHER2  performs the Hermitian rank 2 operation
*
*     A := alpha*x*y' + alpha'*y*x' + A,
*
*  where alpha is a scalar, x and y are N-element vectors distributed on
*  columns or rows of the process template, and A is an N-by-N
*  Hermitian matrix.
*
*  The first elements of the vectors x and y and the matrix A can be
*  located  in the the middle of the first blocks.
*  X and Y can be broadcast if necessary  and then transposed.
*  The communication scheme can be selected.
*
*  Parameters
*  ==========
*
*  ICONTXT (input) INTEGER
*          ICONTXT is the BLACS mechanism for partitioning communication
*          space.  A defining property of a context is that a message in
*          a context cannot be sent or received in another context.  The
*          BLACS context includes the definition of a grid, and each
*          process' coordinates in it.
*
*  UPLO    (input) CHARACTER*1
*          UPLO specifies whether the upper or lower triangular part of
*          the array A is to be referenced as follows:
*
*             UPLO = 'U',  Only the  upper triangular part of A
*                          is to be referenced.
*             UPLO = 'L',  Only the  lower triangular part of A
*                          is to be referenced.
*
*  XYDIST  (input) CHARACTER*1
*          XYDIST specifies the distribution of the vectors X and Y
*          as follows:
*
*             XYDIST = 'C',  X and Y are distributed columnwise
*                            or in a column of processes
*             XYDIST = 'R',  X and Y are distributed rowwise
*                            or in a row of processes
*
*  N       (input) INTEGER
*          N specifies the order of the matrix C.  N >= 0.
*
*  NB      (input) INTEGER
*          NB specifies the row and column block size of the matrix A.
*          It also specifies the block size of the vectors X and Y.
*          NB >= 1.
*
*  NZ      (input) INTEGER
*          NZ is the row and column offset to specify the row and column
*          distance from the beginning of the block to the first element
*          of A.  And it also specifies the offset to the first elements
*          of the vectors X and Y.  0 <= NZ < NB.
*
*  ALPHA   (input) COMPLEX
*          ALPHA specifies the scalar alpha.
*
*  X       (input) COMPLEX array of DIMENSION at least
*          ( 1  + ( Np - 1 ) * abs( INCX ) ) if XYDIST = 'C', or
*          ( 1  + ( Nq - 1 ) * abs( INCX ) ) if XYDIST = 'R'.
*          The incremented array X must contain the vector X.
*
*  INCX    (input) INTEGER
*          INCX specifies the increment for the elements of X.
*          INCX <> 0.
*
*  Y       (input) COMPLEX array of DIMENSION at least
*          ( 1  + ( Np - 1 ) * abs( INCY ) ) if XYDIST = 'C', or
*          ( 1  + ( Nq - 1 ) * abs( INCY ) ) if XYDIST = 'R'.
*          The incremented array Y must contain the vector Y.
*
*  INCY    (input) INTEGER
*          INCY specifies the increment for the elements of Y.
*          INCY <> 0.
*
*  A       (input/output) COMPLEX array of local DIMENSION ( LDA, Nq ).
*          On entry with UPLO = 'U', the leading N-by-N upper triangular
*          part of the (global) array A must contain the upper triangu-
*          lar part of the Hermitian matrix and the strictly lower
*          triangular part  of A is not referenced. On exit, the upper
*          triangular part of the array  A is overwritten by the upper
*          triangular part of the updated  matrix.
*          On entry with UPLO = 'L', the leading N-by-N lower triangular
*          part of the (global) array A  must  contain the lower
*          triangular  part  of the  Hermitian matrix and the strictly
*          upper triangular part of A is not referenced.  On exit,
*          the lower triangular part of the array A is overwritten by
*          the lower triangular part of the updated matrix.
*
*  LDA     (input) INTEGER
*          LDA specifies the leading dimension of the (local) array A.
*          LDA >= MAX(1,Np).
*
*  IXPOS   (input) INTEGER
*          If XYDIST = 'C', IXPOS specifies a column of process
*          template, which holds the vector X.  And if XYDIST = 'R',
*          IXPOS specifies a row of the template, which holds the
*          vector X. If all columns or rows of processes have their
*          own copies of X, then set IXPOS = -1.
*
*  IYPOS   (input) INTEGER
*          If XYDIST = 'C', IYPOS specifies a column of process
*          template, which holds the vector Y.  And if XYDIST = 'R',
*          IYPOS specifies a row of the template, which holds the
*          vector Y. If all columns or rows of processes have their
*          own copies of Y, then set IYPOS = -1.
*
*  IAROW   (input) INTEGER
*          It specifies a row of process template which has the
*          first block of A.  It also represents a row of the template
*          which holds the first blcok of the vectors X and Y if
*          XYDIST = 'C'.
*
*  IACOL   (input) INTEGER
*          It specifies a column of process template which has the
*          first block of A.  It also represents the column of the
*          template which holds the first blcok of the vectors X and Y
*          if XYDIST = 'R'.
*
*  XYCOMM  (input) CHARACTER*1
*          XYCOMM specifies the communication scheme of the vectors X
*          and Y if communication is necessary.  It follows topology
*          definition of BLACS.
*
*  XWORK   (input) CHARACTER*1
*          XWORK determines whether X is a workspace or not.
*
*             XWORK = 'Y':  X is workspace in other processes.
*                           X is sent to X position in other processes.
*                           It is assumed that processes have
*                           sufficient space to store (local) X.
*             XWORK = 'N':  Data in X will be untouched (unchanged).
*
*  YWORK   (input) CHARACTER*1
*          YWORK determines whether Y is a workspace or not.
*
*             YWORK = 'Y':  Y is workspace in other processes.
*                           Y is sent to Y position in other processes.
*                           It is assumed that processes have
*                           sufficient space to store (local) Y.
*             YWORK = 'N':  Data in Y will be untouched (unchanged).
*
*  AWORK   (input) CHARACTER*1
*          AWORK determines whether the other triangular part of A is
*          accessed and modified or not.
*
*            AWORK = 'N': if UPLO = 'U', only upper triangular portion
*                         portion of the matrix A is accessed and the
*                         lower triangular portion is untouched.
*                         Likewise if UPLO = 'L', only lower triangular
*                         portion of the matrix A is accessed and the
*                         upper triangular portion is untouched.
*            AWORK = 'Y': if UPLO = 'U', only lower triangular portion
*                         of the matrix A may be accessed and modified
*                         for fast computation.  And if UPLO = 'L', the
*                         upper triangular portion of the matrix A may
*                         be accessed and modified for fast computation.
*
*  MULLEN  (input) INTEGER
*          MULLEN specifies multiplication length of the optimum column
*          number of the matrix A for multiplying X with Y'.  The value
*          depends on machine characteristics.
*
*  WORK    (workspace) COMPLEX array of DIMENSION SIZE(WORK).
*          It will store copy of X and/or X'.
*
*  Parameters Details
*  ==================
*
*  Lx      It is  a local portion  of L  owned  by  a process,  (L is
*          replaced by M, or N,  and x  is replaced  by  either  p
*          (=NPROW) or q (=NPCOL)).  The value is determined by  L, LB,
*          x, and MI,  where  LB is  a block size  and MI is a  row  or
*          column position in a process template.  Lx is equal to  or
*          less than  Lx0 = CEIL( L, LB*x ) * LB.
*
*  Memory Requirement of WORK
*  ==========================
*
*  NN     = N + NZ
*  Npb    = CEIL( NN, NB*NPROW )
*  Nqb    = CEIL( NN, NB*NPCOL )
*  Np0    = NUMROC( NN, NB, 0, 0, NPROW ) ~= Npb * NB
*  Nq0    = NUMROC( NN, NB, 0, 0, NPCOL ) ~= Nqb * NB
*  LCMQ   = LCM / NPCOL
*  LCMP   = LCM / NPROW
*  ISZCMP = CEIL(MULLEN, LCMQ*NB)
*  SZCMP  = ISZCMP * ISZCMP * LCMQ*NB * LCMP*NB
*
*  (1) XYDIST = 'Col'
*  Size(WORK) = Nq0
*             + Np0              ( if IXPOS <> -1 and XWORK <> 'Y' )
*             + Np0              ( if IYPOS <> -1 and YWORK <> 'Y' )
*             + MAX[ SZCMP                       ( if AWORK <> 'Y' ),
*                    CEIL(Nqb,LCMQ)*NB*MIN(LCMQ,CEIL(NN,NB) ]
*  (b) XYDIST = 'Row'
*  Size(WORK) = Np0
*             + Nq0              ( if IXPOS <> -1 and XWORK <> 'Y' )
*             + Nq0              ( if IYPOS <> -1 and YWORK <> 'Y' )
*             + MAX[ SZCMP                       ( if AWORK <> 'Y' ),
*                    CEIL(Npb,LCMP)*NB*MIN(LCMP,CEIL(NN,NB) ]
*
*  Notes
*  -----
*  More precise space can be computed as
*
*  CEIL(Nqb,LCMQ)*NB => NUMROC( NUMROC(NN,NB,0,0,NPCOL), NB, 0, 0, LCMQ)
*                    = NUMROC( Nq0, NB, 0, 0, LCMQ )
*  CEIL(Npb,LCMP)*NB => NUMROC( NUMROC(NN,NB,0,0,NPROW), NB, 0, 0, LCMP)
*                    = NUMROC( Np0, NB, 0, 0, LCMP )
*
*  =====================================================================
*
*     .. Parameters ..
      COMPLEX            ONE, ZERO
      PARAMETER          ( ONE  = ( 1.0E+0, 0.0E+0 ),
     $                   ZERO = ( 0.0E+0, 0.0E+0 ) )
*     ..
*     .. Local Scalars ..
      CHARACTER*1        COMMXY, FORM
      LOGICAL            ASPACE, COLUMN, UPPER, XDATA, YDATA
      INTEGER            INFO, IPBZ, IPT, IPW, IPY, IQBZ, ISZCMP, IZ,
     $                   JJ, JNPBZ, JPBZ, JQBZ, JZ, KI, KIZ, KJ, KJZ,
     $                   KZ, LCM, LCMP, LCMQ, LMW, LNW, LPBZ, LQBZ,
     $                   MRCOL, MRROW, MYCOL, MYROW, MZCOL, MZROW, NN,
     $                   NP, NPCOL, NPROW, NQ
      COMPLEX            DUMMY, TALPHA
*     ..
*     .. External Functions ..
      LOGICAL            LSAME
      INTEGER            ICEIL, ILCM, NUMROC
      EXTERNAL           ICEIL, ILCM, LSAME, NUMROC
*     ..
*     .. External Subroutines ..
      EXTERNAL           BLACS_GRIDINFO, CGEBR2D, CGEBS2D, CGERC,
     $                   PBCTRAD1, PBCTRNV, PBCVECADD, PXERBLA
*     ..
*     .. Intrinsic Functions ..
      INTRINSIC          CONJG, MAX, MIN
*     ..
*     .. Executable Statements ..
*
*     Quick return if possible.
*
      IF( N.EQ.0 .OR. ALPHA.EQ.ZERO ) RETURN
*
      CALL BLACS_GRIDINFO( ICONTXT, NPROW, NPCOL, MYROW, MYCOL )
*
      UPPER  = LSAME( UPLO,   'U' )
      COLUMN = LSAME( XYDIST, 'C' )
*
*     Test the input parameters.
*
      INFO = 0
      IF(      ( .NOT.UPPER                 ).AND.
     $         ( .NOT.LSAME( UPLO,    'L' ) )     ) THEN
        INFO = 2
      ELSE IF( ( .NOT.COLUMN                ).AND.
     $         ( .NOT.LSAME( XYDIST,  'R' ) )     ) THEN
        INFO = 3
      ELSE IF( N  .LT.0                           ) THEN
        INFO = 4
      ELSE IF( NB .LT.1                           ) THEN
        INFO = 5
      ELSE IF( NZ .LT.0 .OR. NZ.GE.NB             ) THEN
        INFO = 6
      ELSE IF( INCX.EQ.0                          ) THEN
        INFO = 9
      ELSE IF( INCY.EQ.0                          ) THEN
        INFO = 11
      ELSE IF( IAROW.LT.0 .OR. IAROW.GE.NPROW     ) THEN
        INFO = 16
      ELSE IF( IACOL.LT.0 .OR. IACOL.GE.NPCOL     ) THEN
        INFO = 17
      END IF
*
   10 CONTINUE
      IF( INFO.NE.0 ) THEN
        CALL PXERBLA( ICONTXT, 'PBCHER ', INFO )
        RETURN
      END IF
*
*     Start the operations.
*
      IZ = 0
      JZ = 0
      NN = N + NZ
      NP = NUMROC( NN, NB, MYROW, IAROW, NPROW )
      IF( MYROW.EQ.IAROW ) THEN
        NP = NP - NZ
        IZ = NZ
      END IF
*
      NQ = NUMROC( NN, NB, MYCOL, IACOL, NPCOL )
      IF( MYCOL.EQ.IACOL ) THEN
        NQ = NQ - NZ
        JZ = NZ
      END IF
      KZ = 0
*
      ASPACE = LSAME( AWORK, 'Y' )
      XDATA = .FALSE.
      IF( IXPOS.EQ.-1 ) XDATA = .TRUE.
      YDATA = .FALSE.
      IF( IYPOS.EQ.-1 ) YDATA = .TRUE.
      COMMXY = XYCOMM
      IF( LSAME( COMMXY, ' ' ) ) COMMXY = '1'
*
*     LCM : the least common multiple of NPROW and NPCOL
*
      LCM  = ILCM( NPROW, NPCOL )
      LCMP = LCM  / NPROW
      LCMQ = LCM  / NPCOL
      LPBZ = LCMP * NB
      LQBZ = LCMQ * NB
*
      MRROW = MOD( NPROW+MYROW-IAROW, NPROW )
      MRCOL = MOD( NPCOL+MYCOL-IACOL, NPCOL )
*
      TALPHA = CONJG( ALPHA )
      IF( LDA.LT.MAX(1,NP) ) INFO = 13
*
*     PART 1: Distribute a column (or row) vector X and its transpose
*     ===============================================================
*
      IF( COLUMN ) THEN
*
*       Form  A := alpha*X*Y' + alpha*Y'*X + A.
*   _____________                                        _____________
*  |\_           |   ||                 ||              |\_           |
*  |  \_         |   ||                 ||              |  \_         |
*  |    \_       |   || ____________    || ____________ |    \_       |
*  |      A_     |=a*|X*-----Y'-----+a'*|Y*-----X'-----+|      A_     |
*  |        \_   |   ||                 ||              |        \_   |
*  |          \_ |   ||                 ||              |          \_ |
*  |____________\|   ||                 ||              |____________\|
*
        IF(      IXPOS.LT.-1 .OR. IXPOS.GE.NPCOL ) THEN
          INFO = 14
        ELSE IF( IYPOS.LT.-1 .OR. IYPOS.GE.NPCOL ) THEN
          INFO = 15
        END IF
        IF( INFO.NE.0 ) GO TO 10
*
*       Broadcast X and Y if necessary
*
        IPT = 1
        IPY = 1
        IF( .NOT.XDATA ) THEN
          IF( LSAME( XWORK, 'Y' ) ) THEN
            IF( MYCOL.EQ.IXPOS ) THEN
              CALL CGEBS2D( ICONTXT, 'Row', COMMXY, 1, NP, X, INCX )
            ELSE
              CALL CGEBR2D( ICONTXT, 'Row', COMMXY, 1, NP, X, INCX,
     $                      MYROW, IXPOS )
            END IF
            XDATA = .TRUE.
          ELSE
            IF( MYCOL.EQ.IXPOS ) THEN
              CALL PBCVECADD( ICONTXT, 'V', NP, ONE, X, INCX, ZERO,
     $                        WORK, 1 )
              CALL CGEBS2D( ICONTXT, 'Row', COMMXY, 1, NP, WORK, 1 )
            ELSE
              CALL CGEBR2D( ICONTXT, 'Row', COMMXY, 1, NP, WORK, 1,
     $                      MYROW, IXPOS )
            END IF
            IPT = NP + 1
            IPY = IPT
          END IF
        END IF
*
        IF( .NOT.YDATA ) THEN
          IF( LSAME( YWORK, 'Y' ) ) THEN
            IF( MYCOL.EQ.IYPOS ) THEN
              CALL CGEBS2D( ICONTXT, 'Row', COMMXY, 1, NP, Y, INCY )
            ELSE
              CALL CGEBR2D( ICONTXT, 'Row', COMMXY, 1, NP, Y, INCY,
     $                      MYROW, IYPOS )
            END IF
            YDATA = .TRUE.
          ELSE
            IF( MYCOL.EQ.IYPOS ) THEN
              CALL PBCVECADD( ICONTXT, 'V', NP, ONE, Y, INCY, ZERO,
     $                        WORK(IPY), 1 )
              CALL CGEBS2D( ICONTXT, 'Row', COMMXY, 1, NP,
     $                      WORK(IPY), 1 )
            ELSE
              CALL CGEBR2D( ICONTXT, 'Row', COMMXY, 1, NP,
     $                      WORK(IPY), 1, MYROW, IYPOS )
            END IF
            IPT = NP + IPY
          END IF
        END IF
*
*       Transpose the vector Y to WORK(IPT), where Y is distributed
*
        IPW = NQ + IPT
        IF( YDATA ) THEN
          CALL PBCTRNV( ICONTXT, 'Col', 'T', N, NB, NZ, Y, INCY, ZERO,
     $                  WORK(IPT), 1, IAROW, -1, -1, IACOL, WORK(IPW) )
        ELSE
          CALL PBCTRNV( ICONTXT, 'Col', 'T', N, NB, NZ, WORK(IPY), 1,
     $                  ZERO, WORK(IPT), 1, IAROW, -1, -1, IACOL,
     $                  WORK(IPW) )
        END IF
*
      ELSE
*
*       Form  A := alpha*x'*x + A.
*   _____________                                         _____________
*  |\_           |    ||                ||               |\_           |
*  |  \_         |    ||                ||               |  \_         |
*  |    \_       |    || ____________   || ____________  |    \_       |
*  |      A_     |=a'*|Y*-----X'-----+a*|X*-----Y'----- +|      A_     |
*  |        \_   |    ||                ||               |        \_   |
*  |          \_ |    ||                ||               |          \_ |
*  |____________\|    ||                ||               |____________\|
*
        IF(      IXPOS.LT.-1 .OR. IXPOS.GE.NPROW ) THEN
          INFO = 14
        ELSE IF( IYPOS.LT.-1 .OR. IYPOS.GE.NPROW ) THEN
          INFO = 15
        END IF
        IF( INFO.NE.0 ) GO TO 10
*
*       Broadcast X and Y if necessary
*
        IPT = 1
        IPY = 1
        IF( .NOT.XDATA ) THEN
          IF( LSAME( XWORK, 'Y' ) ) THEN
            IF( MYROW.EQ.IXPOS ) THEN
              CALL CGEBS2D( ICONTXT, 'Col', COMMXY, 1, NQ, X, INCX )
            ELSE
              CALL CGEBR2D( ICONTXT, 'Col', COMMXY, 1, NQ, X, INCX,
     $                      IXPOS, MYCOL )
            END IF
            XDATA = .TRUE.
          ELSE
            IF( MYROW.EQ.IXPOS ) THEN
              CALL PBCVECADD( ICONTXT, 'G', NQ, ONE, X, INCX, ZERO,
     $                        WORK, 1 )
              CALL CGEBS2D( ICONTXT, 'Col', COMMXY, 1, NQ, WORK, 1 )
            ELSE
              CALL CGEBR2D( ICONTXT, 'Col', COMMXY, 1, NQ, WORK, 1,
     $                      IXPOS, MYCOL )
            END IF
            IPT = NQ + 1
            IPY = IPT
          END IF
        END IF
*
        IF( .NOT.YDATA ) THEN
          IF( LSAME( YWORK, 'Y' ) ) THEN
            IF( MYROW.EQ.IYPOS ) THEN
              CALL CGEBS2D( ICONTXT, 'Col', COMMXY, 1, NQ, Y, INCY )
            ELSE
              CALL CGEBR2D( ICONTXT, 'Col', COMMXY, 1, NQ, Y, INCY,
     $                      IYPOS, MYCOL )
            END IF
            YDATA = .TRUE.
          ELSE
            IF( MYROW.EQ.IYPOS ) THEN
              CALL PBCVECADD( ICONTXT, 'G', NQ, ONE, Y, INCY, ZERO,
     $                        WORK(IPY), 1 )
              CALL CGEBS2D( ICONTXT, 'Col', COMMXY, 1, NQ,
     $                      WORK(IPY), 1 )
            ELSE
              CALL CGEBR2D( ICONTXT, 'Col', COMMXY, 1, NQ,
     $                      WORK(IPY), 1, IYPOS, MYCOL )
            END IF
            IPT = NQ + IPY
          END IF
        END IF
*
*       Transpose the vector X to WORK(IPT), where X is distributed
*
        IPW = NP + IPT
        IF( YDATA ) THEN
          CALL PBCTRNV( ICONTXT, 'Row', 'T', N, NB, NZ, Y, INCY, ZERO,
     $                  WORK(IPT), 1, -1, IACOL, IAROW, -1, WORK(IPW) )
        ELSE
          CALL PBCTRNV( ICONTXT, 'Row', 'T', N, NB, NZ, WORK(IPY), 1,
     $                  ZERO, WORK(IPT), 1, -1, IACOL, IAROW, -1,
     $                  WORK(IPW) )
        END IF
      END IF
*
*     PART 2: Update A with X and Y'
*     ==============================
*
      IF( NP.EQ.0 .OR. NQ.EQ.0 ) GO TO 80
*
*     If A is a Hermitian upper triangular matrix,
*
      IF( UPPER ) THEN
        ISZCMP = ICEIL( MULLEN, LQBZ )
        IF( ISZCMP.LE.0 ) ISZCMP = 1
        IPBZ = ISZCMP * LPBZ
        IQBZ = ISZCMP * LQBZ
        JPBZ = 0
        JQBZ = 0
*
        DO 40 JJ = 1, ICEIL(NQ+JZ, IQBZ)
          LMW = MIN( IPBZ-IZ, NP-JPBZ )
          LNW = MIN( IQBZ-JZ, NQ-JQBZ )
          JNPBZ = JPBZ + LMW
*
*         Modify (change) data in the lower triangular part
*
          IF( ASPACE ) THEN
*
*           if XYDIST = 'Column'
*
            IF( COLUMN ) THEN
              IF( XDATA ) THEN
                CALL CGERC( JNPBZ, LNW, ALPHA, X, INCX, WORK(JQBZ+IPT),
     $                      1, A(1,JQBZ+1), LDA )
              ELSE
                CALL CGERC( JNPBZ, LNW, ALPHA, WORK, 1, WORK(JQBZ+IPT),
     $                      1, A(1,JQBZ+1), LDA )
              END IF
*
*           if XYDIST = 'Row'
*
            ELSE
              IF( XDATA ) THEN
                 CALL CGERC( JNPBZ, LNW, TALPHA, WORK(IPT), 1,
     $                       X(JQBZ*INCX+1), INCX, A(1,JQBZ+1), LDA )
              ELSE
                 CALL CGERC( JNPBZ, LNW, TALPHA, WORK(IPT), 1,
     $                       WORK(JQBZ+1), 1, A(1,JQBZ+1), LDA )
              END IF
            END IF
*
*         Update data in the upper triangular matrix
*         and save data in the lower triangular matrix
*
          ELSE
*
*           if XYDIST = 'Column'
*
            IF( COLUMN ) THEN
              IF( XDATA ) THEN
                CALL CGERC( JPBZ, LNW, ALPHA, X, INCX,
     $                      WORK(JQBZ+IPT), 1, A(1,JQBZ+1), LDA )
                CALL PBCVECADD( ICONTXT, 'G', LMW*LNW, ZERO, DUMMY, 1,
     $                          ZERO, WORK(IPW), 1 )
                CALL CGERC( LMW, LNW, ALPHA, X(JPBZ*INCX+1), INCX,
     $                      WORK(JQBZ+IPT), 1, WORK(IPW), MAX(1,LMW) )
              ELSE
                CALL CGERC( JPBZ, LNW, ALPHA, WORK, 1, WORK(JQBZ+IPT),
     $                      1, A(1,JQBZ+1), LDA )
                CALL PBCVECADD( ICONTXT, 'G', LMW*LNW, ZERO, DUMMY, 1,
     $                          ZERO, WORK(IPW), 1 )
                CALL CGERC( LMW, LNW, ALPHA, WORK(JPBZ+1), 1,
     $                      WORK(JQBZ+IPT), 1, WORK(IPW), MAX(1,LMW) )
              END IF
*
*           if XYDIST = 'Row'
*
            ELSE
              IF( XDATA ) THEN
                CALL CGERC( JPBZ, LNW, TALPHA, WORK(IPT), 1,
     $                      X(JQBZ*INCX+1), INCX, A(1,JQBZ+1), LDA )
                CALL PBCVECADD( ICONTXT, 'G', LMW*LNW, ZERO, DUMMY, 1,
     $                          ZERO, WORK(IPW), 1 )
                CALL CGERC( LMW, LNW, TALPHA, WORK(JPBZ+IPT), 1,
     $                      X(JQBZ*INCX+1), INCX, WORK(IPW), MAX(1,LMW))
              ELSE
                CALL CGERC( JPBZ, LNW, TALPHA, WORK(IPT), 1,
     $                      WORK(JQBZ+1), 1, A(1,JQBZ+1), LDA )
                CALL PBCVECADD( ICONTXT, 'G', LMW*LNW, ZERO, DUMMY, 1,
     $                          ZERO, WORK(IPW), 1 )
                CALL CGERC( LMW, LNW, TALPHA, WORK(JPBZ+IPT), 1,
     $                      WORK(JQBZ+1), 1, WORK(IPW), MAX(1,LMW) )
              END IF
            END IF
*
*           Compute diagonal blocks.
*
            MZROW = MRROW
            MZCOL = MRCOL
            KI = 0
            IF( MYCOL.EQ.IACOL ) KZ = JZ
*
            DO 30 KJ = 0, LCMQ-1
   20          CONTINUE
               IF( MZROW.LT.MZCOL ) THEN
                  MZROW = MZROW + NPROW
                  KI = KI + 1
                  GO TO 20
               END IF
               KIZ = MAX( 0, KI*NB-IZ )
               KJZ = MAX( 0, KJ*NB-JZ )
               IF( KJZ.GE.LNW )
     $            GO TO 40
               FORM = 'G'
               IF( MZROW.EQ.MZCOL )
     $            FORM = 'H'
               MZCOL = MZCOL + NPCOL
               CALL PBCTRAD1( ICONTXT, 'Upper', FORM, KIZ, NB, KZ, ONE,
     $                        WORK( KJZ*LMW+IPW ), LMW, ONE,
     $                        A( JPBZ+1, JQBZ+KJZ+1 ), LDA,
     $                        LPBZ, LQBZ, LMW, LNW-KJZ )
               KZ = 0
   30        CONTINUE
          END IF
*
          JPBZ = JNPBZ
          JQBZ = JQBZ + LNW
          IZ = 0
          JZ = 0
   40   CONTINUE
*
*     If A is a Hermitian lower triangular matrix,
*
      ELSE
*
        ISZCMP = ICEIL( MULLEN, LQBZ )
        IF( ISZCMP.LE.0 ) ISZCMP = 1
        IPBZ = ISZCMP * LPBZ
        IQBZ = ISZCMP * LQBZ
        JPBZ = 0
        JQBZ = 0
*
        DO 70 JJ = 1, ICEIL(NQ+JZ, IQBZ)
          LMW = MIN( IPBZ-IZ, NP-JPBZ )
          LNW = MIN( IQBZ-JZ, NQ-JQBZ )
          JNPBZ = JPBZ + LMW
*
*         Modify (change) data in the upper triangular part
*
          IF( ASPACE ) THEN
*
*           if XYDIST = 'Column'
*
            IF( COLUMN ) THEN
              IF( XDATA ) THEN
                CALL CGERC( NP-JPBZ, LNW, ALPHA, X(JPBZ*INCX+1), INCX,
     $                      WORK(JQBZ+IPT), 1, A(JPBZ+1,JQBZ+1), LDA )
              ELSE
                CALL CGERC( NP-JPBZ, LNW, ALPHA, WORK(JPBZ+1), 1,
     $                      WORK(JQBZ+IPT), 1, A(JPBZ+1,JQBZ+1), LDA )
              END IF
*
*           if XYDIST = 'Row'
*
            ELSE
              IF( XDATA ) THEN
                CALL CGERC( NP-JPBZ, LNW, TALPHA, WORK(JPBZ+IPT), 1,
     $                      X(JQBZ*INCX+1), INCX, A(JPBZ+1,JQBZ+1), LDA)
              ELSE
                CALL CGERC( NP-JPBZ, LNW, TALPHA, WORK(JPBZ+IPT), 1,
     $                      WORK(JQBZ+1), 1, A(JPBZ+1,JQBZ+1), LDA )
              END IF
            END IF
*
*         Update data in the lower triangular matrix
*         and save data in the upper triangular matrix
*
          ELSE
*
*           if XYDIST = 'Column'
*
            IF( COLUMN ) THEN
              IF( XDATA ) THEN
                CALL CGERC( NP-JNPBZ, LNW, ALPHA, X(JNPBZ*INCX+1), INCX,
     $                      WORK(JQBZ+IPT), 1, A(JNPBZ+1,JQBZ+1), LDA )
                CALL PBCVECADD( ICONTXT, 'G', LMW*LNW, ZERO, DUMMY, 1,
     $                          ZERO, WORK(IPW), 1 )
                CALL CGERC( LMW, LNW, ALPHA, X(JPBZ*INCX+1), INCX,
     $                      WORK(JQBZ+IPT), 1, WORK(IPW), MAX(1,LMW) )
              ELSE
                CALL CGERC( NP-JNPBZ, LNW, ALPHA, WORK(JNPBZ+1), 1,
     $                      WORK(JQBZ+IPT), 1, A(JNPBZ+1,JQBZ+1), LDA )
                CALL PBCVECADD( ICONTXT, 'G', LMW*LNW, ZERO, DUMMY, 1,
     $                          ZERO, WORK(IPW), 1 )
                CALL CGERC( LMW, LNW, ALPHA, WORK(JPBZ+1), 1,
     $                      WORK(JQBZ+IPT), 1, WORK(IPW), MAX(1,LMW) )
              END IF
*
*           if XYDIST = 'Row'
*
            ELSE
              IF( XDATA ) THEN
                CALL CGERC( NP-JNPBZ, LNW, TALPHA, WORK(JNPBZ+IPT), 1,
     $                      X(JQBZ*INCX+1), INCX, A(JNPBZ+1,JQBZ+1),LDA)
                CALL PBCVECADD( ICONTXT, 'G', LMW*LNW, ZERO, DUMMY, 1,
     $                          ZERO, WORK(IPW), 1 )
                CALL CGERC( LMW, LNW, TALPHA, WORK(JPBZ+IPT), 1,
     $                      X(JQBZ*INCX+1), INCX, WORK(IPW), MAX(1,LMW))
              ELSE
                CALL CGERC( NP-JNPBZ, LNW, TALPHA, WORK(JNPBZ+IPT), 1,
     $                      WORK(JQBZ+1), 1, A(JNPBZ+1,JQBZ+1), LDA )
                CALL PBCVECADD( ICONTXT, 'G', LMW*LNW, ZERO, DUMMY, 1,
     $                          ZERO, WORK(IPW), 1 )
                CALL CGERC( LMW, LNW, TALPHA, WORK(JPBZ+IPT), 1,
     $                      WORK(JQBZ+1), 1, WORK(IPW), MAX(1,LMW) )
              END IF
            END IF
*
*           Compute diagonal blocks.
*
            MZROW = MRROW
            MZCOL = MRCOL
            KI = 0
            IF( MYCOL.EQ.IACOL ) KZ = JZ
*
            DO 60 KJ = 0, LCMQ-1
   50          CONTINUE
               IF( MZROW.LT.MZCOL ) THEN
                 MZROW = MZROW + NPROW
                 KI = KI + 1
                 GO TO 50
               END IF
               KIZ  = MAX( 0, KI*NB-IZ )
               KJZ  = MAX( 0, KJ*NB-JZ )
               IF( KJZ.GE.LNW )
     $            GO TO 70
               FORM = 'G'
               IF( MZROW.EQ.MZCOL )
     $            FORM = 'H'
               MZCOL = MZCOL + NPCOL
*
               CALL PBCTRAD1( ICONTXT, 'Lower', FORM, KIZ, NB, KZ, ONE,
     $                        WORK( KJZ*LMW+IPW ), LMW, ONE,
     $                        A( JPBZ+1, JQBZ+KJZ+1 ), LDA,
     $                        LPBZ, LQBZ, LMW, LNW-KJZ )
               KZ = 0
   60        CONTINUE
          END IF
*
          JPBZ = JNPBZ
          JQBZ = JQBZ + LNW
          IZ = 0
          JZ = 0
   70   CONTINUE
      END IF
*
   80 CONTINUE
*
*     PART 3: Transpose X' (X is already distributed)
*     ===============================================
*
      IF( COLUMN ) THEN
        IF( XDATA ) THEN
          CALL PBCTRNV( ICONTXT, 'Col', 'T', N, NB, NZ, X, INCX, ZERO,
     $                  WORK(IPT), 1, IAROW, -1, -1, IACOL, WORK(IPW) )
        ELSE
          CALL PBCTRNV( ICONTXT, 'Col', 'T', N, NB, NZ, WORK, 1, ZERO,
     $                  WORK(IPT), 1, IAROW, -1, -1, IACOL, WORK(IPW) )
        END IF
*
      ELSE
        IF( XDATA ) THEN
          CALL PBCTRNV( ICONTXT, 'Row', 'T', N, NB, NZ, X, INCX, ZERO,
     $                  WORK(IPT), 1, -1, IACOL, IAROW, -1, WORK(IPW) )
        ELSE
          CALL PBCTRNV( ICONTXT, 'Row', 'T', N, NB, NZ, WORK, 1, ZERO,
     $                  WORK(IPT), 1, -1, IACOL, IAROW, -1, WORK(IPW) )
        END IF
      END IF
*
*     PART 4: Update A with Y and X'
*     =====================================
*
      IF( NP.EQ.0 .OR. NQ.EQ.0 ) RETURN
      IF( MYROW.EQ.IAROW ) IZ = NZ
      IF( MYCOL.EQ.IACOL ) JZ = NZ
*
*     If A is a Hermitian upper triangular matrix,
*
      IF( UPPER ) THEN
        ISZCMP = ICEIL( MULLEN, LQBZ )
        IF( ISZCMP.LE.0 ) ISZCMP = 1
        IPBZ = ISZCMP * LPBZ
        IQBZ = ISZCMP * LQBZ
        JPBZ = 0
        JQBZ = 0
*
        DO 110 JJ = 1, ICEIL(NQ+JZ, IQBZ)
          LMW = MIN( IPBZ-IZ, NP-JPBZ )
          LNW = MIN( IQBZ-JZ, NQ-JQBZ )
          JNPBZ = JPBZ + LMW
*
*         Modify (change) data in the lower triangular part
*
          IF( ASPACE ) THEN
*
*           if XYDIST = 'Column'
*
            IF( COLUMN ) THEN
              IF( YDATA ) THEN
                CALL CGERC( JNPBZ, LNW, TALPHA, Y, INCY, WORK(JQBZ+IPT),
     $                      1, A(1,JQBZ+1), LDA )
              ELSE
                CALL CGERC( JNPBZ, LNW, TALPHA, WORK(IPY), 1,
     $                      WORK(JQBZ+IPT), 1, A(1,JQBZ+1), LDA )
              END IF
*
*           if XYDIST = 'Row'
*
            ELSE
              IF( YDATA ) THEN
                 CALL CGERC( JNPBZ, LNW, ALPHA, WORK(IPT), 1,
     $                       Y(JQBZ*INCY+1), INCY, A(1,JQBZ+1), LDA )
              ELSE
                 CALL CGERC( JNPBZ, LNW, ALPHA, WORK(IPT), 1,
     $                       WORK(JQBZ+IPY), 1, A(1,JQBZ+1), LDA )
              END IF
            END IF
*
*         Update data in the upper triangular matrix
*         and save data in the lower triangular matrix
*
          ELSE
*
*           if XYDIST = 'Column'
*
            IF( COLUMN ) THEN
              IF( YDATA ) THEN
                CALL CGERC( JPBZ, LNW, TALPHA, Y, INCY,
     $                      WORK(JQBZ+IPT), 1, A(1,JQBZ+1), LDA )
                CALL PBCVECADD( ICONTXT, 'G', LMW*LNW, ZERO, DUMMY, 1,
     $                          ZERO, WORK(IPW), 1 )
                CALL CGERC( LMW, LNW, TALPHA, Y(JPBZ*INCY+1), INCY,
     $                      WORK(JQBZ+IPT), 1, WORK(IPW), MAX(1,LMW) )
              ELSE
                CALL CGERC( JPBZ, LNW, TALPHA, WORK(IPY), 1,
     $                      WORK(JQBZ+IPT), 1, A(1,JQBZ+1), LDA )
                CALL PBCVECADD( ICONTXT, 'G', LMW*LNW, ZERO, DUMMY, 1,
     $                          ZERO, WORK(IPW), 1 )
                CALL CGERC( LMW, LNW, TALPHA, WORK(JPBZ+IPY), 1,
     $                      WORK(JQBZ+IPT), 1, WORK(IPW), MAX(1,LMW) )
              END IF
*
*           if XYDIST = 'Row'
*
            ELSE
              IF( YDATA ) THEN
                CALL CGERC( JPBZ, LNW, ALPHA, WORK(IPT), 1,
     $                      Y(JQBZ*INCY+1), INCY, A(1,JQBZ+1), LDA )
                CALL PBCVECADD( ICONTXT, 'G', LMW*LNW, ZERO, DUMMY, 1,
     $                          ZERO, WORK(IPW), 1 )
                CALL CGERC( LMW, LNW, ALPHA, WORK(JPBZ+IPT), 1,
     $                      Y(JQBZ*INCY+1), INCY, WORK(IPW), MAX(1,LMW))
              ELSE
                CALL CGERC( JPBZ, LNW, ALPHA, WORK(IPT), 1,
     $                      WORK(JQBZ+IPY), 1, A(1,JQBZ+1), LDA )
                CALL PBCVECADD( ICONTXT, 'G', LMW*LNW, ZERO, DUMMY, 1,
     $                          ZERO, WORK(IPW), 1 )
                CALL CGERC( LMW, LNW, ALPHA, WORK(JPBZ+IPT), 1,
     $                      WORK(JQBZ+IPY), 1, WORK(IPW), MAX(1,LMW) )
              END IF
            END IF
*
*           Compute diagonal blocks.
*
            MZROW = MRROW
            MZCOL = MRCOL
            KI = 0
            IF( MYCOL.EQ.IACOL ) KZ = JZ
*
            DO 100 KJ = 0, LCMQ-1
   90          CONTINUE
               IF( MZROW.LT.MZCOL ) THEN
                 MZROW = MZROW + NPROW
                 KI = KI + 1
                 GO TO 90
               END IF
               KIZ  = MAX( 0, KI*NB-IZ )
               KJZ  = MAX( 0, KJ*NB-JZ )
               IF( KJZ.GE.LNW )
     $            GO TO 110
               FORM = 'G'
               IF( MZROW.EQ.MZCOL )
     $            FORM = 'H'
               MZCOL = MZCOL + NPCOL
               CALL PBCTRAD1( ICONTXT, 'Upper', FORM, KIZ, NB, KZ, ONE,
     $                        WORK( KJZ*LMW+IPW ), LMW, ONE,
     $                        A( JPBZ+1, JQBZ+KJZ+1 ), LDA,
     $                        LPBZ, LQBZ, LMW, LNW-KJZ )
               KZ = 0
  100        CONTINUE
          END IF
*
          JPBZ = JNPBZ
          JQBZ = JQBZ + LNW
          IZ = 0
          JZ = 0
  110   CONTINUE
*
*     If A is a Hermitian lower triangular matrix,
*
      ELSE
*
        ISZCMP = ICEIL( MULLEN, LQBZ )
        IF( ISZCMP.LE.0 ) ISZCMP = 1
        IPBZ = ISZCMP * LPBZ
        IQBZ = ISZCMP * LQBZ
        JPBZ = 0
        JQBZ = 0
*
        DO 140 JJ = 1, ICEIL(NQ+JZ, IQBZ)
          LMW = MIN( IPBZ-IZ, NP-JPBZ )
          LNW = MIN( IQBZ-JZ, NQ-JQBZ )
          JNPBZ = JPBZ + LMW
*
*         Modify (change) data in the upper triangular part
*
          IF( ASPACE ) THEN
*
*           if XYDIST = 'Column'
*
            IF( COLUMN ) THEN
              IF( YDATA ) THEN
                CALL CGERC( NP-JPBZ, LNW, TALPHA, Y(JPBZ*INCY+1), INCY,
     $                      WORK(JQBZ+IPT), 1, A(JPBZ+1,JQBZ+1), LDA )
              ELSE
                CALL CGERC( NP-JPBZ, LNW, TALPHA, WORK(JPBZ+IPY), 1,
     $                      WORK(JQBZ+IPT), 1, A(JPBZ+1,JQBZ+1), LDA )
              END IF
*
*           if XYDIST = 'Row'
*
            ELSE
              IF( YDATA ) THEN
                CALL CGERC( NP-JPBZ, LNW, ALPHA, WORK(JPBZ+IPT), 1,
     $                      Y(JQBZ*INCY+1), INCY, A(JPBZ+1,JQBZ+1), LDA)
              ELSE
                CALL CGERC( NP-JPBZ, LNW, ALPHA, WORK(JPBZ+IPT), 1,
     $                      WORK(JQBZ+IPY), 1, A(JPBZ+1,JQBZ+1), LDA )
              END IF
            END IF
*
*         Update data in the lower triangular matrix
*         and save data in the upper triangular matrix
*
          ELSE
*
*           if XYDIST = 'Column'
*
            IF( COLUMN ) THEN
              IF( YDATA ) THEN
                CALL CGERC( NP-JNPBZ, LNW, TALPHA, Y(JNPBZ*INCY+1),
     $                      INCY, WORK(JQBZ+IPT), 1, A(JNPBZ+1,JQBZ+1),
     $                      LDA )
                CALL PBCVECADD( ICONTXT, 'G', LMW*LNW, ZERO, DUMMY, 1,
     $                          ZERO, WORK(IPW), 1 )
                CALL CGERC( LMW, LNW, TALPHA, Y(JPBZ*INCY+1), INCY,
     $                      WORK(JQBZ+IPT), 1, WORK(IPW), MAX(1,LMW) )
              ELSE
                CALL CGERC( NP-JNPBZ, LNW, TALPHA, WORK(JNPBZ+IPY), 1,
     $                      WORK(JQBZ+IPT), 1, A(JNPBZ+1,JQBZ+1), LDA )
                CALL PBCVECADD( ICONTXT, 'G', LMW*LNW, ZERO, DUMMY, 1,
     $                          ZERO, WORK(IPW), 1 )
                CALL CGERC( LMW, LNW, TALPHA, WORK(JPBZ+IPY), 1,
     $                      WORK(JQBZ+IPT), 1, WORK(IPW), MAX(1,LMW) )
              END IF
*
*           if XYDIST = 'Row'
*
            ELSE
              IF( YDATA ) THEN
                CALL CGERC( NP-JNPBZ, LNW, ALPHA, WORK(JNPBZ+IPT), 1,
     $                      Y(JQBZ*INCY+1), INCY, A(JNPBZ+1,JQBZ+1),LDA)
                CALL PBCVECADD( ICONTXT, 'G', LMW*LNW, ZERO, DUMMY, 1,
     $                          ZERO, WORK(IPW), 1 )
                CALL CGERC( LMW, LNW, ALPHA, WORK(JPBZ+IPT), 1,
     $                      Y(JQBZ*INCY+1), INCY, WORK(IPW), MAX(1,LMW))
              ELSE
                CALL CGERC( NP-JNPBZ, LNW, ALPHA, WORK(JNPBZ+IPT), 1,
     $                      WORK(JQBZ+IPY), 1, A(JNPBZ+1,JQBZ+1), LDA )
                CALL PBCVECADD( ICONTXT, 'G', LMW*LNW, ZERO, DUMMY, 1,
     $                          ZERO, WORK(IPW), 1 )
                CALL CGERC( LMW, LNW, ALPHA, WORK(JPBZ+IPT), 1,
     $                      WORK(JQBZ+IPY), 1, WORK(IPW), MAX(1,LMW) )
              END IF
            END IF
*
*           Compute diagonal blocks.
*
            MZROW = MRROW
            MZCOL = MRCOL
            KI = 0
            IF( MYCOL.EQ.IACOL ) KZ = JZ
*
            DO 130 KJ = 0, LCMQ-1
  120          CONTINUE
               IF( MZROW.LT.MZCOL ) THEN
                  MZROW = MZROW + NPROW
                  KI = KI + 1
                  GO TO 120
               END IF
               KIZ  = MAX( 0, KI*NB-IZ )
               KJZ  = MAX( 0, KJ*NB-JZ )
               IF( KJZ.GE.LNW )
     $            GO TO 140
               FORM = 'G'
               IF( MZROW.EQ.MZCOL )
     $            FORM = 'H'
               MZCOL = MZCOL + NPCOL
*
               CALL PBCTRAD1( ICONTXT, 'Lower', FORM, KIZ, NB, KZ, ONE,
     $                        WORK( KJZ*LMW+IPW ), LMW, ONE,
     $                        A( JPBZ+1, JQBZ+KJZ+1 ), LDA,
     $                        LPBZ, LQBZ, LMW, LNW-KJZ )
               KZ = 0
  130       CONTINUE
          END IF
*
          JPBZ = JNPBZ
          JQBZ = JQBZ + LNW
          IZ = 0
          JZ = 0
  140   CONTINUE
      END IF
*
      RETURN
*
*     End of PBCHER2
*
      END
